/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetworkSettings;
import io.fabric8.docker.api.model.NetworkSettings;
import io.fabric8.docker.api.model.NetworkSettingsFluent;
import io.fabric8.docker.api.model.NetworkSettingsFluentImpl;

public class NetworkSettingsBuilder
extends NetworkSettingsFluentImpl<NetworkSettingsBuilder>
implements VisitableBuilder<NetworkSettings, NetworkSettingsBuilder> {
    NetworkSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSettingsBuilder() {
        this(true);
    }

    public NetworkSettingsBuilder(Boolean validationEnabled) {
        this(new NetworkSettings(), validationEnabled);
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkSettings(), validationEnabled);
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent, NetworkSettings instance) {
        this(fluent, instance, true);
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent, NetworkSettings instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEndpointID(instance.getEndpointID());
        fluent.withGateway(instance.getGateway());
        fluent.withGlobalIPv6Address(instance.getGlobalIPv6Address());
        fluent.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen());
        fluent.withIPAddress(instance.getIPAddress());
        fluent.withIPPrefixLen(instance.getIPPrefixLen());
        fluent.withIPv6Gateway(instance.getIPv6Gateway());
        fluent.withMacAddress(instance.getMacAddress());
        fluent.withBridge(instance.getBridge());
        fluent.withSandboxID(instance.getSandboxID());
        fluent.withHairpinMode(instance.getHairpinMode());
        fluent.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address());
        fluent.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen());
        fluent.withPorts(instance.getPorts());
        fluent.withSandboxKey(instance.getSandboxKey());
        fluent.withSecondaryIPAddresses(instance.getSecondaryIPAddresses());
        fluent.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses());
        fluent.withNetworks(instance.getNetworks());
        this.validationEnabled = validationEnabled;
    }

    public NetworkSettingsBuilder(NetworkSettings instance) {
        this(instance, (Boolean)true);
    }

    public NetworkSettingsBuilder(NetworkSettings instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEndpointID(instance.getEndpointID());
        this.withGateway(instance.getGateway());
        this.withGlobalIPv6Address(instance.getGlobalIPv6Address());
        this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen());
        this.withIPAddress(instance.getIPAddress());
        this.withIPPrefixLen(instance.getIPPrefixLen());
        this.withIPv6Gateway(instance.getIPv6Gateway());
        this.withMacAddress(instance.getMacAddress());
        this.withBridge(instance.getBridge());
        this.withSandboxID(instance.getSandboxID());
        this.withHairpinMode(instance.getHairpinMode());
        this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address());
        this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen());
        this.withPorts(instance.getPorts());
        this.withSandboxKey(instance.getSandboxKey());
        this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses());
        this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses());
        this.withNetworks(instance.getNetworks());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableNetworkSettings build() {
        EditableNetworkSettings buildable = new EditableNetworkSettings(this.fluent.getEndpointID(), this.fluent.getGateway(), this.fluent.getGlobalIPv6Address(), this.fluent.getGlobalIPv6PrefixLen(), this.fluent.getIPAddress(), this.fluent.getIPPrefixLen(), this.fluent.getIPv6Gateway(), this.fluent.getMacAddress(), this.fluent.getBridge(), this.fluent.getSandboxID(), this.fluent.isHairpinMode(), this.fluent.getLinkLocalIPv6Address(), this.fluent.getLinkLocalIPv6PrefixLen(), this.fluent.getPorts(), this.fluent.getSandboxKey(), this.fluent.getSecondaryIPAddresses(), this.fluent.getSecondaryIPv6Addresses(), this.fluent.getNetworks());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSettingsBuilder that = (NetworkSettingsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

