/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.model.IPAM;
import io.fabric8.docker.api.model.IPAMBuilder;
import io.fabric8.docker.api.model.IPAMFluentImpl;
import io.fabric8.docker.api.model.NetworkCreate;
import io.fabric8.docker.api.model.NetworkCreateFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class NetworkCreateFluentImpl<A extends NetworkCreateFluent<A>>
extends BaseFluent<A>
implements NetworkCreateFluent<A> {
    private Boolean CheckDuplicate;
    private String Driver;
    private IPAMBuilder IPAM;
    private String Name;
    private Map<String, String> Options = new LinkedHashMap<String, String>();

    public NetworkCreateFluentImpl() {
    }

    public NetworkCreateFluentImpl(NetworkCreate instance) {
        this.withCheckDuplicate(instance.getCheckDuplicate());
        this.withDriver(instance.getDriver());
        this.withIPAM(instance.getIPAM());
        this.withName(instance.getName());
        this.withOptions(instance.getOptions());
    }

    @Override
    public Boolean isCheckDuplicate() {
        return this.CheckDuplicate;
    }

    @Override
    public A withCheckDuplicate(Boolean CheckDuplicate) {
        this.CheckDuplicate = CheckDuplicate;
        return (A)this;
    }

    @Override
    public Boolean hasCheckDuplicate() {
        return this.CheckDuplicate != null;
    }

    @Override
    public String getDriver() {
        return this.Driver;
    }

    @Override
    public A withDriver(String Driver) {
        this.Driver = Driver;
        return (A)this;
    }

    @Override
    public Boolean hasDriver() {
        return this.Driver != null;
    }

    @Override
    @Deprecated
    public IPAM getIPAM() {
        return this.IPAM != null ? this.IPAM.build() : null;
    }

    @Override
    public IPAM buildIPAM() {
        return this.IPAM != null ? this.IPAM.build() : null;
    }

    @Override
    public A withIPAM(IPAM IPAM2) {
        this._visitables.remove(this.IPAM);
        if (IPAM2 != null) {
            this.IPAM = new IPAMBuilder(IPAM2);
            this._visitables.add(this.IPAM);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIPAM() {
        return this.IPAM != null;
    }

    @Override
    public NetworkCreateFluent.IPAMNested<A> withNewIPAM() {
        return new IPAMNestedImpl();
    }

    @Override
    public NetworkCreateFluent.IPAMNested<A> withNewIPAMLike(IPAM item) {
        return new IPAMNestedImpl(item);
    }

    @Override
    public NetworkCreateFluent.IPAMNested<A> editIPAM() {
        return this.withNewIPAMLike(this.getIPAM());
    }

    @Override
    public NetworkCreateFluent.IPAMNested<A> editOrNewIPAM() {
        return this.withNewIPAMLike(this.getIPAM() != null ? this.getIPAM() : new IPAMBuilder().build());
    }

    @Override
    public NetworkCreateFluent.IPAMNested<A> editOrNewIPAMLike(IPAM item) {
        return this.withNewIPAMLike(this.getIPAM() != null ? this.getIPAM() : item);
    }

    @Override
    public String getName() {
        return this.Name;
    }

    @Override
    public A withName(String Name) {
        this.Name = Name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.Name != null;
    }

    @Override
    public A addToOptions(String key, String value) {
        if (key != null && value != null) {
            this.Options.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOptions(Map<String, String> map) {
        if (map != null) {
            this.Options.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(String key) {
        if (key != null) {
            this.Options.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.Options.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.Options;
    }

    @Override
    public A withOptions(Map<String, String> Options) {
        this.Options.clear();
        if (Options != null) {
            this.Options.putAll(Options);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.Options != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkCreateFluentImpl that = (NetworkCreateFluentImpl)o;
        if (this.CheckDuplicate != null ? !this.CheckDuplicate.equals(that.CheckDuplicate) : that.CheckDuplicate != null) {
            return false;
        }
        if (this.Driver != null ? !this.Driver.equals(that.Driver) : that.Driver != null) {
            return false;
        }
        if (this.IPAM != null ? !this.IPAM.equals(that.IPAM) : that.IPAM != null) {
            return false;
        }
        if (this.Name != null ? !this.Name.equals(that.Name) : that.Name != null) {
            return false;
        }
        return !(this.Options != null ? !this.Options.equals(that.Options) : that.Options != null);
    }

    public class IPAMNestedImpl<N>
    extends IPAMFluentImpl<NetworkCreateFluent.IPAMNested<N>>
    implements NetworkCreateFluent.IPAMNested<N>,
    Nested<N> {
        private final IPAMBuilder builder;

        IPAMNestedImpl(IPAM item) {
            this.builder = new IPAMBuilder(this, item);
        }

        IPAMNestedImpl() {
            this.builder = new IPAMBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkCreateFluentImpl.this.withIPAM(this.builder.build());
        }

        @Override
        public N endIPAM() {
            return this.and();
        }
    }
}

