/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableLogConfig;
import io.fabric8.docker.api.model.LogConfig;
import io.fabric8.docker.api.model.LogConfigFluent;
import io.fabric8.docker.api.model.LogConfigFluentImpl;

public class LogConfigBuilder
extends LogConfigFluentImpl<LogConfigBuilder>
implements VisitableBuilder<LogConfig, LogConfigBuilder> {
    LogConfigFluent<?> fluent;
    Boolean validationEnabled;

    public LogConfigBuilder() {
        this(true);
    }

    public LogConfigBuilder(Boolean validationEnabled) {
        this(new LogConfig(), validationEnabled);
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LogConfig(), validationEnabled);
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent, LogConfig instance) {
        this(fluent, instance, true);
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent, LogConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfig(instance.getConfig());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public LogConfigBuilder(LogConfig instance) {
        this(instance, (Boolean)true);
    }

    public LogConfigBuilder(LogConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfig(instance.getConfig());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableLogConfig build() {
        EditableLogConfig buildable = new EditableLogConfig(this.fluent.getConfig(), this.fluent.getType());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogConfigBuilder that = (LogConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

