/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.Config;
import io.fabric8.docker.api.model.ConfigBuilder;
import io.fabric8.docker.api.model.ConfigFluentImpl;
import io.fabric8.docker.api.model.GraphDriverData;
import io.fabric8.docker.api.model.GraphDriverDataBuilder;
import io.fabric8.docker.api.model.GraphDriverDataFluentImpl;
import io.fabric8.docker.api.model.ImageInspect;
import io.fabric8.docker.api.model.ImageInspectFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageInspectFluentImpl<A extends ImageInspectFluent<A>>
extends BaseFluent<A>
implements ImageInspectFluent<A> {
    private String Architecture;
    private String Author;
    private String Comment;
    private ConfigBuilder Config;
    private String Container;
    private ConfigBuilder ContainerConfig;
    private String Created;
    private String DockerVersion;
    private GraphDriverDataBuilder GraphDriver;
    private String Id;
    private String Os;
    private String Parent;
    private List<String> RepoDigests = new ArrayList<String>();
    private List<String> RepoTags = new ArrayList<String>();
    private Long Size;
    private Long VirtualSize;

    public ImageInspectFluentImpl() {
    }

    public ImageInspectFluentImpl(ImageInspect instance) {
        this.withArchitecture(instance.getArchitecture());
        this.withAuthor(instance.getAuthor());
        this.withComment(instance.getComment());
        this.withConfig(instance.getConfig());
        this.withContainer(instance.getContainer());
        this.withContainerConfig(instance.getContainerConfig());
        this.withCreated(instance.getCreated());
        this.withDockerVersion(instance.getDockerVersion());
        this.withGraphDriver(instance.getGraphDriver());
        this.withId(instance.getId());
        this.withOs(instance.getOs());
        this.withParent(instance.getParent());
        this.withRepoDigests(instance.getRepoDigests());
        this.withRepoTags(instance.getRepoTags());
        this.withSize(instance.getSize());
        this.withVirtualSize(instance.getVirtualSize());
    }

    @Override
    public String getArchitecture() {
        return this.Architecture;
    }

    @Override
    public A withArchitecture(String Architecture) {
        this.Architecture = Architecture;
        return (A)this;
    }

    @Override
    public Boolean hasArchitecture() {
        return this.Architecture != null;
    }

    @Override
    public String getAuthor() {
        return this.Author;
    }

    @Override
    public A withAuthor(String Author) {
        this.Author = Author;
        return (A)this;
    }

    @Override
    public Boolean hasAuthor() {
        return this.Author != null;
    }

    @Override
    public String getComment() {
        return this.Comment;
    }

    @Override
    public A withComment(String Comment) {
        this.Comment = Comment;
        return (A)this;
    }

    @Override
    public Boolean hasComment() {
        return this.Comment != null;
    }

    @Override
    @Deprecated
    public Config getConfig() {
        return this.Config != null ? this.Config.build() : null;
    }

    @Override
    public Config buildConfig() {
        return this.Config != null ? this.Config.build() : null;
    }

    @Override
    public A withConfig(Config Config2) {
        this._visitables.remove(this.Config);
        if (Config2 != null) {
            this.Config = new ConfigBuilder(Config2);
            this._visitables.add(this.Config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.Config != null;
    }

    @Override
    public ImageInspectFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public ImageInspectFluent.ConfigNested<A> withNewConfigLike(Config item) {
        return new ConfigNestedImpl(item);
    }

    @Override
    public ImageInspectFluent.ConfigNested<A> editConfig() {
        return this.withNewConfigLike(this.getConfig());
    }

    @Override
    public ImageInspectFluent.ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : new ConfigBuilder().build());
    }

    @Override
    public ImageInspectFluent.ConfigNested<A> editOrNewConfigLike(Config item) {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : item);
    }

    @Override
    public String getContainer() {
        return this.Container;
    }

    @Override
    public A withContainer(String Container2) {
        this.Container = Container2;
        return (A)this;
    }

    @Override
    public Boolean hasContainer() {
        return this.Container != null;
    }

    @Override
    @Deprecated
    public Config getContainerConfig() {
        return this.ContainerConfig != null ? this.ContainerConfig.build() : null;
    }

    @Override
    public Config buildContainerConfig() {
        return this.ContainerConfig != null ? this.ContainerConfig.build() : null;
    }

    @Override
    public A withContainerConfig(Config ContainerConfig) {
        this._visitables.remove(this.ContainerConfig);
        if (ContainerConfig != null) {
            this.ContainerConfig = new ConfigBuilder(ContainerConfig);
            this._visitables.add(this.ContainerConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerConfig() {
        return this.ContainerConfig != null;
    }

    @Override
    public ImageInspectFluent.ContainerConfigNested<A> withNewContainerConfig() {
        return new ContainerConfigNestedImpl();
    }

    @Override
    public ImageInspectFluent.ContainerConfigNested<A> withNewContainerConfigLike(Config item) {
        return new ContainerConfigNestedImpl(item);
    }

    @Override
    public ImageInspectFluent.ContainerConfigNested<A> editContainerConfig() {
        return this.withNewContainerConfigLike(this.getContainerConfig());
    }

    @Override
    public ImageInspectFluent.ContainerConfigNested<A> editOrNewContainerConfig() {
        return this.withNewContainerConfigLike(this.getContainerConfig() != null ? this.getContainerConfig() : new ConfigBuilder().build());
    }

    @Override
    public ImageInspectFluent.ContainerConfigNested<A> editOrNewContainerConfigLike(Config item) {
        return this.withNewContainerConfigLike(this.getContainerConfig() != null ? this.getContainerConfig() : item);
    }

    @Override
    public String getCreated() {
        return this.Created;
    }

    @Override
    public A withCreated(String Created) {
        this.Created = Created;
        return (A)this;
    }

    @Override
    public Boolean hasCreated() {
        return this.Created != null;
    }

    @Override
    public String getDockerVersion() {
        return this.DockerVersion;
    }

    @Override
    public A withDockerVersion(String DockerVersion) {
        this.DockerVersion = DockerVersion;
        return (A)this;
    }

    @Override
    public Boolean hasDockerVersion() {
        return this.DockerVersion != null;
    }

    @Override
    @Deprecated
    public GraphDriverData getGraphDriver() {
        return this.GraphDriver != null ? this.GraphDriver.build() : null;
    }

    @Override
    public GraphDriverData buildGraphDriver() {
        return this.GraphDriver != null ? this.GraphDriver.build() : null;
    }

    @Override
    public A withGraphDriver(GraphDriverData GraphDriver) {
        this._visitables.remove(this.GraphDriver);
        if (GraphDriver != null) {
            this.GraphDriver = new GraphDriverDataBuilder(GraphDriver);
            this._visitables.add(this.GraphDriver);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGraphDriver() {
        return this.GraphDriver != null;
    }

    @Override
    public ImageInspectFluent.GraphDriverNested<A> withNewGraphDriver() {
        return new GraphDriverNestedImpl();
    }

    @Override
    public ImageInspectFluent.GraphDriverNested<A> withNewGraphDriverLike(GraphDriverData item) {
        return new GraphDriverNestedImpl(item);
    }

    @Override
    public ImageInspectFluent.GraphDriverNested<A> editGraphDriver() {
        return this.withNewGraphDriverLike(this.getGraphDriver());
    }

    @Override
    public ImageInspectFluent.GraphDriverNested<A> editOrNewGraphDriver() {
        return this.withNewGraphDriverLike(this.getGraphDriver() != null ? this.getGraphDriver() : new GraphDriverDataBuilder().build());
    }

    @Override
    public ImageInspectFluent.GraphDriverNested<A> editOrNewGraphDriverLike(GraphDriverData item) {
        return this.withNewGraphDriverLike(this.getGraphDriver() != null ? this.getGraphDriver() : item);
    }

    @Override
    public String getId() {
        return this.Id;
    }

    @Override
    public A withId(String Id) {
        this.Id = Id;
        return (A)this;
    }

    @Override
    public Boolean hasId() {
        return this.Id != null;
    }

    @Override
    public String getOs() {
        return this.Os;
    }

    @Override
    public A withOs(String Os) {
        this.Os = Os;
        return (A)this;
    }

    @Override
    public Boolean hasOs() {
        return this.Os != null;
    }

    @Override
    public String getParent() {
        return this.Parent;
    }

    @Override
    public A withParent(String Parent) {
        this.Parent = Parent;
        return (A)this;
    }

    @Override
    public Boolean hasParent() {
        return this.Parent != null;
    }

    @Override
    public A addToRepoDigests(int index, String item) {
        this.RepoDigests.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRepoDigests(int index, String item) {
        this.RepoDigests.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRepoDigests(String ... items) {
        for (String item : items) {
            this.RepoDigests.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRepoDigests(Collection<String> items) {
        for (String item : items) {
            this.RepoDigests.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRepoDigests(String ... items) {
        for (String item : items) {
            this.RepoDigests.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRepoDigests(Collection<String> items) {
        for (String item : items) {
            this.RepoDigests.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRepoDigests() {
        return this.RepoDigests;
    }

    @Override
    public String getRepoDigest(int index) {
        return this.RepoDigests.get(index);
    }

    @Override
    public String getFirstRepoDigest() {
        return this.RepoDigests.get(0);
    }

    @Override
    public String getLastRepoDigest() {
        return this.RepoDigests.get(this.RepoDigests.size() - 1);
    }

    @Override
    public String getMatchingRepoDigest(Predicate<String> predicate) {
        for (String item : this.RepoDigests) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withRepoDigests(List<String> RepoDigests) {
        this.RepoDigests.clear();
        if (RepoDigests != null) {
            for (String item : RepoDigests) {
                this.addToRepoDigests(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRepoDigests(String ... RepoDigests) {
        this.RepoDigests.clear();
        if (RepoDigests != null) {
            for (String item : RepoDigests) {
                this.addToRepoDigests(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepoDigests() {
        return this.RepoDigests != null && !this.RepoDigests.isEmpty();
    }

    @Override
    public A addToRepoTags(int index, String item) {
        this.RepoTags.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRepoTags(int index, String item) {
        this.RepoTags.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRepoTags(String ... items) {
        for (String item : items) {
            this.RepoTags.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRepoTags(Collection<String> items) {
        for (String item : items) {
            this.RepoTags.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRepoTags(String ... items) {
        for (String item : items) {
            this.RepoTags.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRepoTags(Collection<String> items) {
        for (String item : items) {
            this.RepoTags.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRepoTags() {
        return this.RepoTags;
    }

    @Override
    public String getRepoTag(int index) {
        return this.RepoTags.get(index);
    }

    @Override
    public String getFirstRepoTag() {
        return this.RepoTags.get(0);
    }

    @Override
    public String getLastRepoTag() {
        return this.RepoTags.get(this.RepoTags.size() - 1);
    }

    @Override
    public String getMatchingRepoTag(Predicate<String> predicate) {
        for (String item : this.RepoTags) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withRepoTags(List<String> RepoTags) {
        this.RepoTags.clear();
        if (RepoTags != null) {
            for (String item : RepoTags) {
                this.addToRepoTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRepoTags(String ... RepoTags) {
        this.RepoTags.clear();
        if (RepoTags != null) {
            for (String item : RepoTags) {
                this.addToRepoTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepoTags() {
        return this.RepoTags != null && !this.RepoTags.isEmpty();
    }

    @Override
    public Long getSize() {
        return this.Size;
    }

    @Override
    public A withSize(Long Size) {
        this.Size = Size;
        return (A)this;
    }

    @Override
    public Boolean hasSize() {
        return this.Size != null;
    }

    @Override
    public Long getVirtualSize() {
        return this.VirtualSize;
    }

    @Override
    public A withVirtualSize(Long VirtualSize) {
        this.VirtualSize = VirtualSize;
        return (A)this;
    }

    @Override
    public Boolean hasVirtualSize() {
        return this.VirtualSize != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageInspectFluentImpl that = (ImageInspectFluentImpl)o;
        if (this.Architecture != null ? !this.Architecture.equals(that.Architecture) : that.Architecture != null) {
            return false;
        }
        if (this.Author != null ? !this.Author.equals(that.Author) : that.Author != null) {
            return false;
        }
        if (this.Comment != null ? !this.Comment.equals(that.Comment) : that.Comment != null) {
            return false;
        }
        if (this.Config != null ? !this.Config.equals(that.Config) : that.Config != null) {
            return false;
        }
        if (this.Container != null ? !this.Container.equals(that.Container) : that.Container != null) {
            return false;
        }
        if (this.ContainerConfig != null ? !this.ContainerConfig.equals(that.ContainerConfig) : that.ContainerConfig != null) {
            return false;
        }
        if (this.Created != null ? !this.Created.equals(that.Created) : that.Created != null) {
            return false;
        }
        if (this.DockerVersion != null ? !this.DockerVersion.equals(that.DockerVersion) : that.DockerVersion != null) {
            return false;
        }
        if (this.GraphDriver != null ? !this.GraphDriver.equals(that.GraphDriver) : that.GraphDriver != null) {
            return false;
        }
        if (this.Id != null ? !this.Id.equals(that.Id) : that.Id != null) {
            return false;
        }
        if (this.Os != null ? !this.Os.equals(that.Os) : that.Os != null) {
            return false;
        }
        if (this.Parent != null ? !this.Parent.equals(that.Parent) : that.Parent != null) {
            return false;
        }
        if (this.RepoDigests != null ? !this.RepoDigests.equals(that.RepoDigests) : that.RepoDigests != null) {
            return false;
        }
        if (this.RepoTags != null ? !this.RepoTags.equals(that.RepoTags) : that.RepoTags != null) {
            return false;
        }
        if (this.Size != null ? !this.Size.equals(that.Size) : that.Size != null) {
            return false;
        }
        return !(this.VirtualSize != null ? !this.VirtualSize.equals(that.VirtualSize) : that.VirtualSize != null);
    }

    public class GraphDriverNestedImpl<N>
    extends GraphDriverDataFluentImpl<ImageInspectFluent.GraphDriverNested<N>>
    implements ImageInspectFluent.GraphDriverNested<N>,
    Nested<N> {
        private final GraphDriverDataBuilder builder;

        GraphDriverNestedImpl(GraphDriverData item) {
            this.builder = new GraphDriverDataBuilder(this, item);
        }

        GraphDriverNestedImpl() {
            this.builder = new GraphDriverDataBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageInspectFluentImpl.this.withGraphDriver(this.builder.build());
        }

        @Override
        public N endGraphDriver() {
            return this.and();
        }
    }

    public class ContainerConfigNestedImpl<N>
    extends ConfigFluentImpl<ImageInspectFluent.ContainerConfigNested<N>>
    implements ImageInspectFluent.ContainerConfigNested<N>,
    Nested<N> {
        private final ConfigBuilder builder;

        ContainerConfigNestedImpl(Config item) {
            this.builder = new ConfigBuilder(this, item);
        }

        ContainerConfigNestedImpl() {
            this.builder = new ConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageInspectFluentImpl.this.withContainerConfig(this.builder.build());
        }

        @Override
        public N endContainerConfig() {
            return this.and();
        }
    }

    public class ConfigNestedImpl<N>
    extends ConfigFluentImpl<ImageInspectFluent.ConfigNested<N>>
    implements ImageInspectFluent.ConfigNested<N>,
    Nested<N> {
        private final ConfigBuilder builder;

        ConfigNestedImpl(Config item) {
            this.builder = new ConfigBuilder(this, item);
        }

        ConfigNestedImpl() {
            this.builder = new ConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageInspectFluentImpl.this.withConfig(this.builder.build());
        }

        @Override
        public N endConfig() {
            return this.and();
        }
    }
}

