/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableIPAMConfig;
import io.fabric8.docker.api.model.IPAMConfig;
import io.fabric8.docker.api.model.IPAMConfigFluent;
import io.fabric8.docker.api.model.IPAMConfigFluentImpl;

public class IPAMConfigBuilder
extends IPAMConfigFluentImpl<IPAMConfigBuilder>
implements VisitableBuilder<IPAMConfig, IPAMConfigBuilder> {
    IPAMConfigFluent<?> fluent;
    Boolean validationEnabled;

    public IPAMConfigBuilder() {
        this(true);
    }

    public IPAMConfigBuilder(Boolean validationEnabled) {
        this(new IPAMConfig(), validationEnabled);
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IPAMConfig(), validationEnabled);
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent, IPAMConfig instance) {
        this(fluent, instance, true);
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent, IPAMConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAuxiliaryAddresses(instance.getAuxiliaryAddresses());
        fluent.withGateway(instance.getGateway());
        fluent.withIPRange(instance.getIPRange());
        fluent.withSubnet(instance.getSubnet());
        this.validationEnabled = validationEnabled;
    }

    public IPAMConfigBuilder(IPAMConfig instance) {
        this(instance, (Boolean)true);
    }

    public IPAMConfigBuilder(IPAMConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAuxiliaryAddresses(instance.getAuxiliaryAddresses());
        this.withGateway(instance.getGateway());
        this.withIPRange(instance.getIPRange());
        this.withSubnet(instance.getSubnet());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableIPAMConfig build() {
        EditableIPAMConfig buildable = new EditableIPAMConfig(this.fluent.getAuxiliaryAddresses(), this.fluent.getGateway(), this.fluent.getIPRange(), this.fluent.getSubnet());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPAMConfigBuilder that = (IPAMConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

