/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableIPAM;
import io.fabric8.docker.api.model.IPAM;
import io.fabric8.docker.api.model.IPAMFluent;
import io.fabric8.docker.api.model.IPAMFluentImpl;

public class IPAMBuilder
extends IPAMFluentImpl<IPAMBuilder>
implements VisitableBuilder<IPAM, IPAMBuilder> {
    IPAMFluent<?> fluent;
    Boolean validationEnabled;

    public IPAMBuilder() {
        this(true);
    }

    public IPAMBuilder(Boolean validationEnabled) {
        this(new IPAM(), validationEnabled);
    }

    public IPAMBuilder(IPAMFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IPAMBuilder(IPAMFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IPAM(), validationEnabled);
    }

    public IPAMBuilder(IPAMFluent<?> fluent, IPAM instance) {
        this(fluent, instance, true);
    }

    public IPAMBuilder(IPAMFluent<?> fluent, IPAM instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfig(instance.getConfig());
        fluent.withDriver(instance.getDriver());
        this.validationEnabled = validationEnabled;
    }

    public IPAMBuilder(IPAM instance) {
        this(instance, (Boolean)true);
    }

    public IPAMBuilder(IPAM instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfig(instance.getConfig());
        this.withDriver(instance.getDriver());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableIPAM build() {
        EditableIPAM buildable = new EditableIPAM(this.fluent.getConfig(), this.fluent.getDriver());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPAMBuilder that = (IPAMBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

