/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.DeviceMapping;
import io.fabric8.docker.api.model.DeviceMappingBuilder;
import io.fabric8.docker.api.model.DeviceMappingFluentImpl;
import io.fabric8.docker.api.model.HostConfig;
import io.fabric8.docker.api.model.HostConfigFluent;
import io.fabric8.docker.api.model.LogConfig;
import io.fabric8.docker.api.model.LogConfigBuilder;
import io.fabric8.docker.api.model.LogConfigFluentImpl;
import io.fabric8.docker.api.model.LxcConfig;
import io.fabric8.docker.api.model.PortBinding;
import io.fabric8.docker.api.model.RestartPolicy;
import io.fabric8.docker.api.model.RestartPolicyBuilder;
import io.fabric8.docker.api.model.RestartPolicyFluentImpl;
import io.fabric8.docker.api.model.Ulimit;
import io.fabric8.docker.api.model.UlimitBuilder;
import io.fabric8.docker.api.model.UlimitFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HostConfigFluentImpl<A extends HostConfigFluent<A>>
extends BaseFluent<A>
implements HostConfigFluent<A> {
    private List<String> Binds = new ArrayList<String>();
    private Integer BlkioWeight;
    private List<String> CapAdd = new ArrayList<String>();
    private List<String> CapDrop = new ArrayList<String>();
    private String CgroupParent;
    private Object ConsoleSize;
    private String ContainerIDFile;
    private Long CpuPeriod;
    private Long CpuQuota;
    private Long CpuShares;
    private String CpusetCpus;
    private String CpusetMems;
    private List<DeviceMappingBuilder> Devices = new ArrayList<DeviceMappingBuilder>();
    private List<String> Dns = new ArrayList<String>();
    private List<String> DnsOptions = new ArrayList<String>();
    private List<String> DnsSearch = new ArrayList<String>();
    private List<String> ExtraHosts = new ArrayList<String>();
    private List<String> GroupAdd = new ArrayList<String>();
    private String IpcMode;
    private Long KernelMemory;
    private List<String> Links = new ArrayList<String>();
    private LogConfigBuilder LogConfig;
    private LxcConfig LxcConf;
    private Long Memory;
    private Long MemoryReservation;
    private Long MemorySwap;
    private Long MemorySwappiness;
    private String NetworkMode;
    private Boolean OomKillDisable;
    private String PidMode;
    private Map<String, ArrayList<PortBinding>> PortBindings = new LinkedHashMap<String, ArrayList<PortBinding>>();
    private Boolean Privileged;
    private Boolean PublishAllPorts;
    private Boolean ReadonlyRootfs;
    private RestartPolicyBuilder RestartPolicy;
    private List<String> SecurityOpt = new ArrayList<String>();
    private String UTSMode;
    private List<UlimitBuilder> Ulimits = new ArrayList<UlimitBuilder>();
    private String VolumeDriver;
    private List<String> VolumesFrom = new ArrayList<String>();

    public HostConfigFluentImpl() {
    }

    public HostConfigFluentImpl(HostConfig instance) {
        this.withBinds(instance.getBinds());
        this.withBlkioWeight(instance.getBlkioWeight());
        this.withCapAdd(instance.getCapAdd());
        this.withCapDrop(instance.getCapDrop());
        this.withCgroupParent(instance.getCgroupParent());
        this.withConsoleSize(instance.getConsoleSize());
        this.withContainerIDFile(instance.getContainerIDFile());
        this.withCpuPeriod(instance.getCpuPeriod());
        this.withCpuQuota(instance.getCpuQuota());
        this.withCpuShares(instance.getCpuShares());
        this.withCpusetCpus(instance.getCpusetCpus());
        this.withCpusetMems(instance.getCpusetMems());
        this.withDevices(instance.getDevices());
        this.withDns(instance.getDns());
        this.withDnsOptions(instance.getDnsOptions());
        this.withDnsSearch(instance.getDnsSearch());
        this.withExtraHosts(instance.getExtraHosts());
        this.withGroupAdd(instance.getGroupAdd());
        this.withIpcMode(instance.getIpcMode());
        this.withKernelMemory(instance.getKernelMemory());
        this.withLinks(instance.getLinks());
        this.withLogConfig(instance.getLogConfig());
        this.withLxcConf(instance.getLxcConf());
        this.withMemory(instance.getMemory());
        this.withMemoryReservation(instance.getMemoryReservation());
        this.withMemorySwap(instance.getMemorySwap());
        this.withMemorySwappiness(instance.getMemorySwappiness());
        this.withNetworkMode(instance.getNetworkMode());
        this.withOomKillDisable(instance.getOomKillDisable());
        this.withPidMode(instance.getPidMode());
        this.withPortBindings(instance.getPortBindings());
        this.withPrivileged(instance.getPrivileged());
        this.withPublishAllPorts(instance.getPublishAllPorts());
        this.withReadonlyRootfs(instance.getReadonlyRootfs());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withSecurityOpt(instance.getSecurityOpt());
        this.withUTSMode(instance.getUTSMode());
        this.withUlimits(instance.getUlimits());
        this.withVolumeDriver(instance.getVolumeDriver());
        this.withVolumesFrom(instance.getVolumesFrom());
    }

    @Override
    public A addToBinds(int index, String item) {
        this.Binds.add(index, item);
        return (A)this;
    }

    @Override
    public A setToBinds(int index, String item) {
        this.Binds.set(index, item);
        return (A)this;
    }

    @Override
    public A addToBinds(String ... items) {
        for (String item : items) {
            this.Binds.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToBinds(Collection<String> items) {
        for (String item : items) {
            this.Binds.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBinds(String ... items) {
        for (String item : items) {
            this.Binds.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBinds(Collection<String> items) {
        for (String item : items) {
            this.Binds.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getBinds() {
        return this.Binds;
    }

    @Override
    public String getBind(int index) {
        return this.Binds.get(index);
    }

    @Override
    public String getFirstBind() {
        return this.Binds.get(0);
    }

    @Override
    public String getLastBind() {
        return this.Binds.get(this.Binds.size() - 1);
    }

    @Override
    public String getMatchingBind(Predicate<String> predicate) {
        for (String item : this.Binds) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withBinds(List<String> Binds) {
        this.Binds.clear();
        if (Binds != null) {
            for (String item : Binds) {
                this.addToBinds(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withBinds(String ... Binds) {
        this.Binds.clear();
        if (Binds != null) {
            for (String item : Binds) {
                this.addToBinds(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBinds() {
        return this.Binds != null && !this.Binds.isEmpty();
    }

    @Override
    public Integer getBlkioWeight() {
        return this.BlkioWeight;
    }

    @Override
    public A withBlkioWeight(Integer BlkioWeight) {
        this.BlkioWeight = BlkioWeight;
        return (A)this;
    }

    @Override
    public Boolean hasBlkioWeight() {
        return this.BlkioWeight != null;
    }

    @Override
    public A addToCapAdd(int index, String item) {
        this.CapAdd.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCapAdd(int index, String item) {
        this.CapAdd.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCapAdd(String ... items) {
        for (String item : items) {
            this.CapAdd.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCapAdd(Collection<String> items) {
        for (String item : items) {
            this.CapAdd.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapAdd(String ... items) {
        for (String item : items) {
            this.CapAdd.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCapAdd(Collection<String> items) {
        for (String item : items) {
            this.CapAdd.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCapAdd() {
        return this.CapAdd;
    }

    @Override
    public String getCapAdd(int index) {
        return this.CapAdd.get(index);
    }

    @Override
    public String getFirstCapAdd() {
        return this.CapAdd.get(0);
    }

    @Override
    public String getLastCapAdd() {
        return this.CapAdd.get(this.CapAdd.size() - 1);
    }

    @Override
    public String getMatchingCapAdd(Predicate<String> predicate) {
        for (String item : this.CapAdd) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withCapAdd(List<String> CapAdd) {
        this.CapAdd.clear();
        if (CapAdd != null) {
            for (String item : CapAdd) {
                this.addToCapAdd(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCapAdd(String ... CapAdd) {
        this.CapAdd.clear();
        if (CapAdd != null) {
            for (String item : CapAdd) {
                this.addToCapAdd(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCapAdd() {
        return this.CapAdd != null && !this.CapAdd.isEmpty();
    }

    @Override
    public A addToCapDrop(int index, String item) {
        this.CapDrop.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCapDrop(int index, String item) {
        this.CapDrop.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCapDrop(String ... items) {
        for (String item : items) {
            this.CapDrop.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCapDrop(Collection<String> items) {
        for (String item : items) {
            this.CapDrop.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapDrop(String ... items) {
        for (String item : items) {
            this.CapDrop.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCapDrop(Collection<String> items) {
        for (String item : items) {
            this.CapDrop.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCapDrop() {
        return this.CapDrop;
    }

    @Override
    public String getCapDrop(int index) {
        return this.CapDrop.get(index);
    }

    @Override
    public String getFirstCapDrop() {
        return this.CapDrop.get(0);
    }

    @Override
    public String getLastCapDrop() {
        return this.CapDrop.get(this.CapDrop.size() - 1);
    }

    @Override
    public String getMatchingCapDrop(Predicate<String> predicate) {
        for (String item : this.CapDrop) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withCapDrop(List<String> CapDrop) {
        this.CapDrop.clear();
        if (CapDrop != null) {
            for (String item : CapDrop) {
                this.addToCapDrop(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCapDrop(String ... CapDrop) {
        this.CapDrop.clear();
        if (CapDrop != null) {
            for (String item : CapDrop) {
                this.addToCapDrop(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCapDrop() {
        return this.CapDrop != null && !this.CapDrop.isEmpty();
    }

    @Override
    public String getCgroupParent() {
        return this.CgroupParent;
    }

    @Override
    public A withCgroupParent(String CgroupParent) {
        this.CgroupParent = CgroupParent;
        return (A)this;
    }

    @Override
    public Boolean hasCgroupParent() {
        return this.CgroupParent != null;
    }

    @Override
    public Object getConsoleSize() {
        return this.ConsoleSize;
    }

    @Override
    public A withConsoleSize(Object ConsoleSize) {
        this.ConsoleSize = ConsoleSize;
        return (A)this;
    }

    @Override
    public Boolean hasConsoleSize() {
        return this.ConsoleSize != null;
    }

    @Override
    public String getContainerIDFile() {
        return this.ContainerIDFile;
    }

    @Override
    public A withContainerIDFile(String ContainerIDFile) {
        this.ContainerIDFile = ContainerIDFile;
        return (A)this;
    }

    @Override
    public Boolean hasContainerIDFile() {
        return this.ContainerIDFile != null;
    }

    @Override
    public Long getCpuPeriod() {
        return this.CpuPeriod;
    }

    @Override
    public A withCpuPeriod(Long CpuPeriod) {
        this.CpuPeriod = CpuPeriod;
        return (A)this;
    }

    @Override
    public Boolean hasCpuPeriod() {
        return this.CpuPeriod != null;
    }

    @Override
    public Long getCpuQuota() {
        return this.CpuQuota;
    }

    @Override
    public A withCpuQuota(Long CpuQuota) {
        this.CpuQuota = CpuQuota;
        return (A)this;
    }

    @Override
    public Boolean hasCpuQuota() {
        return this.CpuQuota != null;
    }

    @Override
    public Long getCpuShares() {
        return this.CpuShares;
    }

    @Override
    public A withCpuShares(Long CpuShares) {
        this.CpuShares = CpuShares;
        return (A)this;
    }

    @Override
    public Boolean hasCpuShares() {
        return this.CpuShares != null;
    }

    @Override
    public String getCpusetCpus() {
        return this.CpusetCpus;
    }

    @Override
    public A withCpusetCpus(String CpusetCpus) {
        this.CpusetCpus = CpusetCpus;
        return (A)this;
    }

    @Override
    public Boolean hasCpusetCpus() {
        return this.CpusetCpus != null;
    }

    @Override
    public String getCpusetMems() {
        return this.CpusetMems;
    }

    @Override
    public A withCpusetMems(String CpusetMems) {
        this.CpusetMems = CpusetMems;
        return (A)this;
    }

    @Override
    public Boolean hasCpusetMems() {
        return this.CpusetMems != null;
    }

    @Override
    public A addToDevices(int index, DeviceMapping item) {
        DeviceMappingBuilder builder = new DeviceMappingBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.Devices.add(index >= 0 ? index : this.Devices.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDevices(int index, DeviceMapping item) {
        DeviceMappingBuilder builder = new DeviceMappingBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.Devices.size()) {
            this.Devices.add(builder);
        } else {
            this.Devices.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDevices(DeviceMapping ... items) {
        for (DeviceMapping item : items) {
            DeviceMappingBuilder builder = new DeviceMappingBuilder(item);
            this._visitables.add(builder);
            this.Devices.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDevices(Collection<DeviceMapping> items) {
        for (DeviceMapping item : items) {
            DeviceMappingBuilder builder = new DeviceMappingBuilder(item);
            this._visitables.add(builder);
            this.Devices.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDevices(DeviceMapping ... items) {
        for (DeviceMapping item : items) {
            DeviceMappingBuilder builder = new DeviceMappingBuilder(item);
            this._visitables.remove(builder);
            this.Devices.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDevices(Collection<DeviceMapping> items) {
        for (DeviceMapping item : items) {
            DeviceMappingBuilder builder = new DeviceMappingBuilder(item);
            this._visitables.remove(builder);
            this.Devices.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DeviceMapping> getDevices() {
        return HostConfigFluentImpl.build(this.Devices);
    }

    @Override
    public List<DeviceMapping> buildDevices() {
        return HostConfigFluentImpl.build(this.Devices);
    }

    @Override
    public DeviceMapping buildDevice(int index) {
        return this.Devices.get(index).build();
    }

    @Override
    public DeviceMapping buildFirstDevice() {
        return this.Devices.get(0).build();
    }

    @Override
    public DeviceMapping buildLastDevice() {
        return this.Devices.get(this.Devices.size() - 1).build();
    }

    @Override
    public DeviceMapping buildMatchingDevice(Predicate<DeviceMappingBuilder> predicate) {
        for (DeviceMappingBuilder item : this.Devices) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withDevices(List<DeviceMapping> Devices) {
        this._visitables.removeAll(this.Devices);
        this.Devices.clear();
        if (Devices != null) {
            for (DeviceMapping item : Devices) {
                this.addToDevices(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDevices(DeviceMapping ... Devices) {
        this.Devices.clear();
        if (Devices != null) {
            for (DeviceMapping item : Devices) {
                this.addToDevices(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDevices() {
        return this.Devices != null && !this.Devices.isEmpty();
    }

    @Override
    public HostConfigFluent.DevicesNested<A> addNewDevice() {
        return new DevicesNestedImpl();
    }

    @Override
    public HostConfigFluent.DevicesNested<A> addNewDeviceLike(DeviceMapping item) {
        return new DevicesNestedImpl(-1, item);
    }

    @Override
    public HostConfigFluent.DevicesNested<A> setNewDeviceLike(int index, DeviceMapping item) {
        return new DevicesNestedImpl(index, item);
    }

    @Override
    public HostConfigFluent.DevicesNested<A> editDevice(int index) {
        if (this.Devices.size() <= index) {
            throw new RuntimeException("Can't edit Devices. Index exceeds size.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    @Override
    public HostConfigFluent.DevicesNested<A> editFirstDevice() {
        if (this.Devices.size() == 0) {
            throw new RuntimeException("Can't edit first Devices. The list is empty.");
        }
        return this.setNewDeviceLike(0, this.buildDevice(0));
    }

    @Override
    public HostConfigFluent.DevicesNested<A> editLastDevice() {
        int index = this.Devices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last Devices. The list is empty.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    @Override
    public HostConfigFluent.DevicesNested<A> editMatchingDevice(Predicate<DeviceMappingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.Devices.size(); ++i) {
            if (!predicate.apply(this.Devices.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching Devices. No match found.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    @Override
    public A addNewDevice(String CgroupPermissions, String PathInContainer, String PathOnHost) {
        return this.addToDevices(new DeviceMapping(CgroupPermissions, PathInContainer, PathOnHost));
    }

    @Override
    public A addToDns(int index, String item) {
        this.Dns.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDns(int index, String item) {
        this.Dns.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDns(String ... items) {
        for (String item : items) {
            this.Dns.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDns(Collection<String> items) {
        for (String item : items) {
            this.Dns.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDns(String ... items) {
        for (String item : items) {
            this.Dns.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDns(Collection<String> items) {
        for (String item : items) {
            this.Dns.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDns() {
        return this.Dns;
    }

    @Override
    public String getDn(int index) {
        return this.Dns.get(index);
    }

    @Override
    public String getFirstDn() {
        return this.Dns.get(0);
    }

    @Override
    public String getLastDn() {
        return this.Dns.get(this.Dns.size() - 1);
    }

    @Override
    public String getMatchingDn(Predicate<String> predicate) {
        for (String item : this.Dns) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withDns(List<String> Dns) {
        this.Dns.clear();
        if (Dns != null) {
            for (String item : Dns) {
                this.addToDns(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDns(String ... Dns) {
        this.Dns.clear();
        if (Dns != null) {
            for (String item : Dns) {
                this.addToDns(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDns() {
        return this.Dns != null && !this.Dns.isEmpty();
    }

    @Override
    public A addToDnsOptions(int index, String item) {
        this.DnsOptions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDnsOptions(int index, String item) {
        this.DnsOptions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDnsOptions(String ... items) {
        for (String item : items) {
            this.DnsOptions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDnsOptions(Collection<String> items) {
        for (String item : items) {
            this.DnsOptions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsOptions(String ... items) {
        for (String item : items) {
            this.DnsOptions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDnsOptions(Collection<String> items) {
        for (String item : items) {
            this.DnsOptions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDnsOptions() {
        return this.DnsOptions;
    }

    @Override
    public String getDnsOption(int index) {
        return this.DnsOptions.get(index);
    }

    @Override
    public String getFirstDnsOption() {
        return this.DnsOptions.get(0);
    }

    @Override
    public String getLastDnsOption() {
        return this.DnsOptions.get(this.DnsOptions.size() - 1);
    }

    @Override
    public String getMatchingDnsOption(Predicate<String> predicate) {
        for (String item : this.DnsOptions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withDnsOptions(List<String> DnsOptions) {
        this.DnsOptions.clear();
        if (DnsOptions != null) {
            for (String item : DnsOptions) {
                this.addToDnsOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDnsOptions(String ... DnsOptions) {
        this.DnsOptions.clear();
        if (DnsOptions != null) {
            for (String item : DnsOptions) {
                this.addToDnsOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsOptions() {
        return this.DnsOptions != null && !this.DnsOptions.isEmpty();
    }

    @Override
    public A addToDnsSearch(int index, String item) {
        this.DnsSearch.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDnsSearch(int index, String item) {
        this.DnsSearch.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDnsSearch(String ... items) {
        for (String item : items) {
            this.DnsSearch.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDnsSearch(Collection<String> items) {
        for (String item : items) {
            this.DnsSearch.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsSearch(String ... items) {
        for (String item : items) {
            this.DnsSearch.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDnsSearch(Collection<String> items) {
        for (String item : items) {
            this.DnsSearch.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDnsSearch() {
        return this.DnsSearch;
    }

    @Override
    public String getDnsSearch(int index) {
        return this.DnsSearch.get(index);
    }

    @Override
    public String getFirstDnsSearch() {
        return this.DnsSearch.get(0);
    }

    @Override
    public String getLastDnsSearch() {
        return this.DnsSearch.get(this.DnsSearch.size() - 1);
    }

    @Override
    public String getMatchingDnsSearch(Predicate<String> predicate) {
        for (String item : this.DnsSearch) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withDnsSearch(List<String> DnsSearch) {
        this.DnsSearch.clear();
        if (DnsSearch != null) {
            for (String item : DnsSearch) {
                this.addToDnsSearch(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDnsSearch(String ... DnsSearch) {
        this.DnsSearch.clear();
        if (DnsSearch != null) {
            for (String item : DnsSearch) {
                this.addToDnsSearch(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsSearch() {
        return this.DnsSearch != null && !this.DnsSearch.isEmpty();
    }

    @Override
    public A addToExtraHosts(int index, String item) {
        this.ExtraHosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExtraHosts(int index, String item) {
        this.ExtraHosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExtraHosts(String ... items) {
        for (String item : items) {
            this.ExtraHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtraHosts(Collection<String> items) {
        for (String item : items) {
            this.ExtraHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtraHosts(String ... items) {
        for (String item : items) {
            this.ExtraHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtraHosts(Collection<String> items) {
        for (String item : items) {
            this.ExtraHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExtraHosts() {
        return this.ExtraHosts;
    }

    @Override
    public String getExtraHost(int index) {
        return this.ExtraHosts.get(index);
    }

    @Override
    public String getFirstExtraHost() {
        return this.ExtraHosts.get(0);
    }

    @Override
    public String getLastExtraHost() {
        return this.ExtraHosts.get(this.ExtraHosts.size() - 1);
    }

    @Override
    public String getMatchingExtraHost(Predicate<String> predicate) {
        for (String item : this.ExtraHosts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withExtraHosts(List<String> ExtraHosts) {
        this.ExtraHosts.clear();
        if (ExtraHosts != null) {
            for (String item : ExtraHosts) {
                this.addToExtraHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExtraHosts(String ... ExtraHosts) {
        this.ExtraHosts.clear();
        if (ExtraHosts != null) {
            for (String item : ExtraHosts) {
                this.addToExtraHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtraHosts() {
        return this.ExtraHosts != null && !this.ExtraHosts.isEmpty();
    }

    @Override
    public A addToGroupAdd(int index, String item) {
        this.GroupAdd.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroupAdd(int index, String item) {
        this.GroupAdd.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroupAdd(String ... items) {
        for (String item : items) {
            this.GroupAdd.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroupAdd(Collection<String> items) {
        for (String item : items) {
            this.GroupAdd.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroupAdd(String ... items) {
        for (String item : items) {
            this.GroupAdd.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroupAdd(Collection<String> items) {
        for (String item : items) {
            this.GroupAdd.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroupAdd() {
        return this.GroupAdd;
    }

    @Override
    public String getGroupAdd(int index) {
        return this.GroupAdd.get(index);
    }

    @Override
    public String getFirstGroupAdd() {
        return this.GroupAdd.get(0);
    }

    @Override
    public String getLastGroupAdd() {
        return this.GroupAdd.get(this.GroupAdd.size() - 1);
    }

    @Override
    public String getMatchingGroupAdd(Predicate<String> predicate) {
        for (String item : this.GroupAdd) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withGroupAdd(List<String> GroupAdd) {
        this.GroupAdd.clear();
        if (GroupAdd != null) {
            for (String item : GroupAdd) {
                this.addToGroupAdd(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroupAdd(String ... GroupAdd) {
        this.GroupAdd.clear();
        if (GroupAdd != null) {
            for (String item : GroupAdd) {
                this.addToGroupAdd(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroupAdd() {
        return this.GroupAdd != null && !this.GroupAdd.isEmpty();
    }

    @Override
    public String getIpcMode() {
        return this.IpcMode;
    }

    @Override
    public A withIpcMode(String IpcMode) {
        this.IpcMode = IpcMode;
        return (A)this;
    }

    @Override
    public Boolean hasIpcMode() {
        return this.IpcMode != null;
    }

    @Override
    public Long getKernelMemory() {
        return this.KernelMemory;
    }

    @Override
    public A withKernelMemory(Long KernelMemory) {
        this.KernelMemory = KernelMemory;
        return (A)this;
    }

    @Override
    public Boolean hasKernelMemory() {
        return this.KernelMemory != null;
    }

    @Override
    public A addToLinks(int index, String item) {
        this.Links.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLinks(int index, String item) {
        this.Links.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLinks(String ... items) {
        for (String item : items) {
            this.Links.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLinks(Collection<String> items) {
        for (String item : items) {
            this.Links.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLinks(String ... items) {
        for (String item : items) {
            this.Links.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLinks(Collection<String> items) {
        for (String item : items) {
            this.Links.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLinks() {
        return this.Links;
    }

    @Override
    public String getLink(int index) {
        return this.Links.get(index);
    }

    @Override
    public String getFirstLink() {
        return this.Links.get(0);
    }

    @Override
    public String getLastLink() {
        return this.Links.get(this.Links.size() - 1);
    }

    @Override
    public String getMatchingLink(Predicate<String> predicate) {
        for (String item : this.Links) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withLinks(List<String> Links) {
        this.Links.clear();
        if (Links != null) {
            for (String item : Links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withLinks(String ... Links) {
        this.Links.clear();
        if (Links != null) {
            for (String item : Links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLinks() {
        return this.Links != null && !this.Links.isEmpty();
    }

    @Override
    @Deprecated
    public LogConfig getLogConfig() {
        return this.LogConfig != null ? this.LogConfig.build() : null;
    }

    @Override
    public LogConfig buildLogConfig() {
        return this.LogConfig != null ? this.LogConfig.build() : null;
    }

    @Override
    public A withLogConfig(LogConfig LogConfig2) {
        this._visitables.remove(this.LogConfig);
        if (LogConfig2 != null) {
            this.LogConfig = new LogConfigBuilder(LogConfig2);
            this._visitables.add(this.LogConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogConfig() {
        return this.LogConfig != null;
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> withNewLogConfig() {
        return new LogConfigNestedImpl();
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> withNewLogConfigLike(LogConfig item) {
        return new LogConfigNestedImpl(item);
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> editLogConfig() {
        return this.withNewLogConfigLike(this.getLogConfig());
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfig() {
        return this.withNewLogConfigLike(this.getLogConfig() != null ? this.getLogConfig() : new LogConfigBuilder().build());
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfigLike(LogConfig item) {
        return this.withNewLogConfigLike(this.getLogConfig() != null ? this.getLogConfig() : item);
    }

    @Override
    public LxcConfig getLxcConf() {
        return this.LxcConf;
    }

    @Override
    public A withLxcConf(LxcConfig LxcConf) {
        this.LxcConf = LxcConf;
        return (A)this;
    }

    @Override
    public Boolean hasLxcConf() {
        return this.LxcConf != null;
    }

    @Override
    public Long getMemory() {
        return this.Memory;
    }

    @Override
    public A withMemory(Long Memory) {
        this.Memory = Memory;
        return (A)this;
    }

    @Override
    public Boolean hasMemory() {
        return this.Memory != null;
    }

    @Override
    public Long getMemoryReservation() {
        return this.MemoryReservation;
    }

    @Override
    public A withMemoryReservation(Long MemoryReservation) {
        this.MemoryReservation = MemoryReservation;
        return (A)this;
    }

    @Override
    public Boolean hasMemoryReservation() {
        return this.MemoryReservation != null;
    }

    @Override
    public Long getMemorySwap() {
        return this.MemorySwap;
    }

    @Override
    public A withMemorySwap(Long MemorySwap) {
        this.MemorySwap = MemorySwap;
        return (A)this;
    }

    @Override
    public Boolean hasMemorySwap() {
        return this.MemorySwap != null;
    }

    @Override
    public Long getMemorySwappiness() {
        return this.MemorySwappiness;
    }

    @Override
    public A withMemorySwappiness(Long MemorySwappiness) {
        this.MemorySwappiness = MemorySwappiness;
        return (A)this;
    }

    @Override
    public Boolean hasMemorySwappiness() {
        return this.MemorySwappiness != null;
    }

    @Override
    public String getNetworkMode() {
        return this.NetworkMode;
    }

    @Override
    public A withNetworkMode(String NetworkMode) {
        this.NetworkMode = NetworkMode;
        return (A)this;
    }

    @Override
    public Boolean hasNetworkMode() {
        return this.NetworkMode != null;
    }

    @Override
    public Boolean isOomKillDisable() {
        return this.OomKillDisable;
    }

    @Override
    public A withOomKillDisable(Boolean OomKillDisable) {
        this.OomKillDisable = OomKillDisable;
        return (A)this;
    }

    @Override
    public Boolean hasOomKillDisable() {
        return this.OomKillDisable != null;
    }

    @Override
    public String getPidMode() {
        return this.PidMode;
    }

    @Override
    public A withPidMode(String PidMode) {
        this.PidMode = PidMode;
        return (A)this;
    }

    @Override
    public Boolean hasPidMode() {
        return this.PidMode != null;
    }

    @Override
    public A addToPortBindings(String key, ArrayList<PortBinding> value) {
        if (key != null && value != null) {
            this.PortBindings.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToPortBindings(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            this.PortBindings.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortBindings(String key) {
        if (key != null) {
            this.PortBindings.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortBindings(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.PortBindings.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<PortBinding>> getPortBindings() {
        return this.PortBindings;
    }

    @Override
    public A withPortBindings(Map<String, ArrayList<PortBinding>> PortBindings) {
        this.PortBindings.clear();
        if (PortBindings != null) {
            this.PortBindings.putAll(PortBindings);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPortBindings() {
        return this.PortBindings != null;
    }

    @Override
    public Boolean isPrivileged() {
        return this.Privileged;
    }

    @Override
    public A withPrivileged(Boolean Privileged) {
        this.Privileged = Privileged;
        return (A)this;
    }

    @Override
    public Boolean hasPrivileged() {
        return this.Privileged != null;
    }

    @Override
    public Boolean isPublishAllPorts() {
        return this.PublishAllPorts;
    }

    @Override
    public A withPublishAllPorts(Boolean PublishAllPorts) {
        this.PublishAllPorts = PublishAllPorts;
        return (A)this;
    }

    @Override
    public Boolean hasPublishAllPorts() {
        return this.PublishAllPorts != null;
    }

    @Override
    public Boolean isReadonlyRootfs() {
        return this.ReadonlyRootfs;
    }

    @Override
    public A withReadonlyRootfs(Boolean ReadonlyRootfs) {
        this.ReadonlyRootfs = ReadonlyRootfs;
        return (A)this;
    }

    @Override
    public Boolean hasReadonlyRootfs() {
        return this.ReadonlyRootfs != null;
    }

    @Override
    @Deprecated
    public RestartPolicy getRestartPolicy() {
        return this.RestartPolicy != null ? this.RestartPolicy.build() : null;
    }

    @Override
    public RestartPolicy buildRestartPolicy() {
        return this.RestartPolicy != null ? this.RestartPolicy.build() : null;
    }

    @Override
    public A withRestartPolicy(RestartPolicy RestartPolicy2) {
        this._visitables.remove(this.RestartPolicy);
        if (RestartPolicy2 != null) {
            this.RestartPolicy = new RestartPolicyBuilder(RestartPolicy2);
            this._visitables.add(this.RestartPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRestartPolicy() {
        return this.RestartPolicy != null;
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicy() {
        return new RestartPolicyNestedImpl();
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicyLike(RestartPolicy item) {
        return new RestartPolicyNestedImpl(item);
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> editRestartPolicy() {
        return this.withNewRestartPolicyLike(this.getRestartPolicy());
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicy() {
        return this.withNewRestartPolicyLike(this.getRestartPolicy() != null ? this.getRestartPolicy() : new RestartPolicyBuilder().build());
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicyLike(RestartPolicy item) {
        return this.withNewRestartPolicyLike(this.getRestartPolicy() != null ? this.getRestartPolicy() : item);
    }

    @Override
    public A withNewRestartPolicy(Integer MaximumRetryCount, String Name) {
        return this.withRestartPolicy(new RestartPolicy(MaximumRetryCount, Name));
    }

    @Override
    public A addToSecurityOpt(int index, String item) {
        this.SecurityOpt.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSecurityOpt(int index, String item) {
        this.SecurityOpt.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSecurityOpt(String ... items) {
        for (String item : items) {
            this.SecurityOpt.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecurityOpt(Collection<String> items) {
        for (String item : items) {
            this.SecurityOpt.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecurityOpt(String ... items) {
        for (String item : items) {
            this.SecurityOpt.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecurityOpt(Collection<String> items) {
        for (String item : items) {
            this.SecurityOpt.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSecurityOpt() {
        return this.SecurityOpt;
    }

    @Override
    public String getSecurityOpt(int index) {
        return this.SecurityOpt.get(index);
    }

    @Override
    public String getFirstSecurityOpt() {
        return this.SecurityOpt.get(0);
    }

    @Override
    public String getLastSecurityOpt() {
        return this.SecurityOpt.get(this.SecurityOpt.size() - 1);
    }

    @Override
    public String getMatchingSecurityOpt(Predicate<String> predicate) {
        for (String item : this.SecurityOpt) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withSecurityOpt(List<String> SecurityOpt) {
        this.SecurityOpt.clear();
        if (SecurityOpt != null) {
            for (String item : SecurityOpt) {
                this.addToSecurityOpt(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecurityOpt(String ... SecurityOpt) {
        this.SecurityOpt.clear();
        if (SecurityOpt != null) {
            for (String item : SecurityOpt) {
                this.addToSecurityOpt(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecurityOpt() {
        return this.SecurityOpt != null && !this.SecurityOpt.isEmpty();
    }

    @Override
    public String getUTSMode() {
        return this.UTSMode;
    }

    @Override
    public A withUTSMode(String UTSMode) {
        this.UTSMode = UTSMode;
        return (A)this;
    }

    @Override
    public Boolean hasUTSMode() {
        return this.UTSMode != null;
    }

    @Override
    public A addToUlimits(int index, Ulimit item) {
        UlimitBuilder builder = new UlimitBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.Ulimits.add(index >= 0 ? index : this.Ulimits.size(), builder);
        return (A)this;
    }

    @Override
    public A setToUlimits(int index, Ulimit item) {
        UlimitBuilder builder = new UlimitBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.Ulimits.size()) {
            this.Ulimits.add(builder);
        } else {
            this.Ulimits.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToUlimits(Ulimit ... items) {
        for (Ulimit item : items) {
            UlimitBuilder builder = new UlimitBuilder(item);
            this._visitables.add(builder);
            this.Ulimits.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToUlimits(Collection<Ulimit> items) {
        for (Ulimit item : items) {
            UlimitBuilder builder = new UlimitBuilder(item);
            this._visitables.add(builder);
            this.Ulimits.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromUlimits(Ulimit ... items) {
        for (Ulimit item : items) {
            UlimitBuilder builder = new UlimitBuilder(item);
            this._visitables.remove(builder);
            this.Ulimits.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUlimits(Collection<Ulimit> items) {
        for (Ulimit item : items) {
            UlimitBuilder builder = new UlimitBuilder(item);
            this._visitables.remove(builder);
            this.Ulimits.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Ulimit> getUlimits() {
        return HostConfigFluentImpl.build(this.Ulimits);
    }

    @Override
    public List<Ulimit> buildUlimits() {
        return HostConfigFluentImpl.build(this.Ulimits);
    }

    @Override
    public Ulimit buildUlimit(int index) {
        return this.Ulimits.get(index).build();
    }

    @Override
    public Ulimit buildFirstUlimit() {
        return this.Ulimits.get(0).build();
    }

    @Override
    public Ulimit buildLastUlimit() {
        return this.Ulimits.get(this.Ulimits.size() - 1).build();
    }

    @Override
    public Ulimit buildMatchingUlimit(Predicate<UlimitBuilder> predicate) {
        for (UlimitBuilder item : this.Ulimits) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withUlimits(List<Ulimit> Ulimits) {
        this._visitables.removeAll(this.Ulimits);
        this.Ulimits.clear();
        if (Ulimits != null) {
            for (Ulimit item : Ulimits) {
                this.addToUlimits(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withUlimits(Ulimit ... Ulimits) {
        this.Ulimits.clear();
        if (Ulimits != null) {
            for (Ulimit item : Ulimits) {
                this.addToUlimits(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUlimits() {
        return this.Ulimits != null && !this.Ulimits.isEmpty();
    }

    @Override
    public HostConfigFluent.UlimitsNested<A> addNewUlimit() {
        return new UlimitsNestedImpl();
    }

    @Override
    public HostConfigFluent.UlimitsNested<A> addNewUlimitLike(Ulimit item) {
        return new UlimitsNestedImpl(-1, item);
    }

    @Override
    public HostConfigFluent.UlimitsNested<A> setNewUlimitLike(int index, Ulimit item) {
        return new UlimitsNestedImpl(index, item);
    }

    @Override
    public HostConfigFluent.UlimitsNested<A> editUlimit(int index) {
        if (this.Ulimits.size() <= index) {
            throw new RuntimeException("Can't edit Ulimits. Index exceeds size.");
        }
        return this.setNewUlimitLike(index, this.buildUlimit(index));
    }

    @Override
    public HostConfigFluent.UlimitsNested<A> editFirstUlimit() {
        if (this.Ulimits.size() == 0) {
            throw new RuntimeException("Can't edit first Ulimits. The list is empty.");
        }
        return this.setNewUlimitLike(0, this.buildUlimit(0));
    }

    @Override
    public HostConfigFluent.UlimitsNested<A> editLastUlimit() {
        int index = this.Ulimits.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last Ulimits. The list is empty.");
        }
        return this.setNewUlimitLike(index, this.buildUlimit(index));
    }

    @Override
    public HostConfigFluent.UlimitsNested<A> editMatchingUlimit(Predicate<UlimitBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.Ulimits.size(); ++i) {
            if (!predicate.apply(this.Ulimits.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching Ulimits. No match found.");
        }
        return this.setNewUlimitLike(index, this.buildUlimit(index));
    }

    @Override
    public A addNewUlimit(Long Hard, String Name, Long Soft) {
        return this.addToUlimits(new Ulimit(Hard, Name, Soft));
    }

    @Override
    public String getVolumeDriver() {
        return this.VolumeDriver;
    }

    @Override
    public A withVolumeDriver(String VolumeDriver) {
        this.VolumeDriver = VolumeDriver;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeDriver() {
        return this.VolumeDriver != null;
    }

    @Override
    public A addToVolumesFrom(int index, String item) {
        this.VolumesFrom.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumesFrom(int index, String item) {
        this.VolumesFrom.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumesFrom(String ... items) {
        for (String item : items) {
            this.VolumesFrom.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumesFrom(Collection<String> items) {
        for (String item : items) {
            this.VolumesFrom.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumesFrom(String ... items) {
        for (String item : items) {
            this.VolumesFrom.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumesFrom(Collection<String> items) {
        for (String item : items) {
            this.VolumesFrom.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumesFrom() {
        return this.VolumesFrom;
    }

    @Override
    public String getVolumesFrom(int index) {
        return this.VolumesFrom.get(index);
    }

    @Override
    public String getFirstVolumesFrom() {
        return this.VolumesFrom.get(0);
    }

    @Override
    public String getLastVolumesFrom() {
        return this.VolumesFrom.get(this.VolumesFrom.size() - 1);
    }

    @Override
    public String getMatchingVolumesFrom(Predicate<String> predicate) {
        for (String item : this.VolumesFrom) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withVolumesFrom(List<String> VolumesFrom) {
        this.VolumesFrom.clear();
        if (VolumesFrom != null) {
            for (String item : VolumesFrom) {
                this.addToVolumesFrom(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumesFrom(String ... VolumesFrom) {
        this.VolumesFrom.clear();
        if (VolumesFrom != null) {
            for (String item : VolumesFrom) {
                this.addToVolumesFrom(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumesFrom() {
        return this.VolumesFrom != null && !this.VolumesFrom.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostConfigFluentImpl that = (HostConfigFluentImpl)o;
        if (this.Binds != null ? !this.Binds.equals(that.Binds) : that.Binds != null) {
            return false;
        }
        if (this.BlkioWeight != null ? !this.BlkioWeight.equals(that.BlkioWeight) : that.BlkioWeight != null) {
            return false;
        }
        if (this.CapAdd != null ? !this.CapAdd.equals(that.CapAdd) : that.CapAdd != null) {
            return false;
        }
        if (this.CapDrop != null ? !this.CapDrop.equals(that.CapDrop) : that.CapDrop != null) {
            return false;
        }
        if (this.CgroupParent != null ? !this.CgroupParent.equals(that.CgroupParent) : that.CgroupParent != null) {
            return false;
        }
        if (this.ConsoleSize != null && this.ConsoleSize != this ? !this.ConsoleSize.equals(that.ConsoleSize) : that.ConsoleSize != null && this.ConsoleSize != this) {
            return false;
        }
        if (this.ContainerIDFile != null ? !this.ContainerIDFile.equals(that.ContainerIDFile) : that.ContainerIDFile != null) {
            return false;
        }
        if (this.CpuPeriod != null ? !this.CpuPeriod.equals(that.CpuPeriod) : that.CpuPeriod != null) {
            return false;
        }
        if (this.CpuQuota != null ? !this.CpuQuota.equals(that.CpuQuota) : that.CpuQuota != null) {
            return false;
        }
        if (this.CpuShares != null ? !this.CpuShares.equals(that.CpuShares) : that.CpuShares != null) {
            return false;
        }
        if (this.CpusetCpus != null ? !this.CpusetCpus.equals(that.CpusetCpus) : that.CpusetCpus != null) {
            return false;
        }
        if (this.CpusetMems != null ? !this.CpusetMems.equals(that.CpusetMems) : that.CpusetMems != null) {
            return false;
        }
        if (this.Devices != null ? !this.Devices.equals(that.Devices) : that.Devices != null) {
            return false;
        }
        if (this.Dns != null ? !this.Dns.equals(that.Dns) : that.Dns != null) {
            return false;
        }
        if (this.DnsOptions != null ? !this.DnsOptions.equals(that.DnsOptions) : that.DnsOptions != null) {
            return false;
        }
        if (this.DnsSearch != null ? !this.DnsSearch.equals(that.DnsSearch) : that.DnsSearch != null) {
            return false;
        }
        if (this.ExtraHosts != null ? !this.ExtraHosts.equals(that.ExtraHosts) : that.ExtraHosts != null) {
            return false;
        }
        if (this.GroupAdd != null ? !this.GroupAdd.equals(that.GroupAdd) : that.GroupAdd != null) {
            return false;
        }
        if (this.IpcMode != null ? !this.IpcMode.equals(that.IpcMode) : that.IpcMode != null) {
            return false;
        }
        if (this.KernelMemory != null ? !this.KernelMemory.equals(that.KernelMemory) : that.KernelMemory != null) {
            return false;
        }
        if (this.Links != null ? !this.Links.equals(that.Links) : that.Links != null) {
            return false;
        }
        if (this.LogConfig != null ? !this.LogConfig.equals(that.LogConfig) : that.LogConfig != null) {
            return false;
        }
        if (this.LxcConf != null ? !this.LxcConf.equals(that.LxcConf) : that.LxcConf != null) {
            return false;
        }
        if (this.Memory != null ? !this.Memory.equals(that.Memory) : that.Memory != null) {
            return false;
        }
        if (this.MemoryReservation != null ? !this.MemoryReservation.equals(that.MemoryReservation) : that.MemoryReservation != null) {
            return false;
        }
        if (this.MemorySwap != null ? !this.MemorySwap.equals(that.MemorySwap) : that.MemorySwap != null) {
            return false;
        }
        if (this.MemorySwappiness != null ? !this.MemorySwappiness.equals(that.MemorySwappiness) : that.MemorySwappiness != null) {
            return false;
        }
        if (this.NetworkMode != null ? !this.NetworkMode.equals(that.NetworkMode) : that.NetworkMode != null) {
            return false;
        }
        if (this.OomKillDisable != null ? !this.OomKillDisable.equals(that.OomKillDisable) : that.OomKillDisable != null) {
            return false;
        }
        if (this.PidMode != null ? !this.PidMode.equals(that.PidMode) : that.PidMode != null) {
            return false;
        }
        if (this.PortBindings != null ? !this.PortBindings.equals(that.PortBindings) : that.PortBindings != null) {
            return false;
        }
        if (this.Privileged != null ? !this.Privileged.equals(that.Privileged) : that.Privileged != null) {
            return false;
        }
        if (this.PublishAllPorts != null ? !this.PublishAllPorts.equals(that.PublishAllPorts) : that.PublishAllPorts != null) {
            return false;
        }
        if (this.ReadonlyRootfs != null ? !this.ReadonlyRootfs.equals(that.ReadonlyRootfs) : that.ReadonlyRootfs != null) {
            return false;
        }
        if (this.RestartPolicy != null ? !this.RestartPolicy.equals(that.RestartPolicy) : that.RestartPolicy != null) {
            return false;
        }
        if (this.SecurityOpt != null ? !this.SecurityOpt.equals(that.SecurityOpt) : that.SecurityOpt != null) {
            return false;
        }
        if (this.UTSMode != null ? !this.UTSMode.equals(that.UTSMode) : that.UTSMode != null) {
            return false;
        }
        if (this.Ulimits != null ? !this.Ulimits.equals(that.Ulimits) : that.Ulimits != null) {
            return false;
        }
        if (this.VolumeDriver != null ? !this.VolumeDriver.equals(that.VolumeDriver) : that.VolumeDriver != null) {
            return false;
        }
        return !(this.VolumesFrom != null ? !this.VolumesFrom.equals(that.VolumesFrom) : that.VolumesFrom != null);
    }

    public class UlimitsNestedImpl<N>
    extends UlimitFluentImpl<HostConfigFluent.UlimitsNested<N>>
    implements HostConfigFluent.UlimitsNested<N>,
    Nested<N> {
        private final UlimitBuilder builder;
        private final int index;

        UlimitsNestedImpl(int index, Ulimit item) {
            this.index = index;
            this.builder = new UlimitBuilder(this, item);
        }

        UlimitsNestedImpl() {
            this.index = -1;
            this.builder = new UlimitBuilder(this);
        }

        @Override
        public N and() {
            return (N)HostConfigFluentImpl.this.setToUlimits(this.index, this.builder.build());
        }

        @Override
        public N endUlimit() {
            return this.and();
        }
    }

    public class RestartPolicyNestedImpl<N>
    extends RestartPolicyFluentImpl<HostConfigFluent.RestartPolicyNested<N>>
    implements HostConfigFluent.RestartPolicyNested<N>,
    Nested<N> {
        private final RestartPolicyBuilder builder;

        RestartPolicyNestedImpl(RestartPolicy item) {
            this.builder = new RestartPolicyBuilder(this, item);
        }

        RestartPolicyNestedImpl() {
            this.builder = new RestartPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)HostConfigFluentImpl.this.withRestartPolicy(this.builder.build());
        }

        @Override
        public N endRestartPolicy() {
            return this.and();
        }
    }

    public class LogConfigNestedImpl<N>
    extends LogConfigFluentImpl<HostConfigFluent.LogConfigNested<N>>
    implements HostConfigFluent.LogConfigNested<N>,
    Nested<N> {
        private final LogConfigBuilder builder;

        LogConfigNestedImpl(LogConfig item) {
            this.builder = new LogConfigBuilder(this, item);
        }

        LogConfigNestedImpl() {
            this.builder = new LogConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)HostConfigFluentImpl.this.withLogConfig(this.builder.build());
        }

        @Override
        public N endLogConfig() {
            return this.and();
        }
    }

    public class DevicesNestedImpl<N>
    extends DeviceMappingFluentImpl<HostConfigFluent.DevicesNested<N>>
    implements HostConfigFluent.DevicesNested<N>,
    Nested<N> {
        private final DeviceMappingBuilder builder;
        private final int index;

        DevicesNestedImpl(int index, DeviceMapping item) {
            this.index = index;
            this.builder = new DeviceMappingBuilder(this, item);
        }

        DevicesNestedImpl() {
            this.index = -1;
            this.builder = new DeviceMappingBuilder(this);
        }

        @Override
        public N and() {
            return (N)HostConfigFluentImpl.this.setToDevices(this.index, this.builder.build());
        }

        @Override
        public N endDevice() {
            return this.and();
        }
    }
}

