/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableGraphDriverData;
import io.fabric8.docker.api.model.GraphDriverData;
import io.fabric8.docker.api.model.GraphDriverDataFluent;
import io.fabric8.docker.api.model.GraphDriverDataFluentImpl;

public class GraphDriverDataBuilder
extends GraphDriverDataFluentImpl<GraphDriverDataBuilder>
implements VisitableBuilder<GraphDriverData, GraphDriverDataBuilder> {
    GraphDriverDataFluent<?> fluent;
    Boolean validationEnabled;

    public GraphDriverDataBuilder() {
        this(true);
    }

    public GraphDriverDataBuilder(Boolean validationEnabled) {
        this(new GraphDriverData(), validationEnabled);
    }

    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GraphDriverData(), validationEnabled);
    }

    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent, GraphDriverData instance) {
        this(fluent, instance, true);
    }

    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent, GraphDriverData instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withData(instance.getData());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public GraphDriverDataBuilder(GraphDriverData instance) {
        this(instance, (Boolean)true);
    }

    public GraphDriverDataBuilder(GraphDriverData instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withData(instance.getData());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableGraphDriverData build() {
        EditableGraphDriverData buildable = new EditableGraphDriverData(this.fluent.getData(), this.fluent.getName());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GraphDriverDataBuilder that = (GraphDriverDataBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

