/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableExecStartCheck;
import io.fabric8.docker.api.model.ExecStartCheck;
import io.fabric8.docker.api.model.ExecStartCheckFluent;
import io.fabric8.docker.api.model.ExecStartCheckFluentImpl;

public class ExecStartCheckBuilder
extends ExecStartCheckFluentImpl<ExecStartCheckBuilder>
implements VisitableBuilder<ExecStartCheck, ExecStartCheckBuilder> {
    ExecStartCheckFluent<?> fluent;
    Boolean validationEnabled;

    public ExecStartCheckBuilder() {
        this(true);
    }

    public ExecStartCheckBuilder(Boolean validationEnabled) {
        this(new ExecStartCheck(), validationEnabled);
    }

    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExecStartCheck(), validationEnabled);
    }

    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent, ExecStartCheck instance) {
        this(fluent, instance, true);
    }

    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent, ExecStartCheck instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDetach(instance.getDetach());
        fluent.withTty(instance.getTty());
        this.validationEnabled = validationEnabled;
    }

    public ExecStartCheckBuilder(ExecStartCheck instance) {
        this(instance, (Boolean)true);
    }

    public ExecStartCheckBuilder(ExecStartCheck instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDetach(instance.getDetach());
        this.withTty(instance.getTty());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableExecStartCheck build() {
        EditableExecStartCheck buildable = new EditableExecStartCheck(this.fluent.isDetach(), this.fluent.isTty());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecStartCheckBuilder that = (ExecStartCheckBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

