/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableEndpointSettings;
import io.fabric8.docker.api.model.EndpointSettings;
import io.fabric8.docker.api.model.EndpointSettingsFluent;
import io.fabric8.docker.api.model.EndpointSettingsFluentImpl;

public class EndpointSettingsBuilder
extends EndpointSettingsFluentImpl<EndpointSettingsBuilder>
implements VisitableBuilder<EndpointSettings, EndpointSettingsBuilder> {
    EndpointSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointSettingsBuilder() {
        this(true);
    }

    public EndpointSettingsBuilder(Boolean validationEnabled) {
        this(new EndpointSettings(), validationEnabled);
    }

    public EndpointSettingsBuilder(EndpointSettingsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointSettingsBuilder(EndpointSettingsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointSettings(), validationEnabled);
    }

    public EndpointSettingsBuilder(EndpointSettingsFluent<?> fluent, EndpointSettings instance) {
        this(fluent, instance, true);
    }

    public EndpointSettingsBuilder(EndpointSettingsFluent<?> fluent, EndpointSettings instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEndpointID(instance.getEndpointID());
        fluent.withGateway(instance.getGateway());
        fluent.withGlobalIPv6Address(instance.getGlobalIPv6Address());
        fluent.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen());
        fluent.withIPAddress(instance.getIPAddress());
        fluent.withIPPrefixLen(instance.getIPPrefixLen());
        fluent.withIPv6Gateway(instance.getIPv6Gateway());
        fluent.withMacAddress(instance.getMacAddress());
        this.validationEnabled = validationEnabled;
    }

    public EndpointSettingsBuilder(EndpointSettings instance) {
        this(instance, (Boolean)true);
    }

    public EndpointSettingsBuilder(EndpointSettings instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEndpointID(instance.getEndpointID());
        this.withGateway(instance.getGateway());
        this.withGlobalIPv6Address(instance.getGlobalIPv6Address());
        this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen());
        this.withIPAddress(instance.getIPAddress());
        this.withIPPrefixLen(instance.getIPPrefixLen());
        this.withIPv6Gateway(instance.getIPv6Gateway());
        this.withMacAddress(instance.getMacAddress());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableEndpointSettings build() {
        EditableEndpointSettings buildable = new EditableEndpointSettings(this.fluent.getEndpointID(), this.fluent.getGateway(), this.fluent.getGlobalIPv6Address(), this.fluent.getGlobalIPv6PrefixLen(), this.fluent.getIPAddress(), this.fluent.getIPPrefixLen(), this.fluent.getIPv6Gateway(), this.fluent.getMacAddress());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSettingsBuilder that = (EndpointSettingsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

