/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.DefaultNetworkSettings;
import io.fabric8.docker.api.model.DefaultNetworkSettingsFluent;
import io.fabric8.docker.api.model.DefaultNetworkSettingsFluentImpl;
import io.fabric8.docker.api.model.EditableDefaultNetworkSettings;

public class DefaultNetworkSettingsBuilder
extends DefaultNetworkSettingsFluentImpl<DefaultNetworkSettingsBuilder>
implements VisitableBuilder<DefaultNetworkSettings, DefaultNetworkSettingsBuilder> {
    DefaultNetworkSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public DefaultNetworkSettingsBuilder() {
        this(true);
    }

    public DefaultNetworkSettingsBuilder(Boolean validationEnabled) {
        this(new DefaultNetworkSettings(), validationEnabled);
    }

    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DefaultNetworkSettings(), validationEnabled);
    }

    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent, DefaultNetworkSettings instance) {
        this(fluent, instance, true);
    }

    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent, DefaultNetworkSettings instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEndpointID(instance.getEndpointID());
        fluent.withGateway(instance.getGateway());
        fluent.withGlobalIPv6Address(instance.getGlobalIPv6Address());
        fluent.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen());
        fluent.withIPAddress(instance.getIPAddress());
        fluent.withIPPrefixLen(instance.getIPPrefixLen());
        fluent.withIPv6Gateway(instance.getIPv6Gateway());
        fluent.withMacAddress(instance.getMacAddress());
        this.validationEnabled = validationEnabled;
    }

    public DefaultNetworkSettingsBuilder(DefaultNetworkSettings instance) {
        this(instance, (Boolean)true);
    }

    public DefaultNetworkSettingsBuilder(DefaultNetworkSettings instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEndpointID(instance.getEndpointID());
        this.withGateway(instance.getGateway());
        this.withGlobalIPv6Address(instance.getGlobalIPv6Address());
        this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen());
        this.withIPAddress(instance.getIPAddress());
        this.withIPPrefixLen(instance.getIPPrefixLen());
        this.withIPv6Gateway(instance.getIPv6Gateway());
        this.withMacAddress(instance.getMacAddress());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableDefaultNetworkSettings build() {
        EditableDefaultNetworkSettings buildable = new EditableDefaultNetworkSettings(this.fluent.getEndpointID(), this.fluent.getGateway(), this.fluent.getGlobalIPv6Address(), this.fluent.getGlobalIPv6PrefixLen(), this.fluent.getIPAddress(), this.fluent.getIPPrefixLen(), this.fluent.getIPv6Gateway(), this.fluent.getMacAddress());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultNetworkSettingsBuilder that = (DefaultNetworkSettingsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

