/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.Container;
import io.fabric8.docker.api.model.ContainerFluent;
import io.fabric8.docker.api.model.ContainerHostConfig;
import io.fabric8.docker.api.model.ContainerHostConfigBuilder;
import io.fabric8.docker.api.model.ContainerHostConfigFluentImpl;
import io.fabric8.docker.api.model.NetworkSettings;
import io.fabric8.docker.api.model.NetworkSettingsBuilder;
import io.fabric8.docker.api.model.NetworkSettingsFluentImpl;
import io.fabric8.docker.api.model.Port;
import io.fabric8.docker.api.model.PortBuilder;
import io.fabric8.docker.api.model.PortFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ContainerFluentImpl<A extends ContainerFluent<A>>
extends BaseFluent<A>
implements ContainerFluent<A> {
    private String id;
    private List<String> names = new ArrayList<String>();
    private String image;
    private String imageId;
    private String command;
    private Long created;
    private List<PortBuilder> ports = new ArrayList<PortBuilder>();
    private Long sizeRw;
    private Long sizeRootFs;
    private Map<String, String> labels = new LinkedHashMap<String, String>();
    private String status;
    private ContainerHostConfigBuilder hostConfig;
    private NetworkSettingsBuilder summaryNetworkSettings;

    public ContainerFluentImpl() {
    }

    public ContainerFluentImpl(Container instance) {
        this.withId(instance.getId());
        this.withNames(instance.getNames());
        this.withImage(instance.getImage());
        this.withImageId(instance.getImageId());
        this.withCommand(instance.getCommand());
        this.withCreated(instance.getCreated());
        this.withPorts(instance.getPorts());
        this.withSizeRw(instance.getSizeRw());
        this.withSizeRootFs(instance.getSizeRootFs());
        this.withLabels(instance.getLabels());
        this.withStatus(instance.getStatus());
        this.withHostConfig(instance.getHostConfig());
        this.withSummaryNetworkSettings(instance.getSummaryNetworkSettings());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    @Override
    public Boolean hasId() {
        return this.id != null;
    }

    @Override
    public A addToNames(int index, String item) {
        this.names.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNames(int index, String item) {
        this.names.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNames(String ... items) {
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNames(Collection<String> items) {
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNames(String ... items) {
        for (String item : items) {
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNames(Collection<String> items) {
        for (String item : items) {
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getName(int index) {
        return this.names.get(index);
    }

    @Override
    public String getFirstName() {
        return this.names.get(0);
    }

    @Override
    public String getLastName() {
        return this.names.get(this.names.size() - 1);
    }

    @Override
    public String getMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withNames(List<String> names) {
        this.names.clear();
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withNames(String ... names) {
        this.names.clear();
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNames() {
        return this.names != null && !this.names.isEmpty();
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public A withImageId(String imageId) {
        this.imageId = imageId;
        return (A)this;
    }

    @Override
    public Boolean hasImageId() {
        return this.imageId != null;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public A withCommand(String command) {
        this.command = command;
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null;
    }

    @Override
    public Long getCreated() {
        return this.created;
    }

    @Override
    public A withCreated(Long created) {
        this.created = created;
        return (A)this;
    }

    @Override
    public Boolean hasCreated() {
        return this.created != null;
    }

    @Override
    public A addToPorts(int index, Port item) {
        PortBuilder builder = new PortBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, Port item) {
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<Port> items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<Port> items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Port> getPorts() {
        return ContainerFluentImpl.build(this.ports);
    }

    @Override
    public List<Port> buildPorts() {
        return ContainerFluentImpl.build(this.ports);
    }

    @Override
    public Port buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public Port buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public Port buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withPorts(List<Port> ports) {
        this._visitables.removeAll(this.ports);
        this.ports.clear();
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPorts(Port ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPortLike(Port item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.PortsNested<A> setNewPortLike(int index, Port item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ContainerFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public ContainerFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ContainerFluent.PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply(this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public A addNewPort(String IP, Integer PrivatePort, Integer PublicPort, String Type2) {
        return this.addToPorts(new Port(IP, PrivatePort, PublicPort, Type2));
    }

    @Override
    public Long getSizeRw() {
        return this.sizeRw;
    }

    @Override
    public A withSizeRw(Long sizeRw) {
        this.sizeRw = sizeRw;
        return (A)this;
    }

    @Override
    public Boolean hasSizeRw() {
        return this.sizeRw != null;
    }

    @Override
    public Long getSizeRootFs() {
        return this.sizeRootFs;
    }

    @Override
    public A withSizeRootFs(Long sizeRootFs) {
        this.sizeRootFs = sizeRootFs;
        return (A)this;
    }

    @Override
    public Boolean hasSizeRootFs() {
        return this.sizeRootFs != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (key != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public A withLabels(Map<String, String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.putAll(labels);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(String status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    @Deprecated
    public ContainerHostConfig getHostConfig() {
        return this.hostConfig != null ? this.hostConfig.build() : null;
    }

    @Override
    public ContainerHostConfig buildHostConfig() {
        return this.hostConfig != null ? this.hostConfig.build() : null;
    }

    @Override
    public A withHostConfig(ContainerHostConfig hostConfig) {
        this._visitables.remove(this.hostConfig);
        if (hostConfig != null) {
            this.hostConfig = new ContainerHostConfigBuilder(hostConfig);
            this._visitables.add(this.hostConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostConfig() {
        return this.hostConfig != null;
    }

    @Override
    public ContainerFluent.HostConfigNested<A> withNewHostConfig() {
        return new HostConfigNestedImpl();
    }

    @Override
    public ContainerFluent.HostConfigNested<A> withNewHostConfigLike(ContainerHostConfig item) {
        return new HostConfigNestedImpl(item);
    }

    @Override
    public ContainerFluent.HostConfigNested<A> editHostConfig() {
        return this.withNewHostConfigLike(this.getHostConfig());
    }

    @Override
    public ContainerFluent.HostConfigNested<A> editOrNewHostConfig() {
        return this.withNewHostConfigLike(this.getHostConfig() != null ? this.getHostConfig() : new ContainerHostConfigBuilder().build());
    }

    @Override
    public ContainerFluent.HostConfigNested<A> editOrNewHostConfigLike(ContainerHostConfig item) {
        return this.withNewHostConfigLike(this.getHostConfig() != null ? this.getHostConfig() : item);
    }

    @Override
    public A withNewHostConfig(String networkMode) {
        return this.withHostConfig(new ContainerHostConfig(networkMode));
    }

    @Override
    @Deprecated
    public NetworkSettings getSummaryNetworkSettings() {
        return this.summaryNetworkSettings != null ? this.summaryNetworkSettings.build() : null;
    }

    @Override
    public NetworkSettings buildSummaryNetworkSettings() {
        return this.summaryNetworkSettings != null ? this.summaryNetworkSettings.build() : null;
    }

    @Override
    public A withSummaryNetworkSettings(NetworkSettings summaryNetworkSettings) {
        this._visitables.remove(this.summaryNetworkSettings);
        if (summaryNetworkSettings != null) {
            this.summaryNetworkSettings = new NetworkSettingsBuilder(summaryNetworkSettings);
            this._visitables.add(this.summaryNetworkSettings);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSummaryNetworkSettings() {
        return this.summaryNetworkSettings != null;
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettings() {
        return new SummaryNetworkSettingsNestedImpl();
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettingsLike(NetworkSettings item) {
        return new SummaryNetworkSettingsNestedImpl(item);
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> editSummaryNetworkSettings() {
        return this.withNewSummaryNetworkSettingsLike(this.getSummaryNetworkSettings());
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettings() {
        return this.withNewSummaryNetworkSettingsLike(this.getSummaryNetworkSettings() != null ? this.getSummaryNetworkSettings() : new NetworkSettingsBuilder().build());
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettingsLike(NetworkSettings item) {
        return this.withNewSummaryNetworkSettingsLike(this.getSummaryNetworkSettings() != null ? this.getSummaryNetworkSettings() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerFluentImpl that = (ContainerFluentImpl)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.sizeRw != null ? !this.sizeRw.equals(that.sizeRw) : that.sizeRw != null) {
            return false;
        }
        if (this.sizeRootFs != null ? !this.sizeRootFs.equals(that.sizeRootFs) : that.sizeRootFs != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.hostConfig != null ? !this.hostConfig.equals(that.hostConfig) : that.hostConfig != null) {
            return false;
        }
        return !(this.summaryNetworkSettings != null ? !this.summaryNetworkSettings.equals(that.summaryNetworkSettings) : that.summaryNetworkSettings != null);
    }

    public class SummaryNetworkSettingsNestedImpl<N>
    extends NetworkSettingsFluentImpl<ContainerFluent.SummaryNetworkSettingsNested<N>>
    implements ContainerFluent.SummaryNetworkSettingsNested<N>,
    Nested<N> {
        private final NetworkSettingsBuilder builder;

        SummaryNetworkSettingsNestedImpl(NetworkSettings item) {
            this.builder = new NetworkSettingsBuilder(this, item);
        }

        SummaryNetworkSettingsNestedImpl() {
            this.builder = new NetworkSettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withSummaryNetworkSettings(this.builder.build());
        }

        @Override
        public N endSummaryNetworkSettings() {
            return this.and();
        }
    }

    public class HostConfigNestedImpl<N>
    extends ContainerHostConfigFluentImpl<ContainerFluent.HostConfigNested<N>>
    implements ContainerFluent.HostConfigNested<N>,
    Nested<N> {
        private final ContainerHostConfigBuilder builder;

        HostConfigNestedImpl(ContainerHostConfig item) {
            this.builder = new ContainerHostConfigBuilder(this, item);
        }

        HostConfigNestedImpl() {
            this.builder = new ContainerHostConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withHostConfig(this.builder.build());
        }

        @Override
        public N endHostConfig() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends PortFluentImpl<ContainerFluent.PortsNested<N>>
    implements ContainerFluent.PortsNested<N>,
    Nested<N> {
        private final PortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, Port item) {
            this.index = index;
            this.builder = new PortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new PortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

