/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerCreateRequest;
import io.fabric8.docker.api.model.ContainerCreateRequestFluent;
import io.fabric8.docker.api.model.ContainerCreateRequestFluentImpl;
import io.fabric8.docker.api.model.EditableContainerCreateRequest;

public class ContainerCreateRequestBuilder
extends ContainerCreateRequestFluentImpl<ContainerCreateRequestBuilder>
implements VisitableBuilder<ContainerCreateRequest, ContainerCreateRequestBuilder> {
    ContainerCreateRequestFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerCreateRequestBuilder() {
        this(true);
    }

    public ContainerCreateRequestBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public ContainerCreateRequestBuilder(ContainerCreateRequestFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerCreateRequestBuilder(ContainerCreateRequestFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public ContainerCreateRequestBuilder(ContainerCreateRequestFluent<?> fluent, ContainerCreateRequest instance) {
        this(fluent, instance, true);
    }

    public ContainerCreateRequestBuilder(ContainerCreateRequestFluent<?> fluent, ContainerCreateRequest instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withCpuset(instance.getCpuset());
        fluent.withHostname(instance.getHostname());
        fluent.withDomainname(instance.getDomainname());
        fluent.withUser(instance.getUser());
        fluent.withMemory(instance.getMemory());
        fluent.withMemorySwap(instance.getMemorySwap());
        fluent.withMemoryReservation(instance.getMemoryReservation());
        fluent.withKernelMemory(instance.getKernelMemory());
        fluent.withCpuShares(instance.getCpuShares());
        fluent.withCpuPeriod(instance.getCpuPeriod());
        fluent.withCpuQuota(instance.getCpuQuota());
        fluent.withCpusetCpus(instance.getCpusetCpus());
        fluent.withCpusetMems(instance.getCpusetMems());
        fluent.withBlkioWeight(instance.getBlkioWeight());
        fluent.withMemorySwappiness(instance.getMemorySwappiness());
        fluent.withOomKillDisable(instance.getOomKillDisable());
        fluent.withAttachStdin(instance.getAttachStdin());
        fluent.withAttachStdout(instance.getAttachStdout());
        fluent.withAttachStderr(instance.getAttachStderr());
        fluent.withTty(instance.getTty());
        fluent.withOpenStdin(instance.getOpenStdin());
        fluent.withStdinOnce(instance.getStdinOnce());
        fluent.withEnv(instance.getEnv());
        fluent.withCmd(instance.getCmd());
        fluent.withEntrypoint(instance.getEntrypoint());
        fluent.withImage(instance.getImage());
        fluent.withLabels(instance.getLabels());
        fluent.withVolumes(instance.getVolumes());
        fluent.withWorkingDir(instance.getWorkingDir());
        fluent.withNetworkDisabled(instance.getNetworkDisabled());
        fluent.withMacAddress(instance.getMacAddress());
        fluent.withExposedPorts(instance.getExposedPorts());
        fluent.withStopSignal(instance.getStopSignal());
        fluent.withHostConfig(instance.getHostConfig());
        fluent.withIpv4Address(instance.getIpv4Address());
        fluent.withIpv6Address(instance.getIpv6Address());
        this.validationEnabled = validationEnabled;
    }

    public ContainerCreateRequestBuilder(ContainerCreateRequest instance) {
        this(instance, (Boolean)true);
    }

    public ContainerCreateRequestBuilder(ContainerCreateRequest instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withCpuset(instance.getCpuset());
        this.withHostname(instance.getHostname());
        this.withDomainname(instance.getDomainname());
        this.withUser(instance.getUser());
        this.withMemory(instance.getMemory());
        this.withMemorySwap(instance.getMemorySwap());
        this.withMemoryReservation(instance.getMemoryReservation());
        this.withKernelMemory(instance.getKernelMemory());
        this.withCpuShares(instance.getCpuShares());
        this.withCpuPeriod(instance.getCpuPeriod());
        this.withCpuQuota(instance.getCpuQuota());
        this.withCpusetCpus(instance.getCpusetCpus());
        this.withCpusetMems(instance.getCpusetMems());
        this.withBlkioWeight(instance.getBlkioWeight());
        this.withMemorySwappiness(instance.getMemorySwappiness());
        this.withOomKillDisable(instance.getOomKillDisable());
        this.withAttachStdin(instance.getAttachStdin());
        this.withAttachStdout(instance.getAttachStdout());
        this.withAttachStderr(instance.getAttachStderr());
        this.withTty(instance.getTty());
        this.withOpenStdin(instance.getOpenStdin());
        this.withStdinOnce(instance.getStdinOnce());
        this.withEnv(instance.getEnv());
        this.withCmd(instance.getCmd());
        this.withEntrypoint(instance.getEntrypoint());
        this.withImage(instance.getImage());
        this.withLabels(instance.getLabels());
        this.withVolumes(instance.getVolumes());
        this.withWorkingDir(instance.getWorkingDir());
        this.withNetworkDisabled(instance.getNetworkDisabled());
        this.withMacAddress(instance.getMacAddress());
        this.withExposedPorts(instance.getExposedPorts());
        this.withStopSignal(instance.getStopSignal());
        this.withHostConfig(instance.getHostConfig());
        this.withIpv4Address(instance.getIpv4Address());
        this.withIpv6Address(instance.getIpv6Address());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableContainerCreateRequest build() {
        EditableContainerCreateRequest buildable = new EditableContainerCreateRequest(this.fluent.getName(), this.fluent.getCpuset(), this.fluent.getHostname(), this.fluent.getDomainname(), this.fluent.getUser(), this.fluent.getMemory(), this.fluent.getMemorySwap(), this.fluent.getMemoryReservation(), this.fluent.getKernelMemory(), this.fluent.getCpuShares(), this.fluent.getCpuPeriod(), this.fluent.getCpuQuota(), this.fluent.getCpusetCpus(), this.fluent.getCpusetMems(), this.fluent.getBlkioWeight(), this.fluent.getMemorySwappiness(), this.fluent.isOomKillDisable(), this.fluent.isAttachStdin(), this.fluent.isAttachStdout(), this.fluent.isAttachStderr(), this.fluent.isTty(), this.fluent.isOpenStdin(), this.fluent.isStdinOnce(), this.fluent.getEnv(), this.fluent.getCmd(), this.fluent.getEntrypoint(), this.fluent.getImage(), this.fluent.getLabels(), this.fluent.getVolumes(), this.fluent.getWorkingDir(), this.fluent.isNetworkDisabled(), this.fluent.getMacAddress(), this.fluent.getExposedPorts(), this.fluent.getStopSignal(), this.fluent.getHostConfig(), this.fluent.getIpv4Address(), this.fluent.getIpv6Address());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerCreateRequestBuilder that = (ContainerCreateRequestBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

