/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.CPUStats;
import io.fabric8.docker.api.model.CPUStatsFluent;
import io.fabric8.docker.api.model.CPUStatsFluentImpl;
import io.fabric8.docker.api.model.EditableCPUStats;

public class CPUStatsBuilder
extends CPUStatsFluentImpl<CPUStatsBuilder>
implements VisitableBuilder<CPUStats, CPUStatsBuilder> {
    CPUStatsFluent<?> fluent;
    Boolean validationEnabled;

    public CPUStatsBuilder() {
        this(true);
    }

    public CPUStatsBuilder(Boolean validationEnabled) {
        this(new CPUStats(), validationEnabled);
    }

    public CPUStatsBuilder(CPUStatsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CPUStatsBuilder(CPUStatsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CPUStats(), validationEnabled);
    }

    public CPUStatsBuilder(CPUStatsFluent<?> fluent, CPUStats instance) {
        this(fluent, instance, true);
    }

    public CPUStatsBuilder(CPUStatsFluent<?> fluent, CPUStats instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCpuUsage(instance.getCpuUsage());
        fluent.withSystemCpuUsage(instance.getSystemCpuUsage());
        fluent.withThrottlingData(instance.getThrottlingData());
        this.validationEnabled = validationEnabled;
    }

    public CPUStatsBuilder(CPUStats instance) {
        this(instance, (Boolean)true);
    }

    public CPUStatsBuilder(CPUStats instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCpuUsage(instance.getCpuUsage());
        this.withSystemCpuUsage(instance.getSystemCpuUsage());
        this.withThrottlingData(instance.getThrottlingData());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableCPUStats build() {
        EditableCPUStats buildable = new EditableCPUStats(this.fluent.getCpuUsage(), this.fluent.getSystemCpuUsage(), this.fluent.getThrottlingData());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUStatsBuilder that = (CPUStatsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

