/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.BlkioStatEntry;
import io.fabric8.docker.api.model.BlkioStatEntryBuilder;
import io.fabric8.docker.api.model.BlkioStatEntryFluentImpl;
import io.fabric8.docker.api.model.BlkioStats;
import io.fabric8.docker.api.model.BlkioStatsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BlkioStatsFluentImpl<A extends BlkioStatsFluent<A>>
extends BaseFluent<A>
implements BlkioStatsFluent<A> {
    private List<BlkioStatEntryBuilder> ioMergedRecursive = new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioQueueRecursive = new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioServiceBytesRecursive = new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioServiceTimeRecursive = new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioServicedRecursive = new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioTimeRecursive = new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioWaitTimeRecursive = new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> sectorsRecursive = new ArrayList<BlkioStatEntryBuilder>();

    public BlkioStatsFluentImpl() {
    }

    public BlkioStatsFluentImpl(BlkioStats instance) {
        this.withIoMergedRecursive(instance.getIoMergedRecursive());
        this.withIoQueueRecursive(instance.getIoQueueRecursive());
        this.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive());
        this.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive());
        this.withIoServicedRecursive(instance.getIoServicedRecursive());
        this.withIoTimeRecursive(instance.getIoTimeRecursive());
        this.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive());
        this.withSectorsRecursive(instance.getSectorsRecursive());
    }

    @Override
    public A addToIoMergedRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ioMergedRecursive.add(index >= 0 ? index : this.ioMergedRecursive.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIoMergedRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ioMergedRecursive.size()) {
            this.ioMergedRecursive.add(builder);
        } else {
            this.ioMergedRecursive.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIoMergedRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioMergedRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIoMergedRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioMergedRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIoMergedRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioMergedRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIoMergedRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioMergedRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BlkioStatEntry> getIoMergedRecursive() {
        return BlkioStatsFluentImpl.build(this.ioMergedRecursive);
    }

    @Override
    public List<BlkioStatEntry> buildIoMergedRecursive() {
        return BlkioStatsFluentImpl.build(this.ioMergedRecursive);
    }

    @Override
    public BlkioStatEntry buildIoMergedRecursive(int index) {
        return this.ioMergedRecursive.get(index).build();
    }

    @Override
    public BlkioStatEntry buildFirstIoMergedRecursive() {
        return this.ioMergedRecursive.get(0).build();
    }

    @Override
    public BlkioStatEntry buildLastIoMergedRecursive() {
        return this.ioMergedRecursive.get(this.ioMergedRecursive.size() - 1).build();
    }

    @Override
    public BlkioStatEntry buildMatchingIoMergedRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        for (BlkioStatEntryBuilder item : this.ioMergedRecursive) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withIoMergedRecursive(List<BlkioStatEntry> ioMergedRecursive) {
        this._visitables.removeAll(this.ioMergedRecursive);
        this.ioMergedRecursive.clear();
        if (ioMergedRecursive != null) {
            for (BlkioStatEntry item : ioMergedRecursive) {
                this.addToIoMergedRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIoMergedRecursive(BlkioStatEntry ... ioMergedRecursive) {
        this.ioMergedRecursive.clear();
        if (ioMergedRecursive != null) {
            for (BlkioStatEntry item : ioMergedRecursive) {
                this.addToIoMergedRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIoMergedRecursive() {
        return this.ioMergedRecursive != null && !this.ioMergedRecursive.isEmpty();
    }

    @Override
    public BlkioStatsFluent.IoMergedRecursiveNested<A> addNewIoMergedRecursive() {
        return new IoMergedRecursiveNestedImpl();
    }

    @Override
    public BlkioStatsFluent.IoMergedRecursiveNested<A> addNewIoMergedRecursiveLike(BlkioStatEntry item) {
        return new IoMergedRecursiveNestedImpl(-1, item);
    }

    @Override
    public BlkioStatsFluent.IoMergedRecursiveNested<A> setNewIoMergedRecursiveLike(int index, BlkioStatEntry item) {
        return new IoMergedRecursiveNestedImpl(index, item);
    }

    @Override
    public BlkioStatsFluent.IoMergedRecursiveNested<A> editIoMergedRecursive(int index) {
        if (this.ioMergedRecursive.size() <= index) {
            throw new RuntimeException("Can't edit ioMergedRecursive. Index exceeds size.");
        }
        return this.setNewIoMergedRecursiveLike(index, this.buildIoMergedRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoMergedRecursiveNested<A> editFirstIoMergedRecursive() {
        if (this.ioMergedRecursive.size() == 0) {
            throw new RuntimeException("Can't edit first ioMergedRecursive. The list is empty.");
        }
        return this.setNewIoMergedRecursiveLike(0, this.buildIoMergedRecursive(0));
    }

    @Override
    public BlkioStatsFluent.IoMergedRecursiveNested<A> editLastIoMergedRecursive() {
        int index = this.ioMergedRecursive.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ioMergedRecursive. The list is empty.");
        }
        return this.setNewIoMergedRecursiveLike(index, this.buildIoMergedRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoMergedRecursiveNested<A> editMatchingIoMergedRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ioMergedRecursive.size(); ++i) {
            if (!predicate.apply(this.ioMergedRecursive.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ioMergedRecursive. No match found.");
        }
        return this.setNewIoMergedRecursiveLike(index, this.buildIoMergedRecursive(index));
    }

    @Override
    public A addNewIoMergedRecursive(Long major, Long minor, String op, Long value) {
        return this.addToIoMergedRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    @Override
    public A addToIoQueueRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ioQueueRecursive.add(index >= 0 ? index : this.ioQueueRecursive.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIoQueueRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ioQueueRecursive.size()) {
            this.ioQueueRecursive.add(builder);
        } else {
            this.ioQueueRecursive.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIoQueueRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioQueueRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIoQueueRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioQueueRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIoQueueRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioQueueRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIoQueueRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioQueueRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BlkioStatEntry> getIoQueueRecursive() {
        return BlkioStatsFluentImpl.build(this.ioQueueRecursive);
    }

    @Override
    public List<BlkioStatEntry> buildIoQueueRecursive() {
        return BlkioStatsFluentImpl.build(this.ioQueueRecursive);
    }

    @Override
    public BlkioStatEntry buildIoQueueRecursive(int index) {
        return this.ioQueueRecursive.get(index).build();
    }

    @Override
    public BlkioStatEntry buildFirstIoQueueRecursive() {
        return this.ioQueueRecursive.get(0).build();
    }

    @Override
    public BlkioStatEntry buildLastIoQueueRecursive() {
        return this.ioQueueRecursive.get(this.ioQueueRecursive.size() - 1).build();
    }

    @Override
    public BlkioStatEntry buildMatchingIoQueueRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        for (BlkioStatEntryBuilder item : this.ioQueueRecursive) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withIoQueueRecursive(List<BlkioStatEntry> ioQueueRecursive) {
        this._visitables.removeAll(this.ioQueueRecursive);
        this.ioQueueRecursive.clear();
        if (ioQueueRecursive != null) {
            for (BlkioStatEntry item : ioQueueRecursive) {
                this.addToIoQueueRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIoQueueRecursive(BlkioStatEntry ... ioQueueRecursive) {
        this.ioQueueRecursive.clear();
        if (ioQueueRecursive != null) {
            for (BlkioStatEntry item : ioQueueRecursive) {
                this.addToIoQueueRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIoQueueRecursive() {
        return this.ioQueueRecursive != null && !this.ioQueueRecursive.isEmpty();
    }

    @Override
    public BlkioStatsFluent.IoQueueRecursiveNested<A> addNewIoQueueRecursive() {
        return new IoQueueRecursiveNestedImpl();
    }

    @Override
    public BlkioStatsFluent.IoQueueRecursiveNested<A> addNewIoQueueRecursiveLike(BlkioStatEntry item) {
        return new IoQueueRecursiveNestedImpl(-1, item);
    }

    @Override
    public BlkioStatsFluent.IoQueueRecursiveNested<A> setNewIoQueueRecursiveLike(int index, BlkioStatEntry item) {
        return new IoQueueRecursiveNestedImpl(index, item);
    }

    @Override
    public BlkioStatsFluent.IoQueueRecursiveNested<A> editIoQueueRecursive(int index) {
        if (this.ioQueueRecursive.size() <= index) {
            throw new RuntimeException("Can't edit ioQueueRecursive. Index exceeds size.");
        }
        return this.setNewIoQueueRecursiveLike(index, this.buildIoQueueRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoQueueRecursiveNested<A> editFirstIoQueueRecursive() {
        if (this.ioQueueRecursive.size() == 0) {
            throw new RuntimeException("Can't edit first ioQueueRecursive. The list is empty.");
        }
        return this.setNewIoQueueRecursiveLike(0, this.buildIoQueueRecursive(0));
    }

    @Override
    public BlkioStatsFluent.IoQueueRecursiveNested<A> editLastIoQueueRecursive() {
        int index = this.ioQueueRecursive.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ioQueueRecursive. The list is empty.");
        }
        return this.setNewIoQueueRecursiveLike(index, this.buildIoQueueRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoQueueRecursiveNested<A> editMatchingIoQueueRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ioQueueRecursive.size(); ++i) {
            if (!predicate.apply(this.ioQueueRecursive.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ioQueueRecursive. No match found.");
        }
        return this.setNewIoQueueRecursiveLike(index, this.buildIoQueueRecursive(index));
    }

    @Override
    public A addNewIoQueueRecursive(Long major, Long minor, String op, Long value) {
        return this.addToIoQueueRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    @Override
    public A addToIoServiceBytesRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ioServiceBytesRecursive.add(index >= 0 ? index : this.ioServiceBytesRecursive.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIoServiceBytesRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ioServiceBytesRecursive.size()) {
            this.ioServiceBytesRecursive.add(builder);
        } else {
            this.ioServiceBytesRecursive.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIoServiceBytesRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioServiceBytesRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIoServiceBytesRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioServiceBytesRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIoServiceBytesRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioServiceBytesRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIoServiceBytesRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioServiceBytesRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BlkioStatEntry> getIoServiceBytesRecursive() {
        return BlkioStatsFluentImpl.build(this.ioServiceBytesRecursive);
    }

    @Override
    public List<BlkioStatEntry> buildIoServiceBytesRecursive() {
        return BlkioStatsFluentImpl.build(this.ioServiceBytesRecursive);
    }

    @Override
    public BlkioStatEntry buildIoServiceBytesRecursive(int index) {
        return this.ioServiceBytesRecursive.get(index).build();
    }

    @Override
    public BlkioStatEntry buildFirstIoServiceBytesRecursive() {
        return this.ioServiceBytesRecursive.get(0).build();
    }

    @Override
    public BlkioStatEntry buildLastIoServiceBytesRecursive() {
        return this.ioServiceBytesRecursive.get(this.ioServiceBytesRecursive.size() - 1).build();
    }

    @Override
    public BlkioStatEntry buildMatchingIoServiceBytesRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        for (BlkioStatEntryBuilder item : this.ioServiceBytesRecursive) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withIoServiceBytesRecursive(List<BlkioStatEntry> ioServiceBytesRecursive) {
        this._visitables.removeAll(this.ioServiceBytesRecursive);
        this.ioServiceBytesRecursive.clear();
        if (ioServiceBytesRecursive != null) {
            for (BlkioStatEntry item : ioServiceBytesRecursive) {
                this.addToIoServiceBytesRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIoServiceBytesRecursive(BlkioStatEntry ... ioServiceBytesRecursive) {
        this.ioServiceBytesRecursive.clear();
        if (ioServiceBytesRecursive != null) {
            for (BlkioStatEntry item : ioServiceBytesRecursive) {
                this.addToIoServiceBytesRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIoServiceBytesRecursive() {
        return this.ioServiceBytesRecursive != null && !this.ioServiceBytesRecursive.isEmpty();
    }

    @Override
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> addNewIoServiceBytesRecursive() {
        return new IoServiceBytesRecursiveNestedImpl();
    }

    @Override
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> addNewIoServiceBytesRecursiveLike(BlkioStatEntry item) {
        return new IoServiceBytesRecursiveNestedImpl(-1, item);
    }

    @Override
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> setNewIoServiceBytesRecursiveLike(int index, BlkioStatEntry item) {
        return new IoServiceBytesRecursiveNestedImpl(index, item);
    }

    @Override
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editIoServiceBytesRecursive(int index) {
        if (this.ioServiceBytesRecursive.size() <= index) {
            throw new RuntimeException("Can't edit ioServiceBytesRecursive. Index exceeds size.");
        }
        return this.setNewIoServiceBytesRecursiveLike(index, this.buildIoServiceBytesRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editFirstIoServiceBytesRecursive() {
        if (this.ioServiceBytesRecursive.size() == 0) {
            throw new RuntimeException("Can't edit first ioServiceBytesRecursive. The list is empty.");
        }
        return this.setNewIoServiceBytesRecursiveLike(0, this.buildIoServiceBytesRecursive(0));
    }

    @Override
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editLastIoServiceBytesRecursive() {
        int index = this.ioServiceBytesRecursive.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ioServiceBytesRecursive. The list is empty.");
        }
        return this.setNewIoServiceBytesRecursiveLike(index, this.buildIoServiceBytesRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editMatchingIoServiceBytesRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ioServiceBytesRecursive.size(); ++i) {
            if (!predicate.apply(this.ioServiceBytesRecursive.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ioServiceBytesRecursive. No match found.");
        }
        return this.setNewIoServiceBytesRecursiveLike(index, this.buildIoServiceBytesRecursive(index));
    }

    @Override
    public A addNewIoServiceBytesRecursive(Long major, Long minor, String op, Long value) {
        return this.addToIoServiceBytesRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    @Override
    public A addToIoServiceTimeRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ioServiceTimeRecursive.add(index >= 0 ? index : this.ioServiceTimeRecursive.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIoServiceTimeRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ioServiceTimeRecursive.size()) {
            this.ioServiceTimeRecursive.add(builder);
        } else {
            this.ioServiceTimeRecursive.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIoServiceTimeRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioServiceTimeRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIoServiceTimeRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioServiceTimeRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIoServiceTimeRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioServiceTimeRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIoServiceTimeRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioServiceTimeRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BlkioStatEntry> getIoServiceTimeRecursive() {
        return BlkioStatsFluentImpl.build(this.ioServiceTimeRecursive);
    }

    @Override
    public List<BlkioStatEntry> buildIoServiceTimeRecursive() {
        return BlkioStatsFluentImpl.build(this.ioServiceTimeRecursive);
    }

    @Override
    public BlkioStatEntry buildIoServiceTimeRecursive(int index) {
        return this.ioServiceTimeRecursive.get(index).build();
    }

    @Override
    public BlkioStatEntry buildFirstIoServiceTimeRecursive() {
        return this.ioServiceTimeRecursive.get(0).build();
    }

    @Override
    public BlkioStatEntry buildLastIoServiceTimeRecursive() {
        return this.ioServiceTimeRecursive.get(this.ioServiceTimeRecursive.size() - 1).build();
    }

    @Override
    public BlkioStatEntry buildMatchingIoServiceTimeRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        for (BlkioStatEntryBuilder item : this.ioServiceTimeRecursive) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withIoServiceTimeRecursive(List<BlkioStatEntry> ioServiceTimeRecursive) {
        this._visitables.removeAll(this.ioServiceTimeRecursive);
        this.ioServiceTimeRecursive.clear();
        if (ioServiceTimeRecursive != null) {
            for (BlkioStatEntry item : ioServiceTimeRecursive) {
                this.addToIoServiceTimeRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIoServiceTimeRecursive(BlkioStatEntry ... ioServiceTimeRecursive) {
        this.ioServiceTimeRecursive.clear();
        if (ioServiceTimeRecursive != null) {
            for (BlkioStatEntry item : ioServiceTimeRecursive) {
                this.addToIoServiceTimeRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIoServiceTimeRecursive() {
        return this.ioServiceTimeRecursive != null && !this.ioServiceTimeRecursive.isEmpty();
    }

    @Override
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> addNewIoServiceTimeRecursive() {
        return new IoServiceTimeRecursiveNestedImpl();
    }

    @Override
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> addNewIoServiceTimeRecursiveLike(BlkioStatEntry item) {
        return new IoServiceTimeRecursiveNestedImpl(-1, item);
    }

    @Override
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> setNewIoServiceTimeRecursiveLike(int index, BlkioStatEntry item) {
        return new IoServiceTimeRecursiveNestedImpl(index, item);
    }

    @Override
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editIoServiceTimeRecursive(int index) {
        if (this.ioServiceTimeRecursive.size() <= index) {
            throw new RuntimeException("Can't edit ioServiceTimeRecursive. Index exceeds size.");
        }
        return this.setNewIoServiceTimeRecursiveLike(index, this.buildIoServiceTimeRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editFirstIoServiceTimeRecursive() {
        if (this.ioServiceTimeRecursive.size() == 0) {
            throw new RuntimeException("Can't edit first ioServiceTimeRecursive. The list is empty.");
        }
        return this.setNewIoServiceTimeRecursiveLike(0, this.buildIoServiceTimeRecursive(0));
    }

    @Override
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editLastIoServiceTimeRecursive() {
        int index = this.ioServiceTimeRecursive.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ioServiceTimeRecursive. The list is empty.");
        }
        return this.setNewIoServiceTimeRecursiveLike(index, this.buildIoServiceTimeRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editMatchingIoServiceTimeRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ioServiceTimeRecursive.size(); ++i) {
            if (!predicate.apply(this.ioServiceTimeRecursive.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ioServiceTimeRecursive. No match found.");
        }
        return this.setNewIoServiceTimeRecursiveLike(index, this.buildIoServiceTimeRecursive(index));
    }

    @Override
    public A addNewIoServiceTimeRecursive(Long major, Long minor, String op, Long value) {
        return this.addToIoServiceTimeRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    @Override
    public A addToIoServicedRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ioServicedRecursive.add(index >= 0 ? index : this.ioServicedRecursive.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIoServicedRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ioServicedRecursive.size()) {
            this.ioServicedRecursive.add(builder);
        } else {
            this.ioServicedRecursive.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIoServicedRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioServicedRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIoServicedRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioServicedRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIoServicedRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioServicedRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIoServicedRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioServicedRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BlkioStatEntry> getIoServicedRecursive() {
        return BlkioStatsFluentImpl.build(this.ioServicedRecursive);
    }

    @Override
    public List<BlkioStatEntry> buildIoServicedRecursive() {
        return BlkioStatsFluentImpl.build(this.ioServicedRecursive);
    }

    @Override
    public BlkioStatEntry buildIoServicedRecursive(int index) {
        return this.ioServicedRecursive.get(index).build();
    }

    @Override
    public BlkioStatEntry buildFirstIoServicedRecursive() {
        return this.ioServicedRecursive.get(0).build();
    }

    @Override
    public BlkioStatEntry buildLastIoServicedRecursive() {
        return this.ioServicedRecursive.get(this.ioServicedRecursive.size() - 1).build();
    }

    @Override
    public BlkioStatEntry buildMatchingIoServicedRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        for (BlkioStatEntryBuilder item : this.ioServicedRecursive) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withIoServicedRecursive(List<BlkioStatEntry> ioServicedRecursive) {
        this._visitables.removeAll(this.ioServicedRecursive);
        this.ioServicedRecursive.clear();
        if (ioServicedRecursive != null) {
            for (BlkioStatEntry item : ioServicedRecursive) {
                this.addToIoServicedRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIoServicedRecursive(BlkioStatEntry ... ioServicedRecursive) {
        this.ioServicedRecursive.clear();
        if (ioServicedRecursive != null) {
            for (BlkioStatEntry item : ioServicedRecursive) {
                this.addToIoServicedRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIoServicedRecursive() {
        return this.ioServicedRecursive != null && !this.ioServicedRecursive.isEmpty();
    }

    @Override
    public BlkioStatsFluent.IoServicedRecursiveNested<A> addNewIoServicedRecursive() {
        return new IoServicedRecursiveNestedImpl();
    }

    @Override
    public BlkioStatsFluent.IoServicedRecursiveNested<A> addNewIoServicedRecursiveLike(BlkioStatEntry item) {
        return new IoServicedRecursiveNestedImpl(-1, item);
    }

    @Override
    public BlkioStatsFluent.IoServicedRecursiveNested<A> setNewIoServicedRecursiveLike(int index, BlkioStatEntry item) {
        return new IoServicedRecursiveNestedImpl(index, item);
    }

    @Override
    public BlkioStatsFluent.IoServicedRecursiveNested<A> editIoServicedRecursive(int index) {
        if (this.ioServicedRecursive.size() <= index) {
            throw new RuntimeException("Can't edit ioServicedRecursive. Index exceeds size.");
        }
        return this.setNewIoServicedRecursiveLike(index, this.buildIoServicedRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoServicedRecursiveNested<A> editFirstIoServicedRecursive() {
        if (this.ioServicedRecursive.size() == 0) {
            throw new RuntimeException("Can't edit first ioServicedRecursive. The list is empty.");
        }
        return this.setNewIoServicedRecursiveLike(0, this.buildIoServicedRecursive(0));
    }

    @Override
    public BlkioStatsFluent.IoServicedRecursiveNested<A> editLastIoServicedRecursive() {
        int index = this.ioServicedRecursive.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ioServicedRecursive. The list is empty.");
        }
        return this.setNewIoServicedRecursiveLike(index, this.buildIoServicedRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoServicedRecursiveNested<A> editMatchingIoServicedRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ioServicedRecursive.size(); ++i) {
            if (!predicate.apply(this.ioServicedRecursive.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ioServicedRecursive. No match found.");
        }
        return this.setNewIoServicedRecursiveLike(index, this.buildIoServicedRecursive(index));
    }

    @Override
    public A addNewIoServicedRecursive(Long major, Long minor, String op, Long value) {
        return this.addToIoServicedRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    @Override
    public A addToIoTimeRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ioTimeRecursive.add(index >= 0 ? index : this.ioTimeRecursive.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIoTimeRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ioTimeRecursive.size()) {
            this.ioTimeRecursive.add(builder);
        } else {
            this.ioTimeRecursive.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIoTimeRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioTimeRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIoTimeRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioTimeRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIoTimeRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioTimeRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIoTimeRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioTimeRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BlkioStatEntry> getIoTimeRecursive() {
        return BlkioStatsFluentImpl.build(this.ioTimeRecursive);
    }

    @Override
    public List<BlkioStatEntry> buildIoTimeRecursive() {
        return BlkioStatsFluentImpl.build(this.ioTimeRecursive);
    }

    @Override
    public BlkioStatEntry buildIoTimeRecursive(int index) {
        return this.ioTimeRecursive.get(index).build();
    }

    @Override
    public BlkioStatEntry buildFirstIoTimeRecursive() {
        return this.ioTimeRecursive.get(0).build();
    }

    @Override
    public BlkioStatEntry buildLastIoTimeRecursive() {
        return this.ioTimeRecursive.get(this.ioTimeRecursive.size() - 1).build();
    }

    @Override
    public BlkioStatEntry buildMatchingIoTimeRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        for (BlkioStatEntryBuilder item : this.ioTimeRecursive) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withIoTimeRecursive(List<BlkioStatEntry> ioTimeRecursive) {
        this._visitables.removeAll(this.ioTimeRecursive);
        this.ioTimeRecursive.clear();
        if (ioTimeRecursive != null) {
            for (BlkioStatEntry item : ioTimeRecursive) {
                this.addToIoTimeRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIoTimeRecursive(BlkioStatEntry ... ioTimeRecursive) {
        this.ioTimeRecursive.clear();
        if (ioTimeRecursive != null) {
            for (BlkioStatEntry item : ioTimeRecursive) {
                this.addToIoTimeRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIoTimeRecursive() {
        return this.ioTimeRecursive != null && !this.ioTimeRecursive.isEmpty();
    }

    @Override
    public BlkioStatsFluent.IoTimeRecursiveNested<A> addNewIoTimeRecursive() {
        return new IoTimeRecursiveNestedImpl();
    }

    @Override
    public BlkioStatsFluent.IoTimeRecursiveNested<A> addNewIoTimeRecursiveLike(BlkioStatEntry item) {
        return new IoTimeRecursiveNestedImpl(-1, item);
    }

    @Override
    public BlkioStatsFluent.IoTimeRecursiveNested<A> setNewIoTimeRecursiveLike(int index, BlkioStatEntry item) {
        return new IoTimeRecursiveNestedImpl(index, item);
    }

    @Override
    public BlkioStatsFluent.IoTimeRecursiveNested<A> editIoTimeRecursive(int index) {
        if (this.ioTimeRecursive.size() <= index) {
            throw new RuntimeException("Can't edit ioTimeRecursive. Index exceeds size.");
        }
        return this.setNewIoTimeRecursiveLike(index, this.buildIoTimeRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoTimeRecursiveNested<A> editFirstIoTimeRecursive() {
        if (this.ioTimeRecursive.size() == 0) {
            throw new RuntimeException("Can't edit first ioTimeRecursive. The list is empty.");
        }
        return this.setNewIoTimeRecursiveLike(0, this.buildIoTimeRecursive(0));
    }

    @Override
    public BlkioStatsFluent.IoTimeRecursiveNested<A> editLastIoTimeRecursive() {
        int index = this.ioTimeRecursive.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ioTimeRecursive. The list is empty.");
        }
        return this.setNewIoTimeRecursiveLike(index, this.buildIoTimeRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoTimeRecursiveNested<A> editMatchingIoTimeRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ioTimeRecursive.size(); ++i) {
            if (!predicate.apply(this.ioTimeRecursive.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ioTimeRecursive. No match found.");
        }
        return this.setNewIoTimeRecursiveLike(index, this.buildIoTimeRecursive(index));
    }

    @Override
    public A addNewIoTimeRecursive(Long major, Long minor, String op, Long value) {
        return this.addToIoTimeRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    @Override
    public A addToIoWaitTimeRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ioWaitTimeRecursive.add(index >= 0 ? index : this.ioWaitTimeRecursive.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIoWaitTimeRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ioWaitTimeRecursive.size()) {
            this.ioWaitTimeRecursive.add(builder);
        } else {
            this.ioWaitTimeRecursive.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIoWaitTimeRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioWaitTimeRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIoWaitTimeRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.ioWaitTimeRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIoWaitTimeRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioWaitTimeRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIoWaitTimeRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.ioWaitTimeRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BlkioStatEntry> getIoWaitTimeRecursive() {
        return BlkioStatsFluentImpl.build(this.ioWaitTimeRecursive);
    }

    @Override
    public List<BlkioStatEntry> buildIoWaitTimeRecursive() {
        return BlkioStatsFluentImpl.build(this.ioWaitTimeRecursive);
    }

    @Override
    public BlkioStatEntry buildIoWaitTimeRecursive(int index) {
        return this.ioWaitTimeRecursive.get(index).build();
    }

    @Override
    public BlkioStatEntry buildFirstIoWaitTimeRecursive() {
        return this.ioWaitTimeRecursive.get(0).build();
    }

    @Override
    public BlkioStatEntry buildLastIoWaitTimeRecursive() {
        return this.ioWaitTimeRecursive.get(this.ioWaitTimeRecursive.size() - 1).build();
    }

    @Override
    public BlkioStatEntry buildMatchingIoWaitTimeRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        for (BlkioStatEntryBuilder item : this.ioWaitTimeRecursive) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withIoWaitTimeRecursive(List<BlkioStatEntry> ioWaitTimeRecursive) {
        this._visitables.removeAll(this.ioWaitTimeRecursive);
        this.ioWaitTimeRecursive.clear();
        if (ioWaitTimeRecursive != null) {
            for (BlkioStatEntry item : ioWaitTimeRecursive) {
                this.addToIoWaitTimeRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIoWaitTimeRecursive(BlkioStatEntry ... ioWaitTimeRecursive) {
        this.ioWaitTimeRecursive.clear();
        if (ioWaitTimeRecursive != null) {
            for (BlkioStatEntry item : ioWaitTimeRecursive) {
                this.addToIoWaitTimeRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIoWaitTimeRecursive() {
        return this.ioWaitTimeRecursive != null && !this.ioWaitTimeRecursive.isEmpty();
    }

    @Override
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> addNewIoWaitTimeRecursive() {
        return new IoWaitTimeRecursiveNestedImpl();
    }

    @Override
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> addNewIoWaitTimeRecursiveLike(BlkioStatEntry item) {
        return new IoWaitTimeRecursiveNestedImpl(-1, item);
    }

    @Override
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> setNewIoWaitTimeRecursiveLike(int index, BlkioStatEntry item) {
        return new IoWaitTimeRecursiveNestedImpl(index, item);
    }

    @Override
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editIoWaitTimeRecursive(int index) {
        if (this.ioWaitTimeRecursive.size() <= index) {
            throw new RuntimeException("Can't edit ioWaitTimeRecursive. Index exceeds size.");
        }
        return this.setNewIoWaitTimeRecursiveLike(index, this.buildIoWaitTimeRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editFirstIoWaitTimeRecursive() {
        if (this.ioWaitTimeRecursive.size() == 0) {
            throw new RuntimeException("Can't edit first ioWaitTimeRecursive. The list is empty.");
        }
        return this.setNewIoWaitTimeRecursiveLike(0, this.buildIoWaitTimeRecursive(0));
    }

    @Override
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editLastIoWaitTimeRecursive() {
        int index = this.ioWaitTimeRecursive.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ioWaitTimeRecursive. The list is empty.");
        }
        return this.setNewIoWaitTimeRecursiveLike(index, this.buildIoWaitTimeRecursive(index));
    }

    @Override
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editMatchingIoWaitTimeRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ioWaitTimeRecursive.size(); ++i) {
            if (!predicate.apply(this.ioWaitTimeRecursive.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ioWaitTimeRecursive. No match found.");
        }
        return this.setNewIoWaitTimeRecursiveLike(index, this.buildIoWaitTimeRecursive(index));
    }

    @Override
    public A addNewIoWaitTimeRecursive(Long major, Long minor, String op, Long value) {
        return this.addToIoWaitTimeRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    @Override
    public A addToSectorsRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.sectorsRecursive.add(index >= 0 ? index : this.sectorsRecursive.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSectorsRecursive(int index, BlkioStatEntry item) {
        BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.sectorsRecursive.size()) {
            this.sectorsRecursive.add(builder);
        } else {
            this.sectorsRecursive.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSectorsRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.sectorsRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSectorsRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.add(builder);
            this.sectorsRecursive.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSectorsRecursive(BlkioStatEntry ... items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.sectorsRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSectorsRecursive(Collection<BlkioStatEntry> items) {
        for (BlkioStatEntry item : items) {
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            this._visitables.remove(builder);
            this.sectorsRecursive.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BlkioStatEntry> getSectorsRecursive() {
        return BlkioStatsFluentImpl.build(this.sectorsRecursive);
    }

    @Override
    public List<BlkioStatEntry> buildSectorsRecursive() {
        return BlkioStatsFluentImpl.build(this.sectorsRecursive);
    }

    @Override
    public BlkioStatEntry buildSectorsRecursive(int index) {
        return this.sectorsRecursive.get(index).build();
    }

    @Override
    public BlkioStatEntry buildFirstSectorsRecursive() {
        return this.sectorsRecursive.get(0).build();
    }

    @Override
    public BlkioStatEntry buildLastSectorsRecursive() {
        return this.sectorsRecursive.get(this.sectorsRecursive.size() - 1).build();
    }

    @Override
    public BlkioStatEntry buildMatchingSectorsRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        for (BlkioStatEntryBuilder item : this.sectorsRecursive) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSectorsRecursive(List<BlkioStatEntry> sectorsRecursive) {
        this._visitables.removeAll(this.sectorsRecursive);
        this.sectorsRecursive.clear();
        if (sectorsRecursive != null) {
            for (BlkioStatEntry item : sectorsRecursive) {
                this.addToSectorsRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSectorsRecursive(BlkioStatEntry ... sectorsRecursive) {
        this.sectorsRecursive.clear();
        if (sectorsRecursive != null) {
            for (BlkioStatEntry item : sectorsRecursive) {
                this.addToSectorsRecursive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSectorsRecursive() {
        return this.sectorsRecursive != null && !this.sectorsRecursive.isEmpty();
    }

    @Override
    public BlkioStatsFluent.SectorsRecursiveNested<A> addNewSectorsRecursive() {
        return new SectorsRecursiveNestedImpl();
    }

    @Override
    public BlkioStatsFluent.SectorsRecursiveNested<A> addNewSectorsRecursiveLike(BlkioStatEntry item) {
        return new SectorsRecursiveNestedImpl(-1, item);
    }

    @Override
    public BlkioStatsFluent.SectorsRecursiveNested<A> setNewSectorsRecursiveLike(int index, BlkioStatEntry item) {
        return new SectorsRecursiveNestedImpl(index, item);
    }

    @Override
    public BlkioStatsFluent.SectorsRecursiveNested<A> editSectorsRecursive(int index) {
        if (this.sectorsRecursive.size() <= index) {
            throw new RuntimeException("Can't edit sectorsRecursive. Index exceeds size.");
        }
        return this.setNewSectorsRecursiveLike(index, this.buildSectorsRecursive(index));
    }

    @Override
    public BlkioStatsFluent.SectorsRecursiveNested<A> editFirstSectorsRecursive() {
        if (this.sectorsRecursive.size() == 0) {
            throw new RuntimeException("Can't edit first sectorsRecursive. The list is empty.");
        }
        return this.setNewSectorsRecursiveLike(0, this.buildSectorsRecursive(0));
    }

    @Override
    public BlkioStatsFluent.SectorsRecursiveNested<A> editLastSectorsRecursive() {
        int index = this.sectorsRecursive.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sectorsRecursive. The list is empty.");
        }
        return this.setNewSectorsRecursiveLike(index, this.buildSectorsRecursive(index));
    }

    @Override
    public BlkioStatsFluent.SectorsRecursiveNested<A> editMatchingSectorsRecursive(Predicate<BlkioStatEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sectorsRecursive.size(); ++i) {
            if (!predicate.apply(this.sectorsRecursive.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sectorsRecursive. No match found.");
        }
        return this.setNewSectorsRecursiveLike(index, this.buildSectorsRecursive(index));
    }

    @Override
    public A addNewSectorsRecursive(Long major, Long minor, String op, Long value) {
        return this.addToSectorsRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlkioStatsFluentImpl that = (BlkioStatsFluentImpl)o;
        if (this.ioMergedRecursive != null ? !this.ioMergedRecursive.equals(that.ioMergedRecursive) : that.ioMergedRecursive != null) {
            return false;
        }
        if (this.ioQueueRecursive != null ? !this.ioQueueRecursive.equals(that.ioQueueRecursive) : that.ioQueueRecursive != null) {
            return false;
        }
        if (this.ioServiceBytesRecursive != null ? !this.ioServiceBytesRecursive.equals(that.ioServiceBytesRecursive) : that.ioServiceBytesRecursive != null) {
            return false;
        }
        if (this.ioServiceTimeRecursive != null ? !this.ioServiceTimeRecursive.equals(that.ioServiceTimeRecursive) : that.ioServiceTimeRecursive != null) {
            return false;
        }
        if (this.ioServicedRecursive != null ? !this.ioServicedRecursive.equals(that.ioServicedRecursive) : that.ioServicedRecursive != null) {
            return false;
        }
        if (this.ioTimeRecursive != null ? !this.ioTimeRecursive.equals(that.ioTimeRecursive) : that.ioTimeRecursive != null) {
            return false;
        }
        if (this.ioWaitTimeRecursive != null ? !this.ioWaitTimeRecursive.equals(that.ioWaitTimeRecursive) : that.ioWaitTimeRecursive != null) {
            return false;
        }
        return !(this.sectorsRecursive != null ? !this.sectorsRecursive.equals(that.sectorsRecursive) : that.sectorsRecursive != null);
    }

    public class SectorsRecursiveNestedImpl<N>
    extends BlkioStatEntryFluentImpl<BlkioStatsFluent.SectorsRecursiveNested<N>>
    implements BlkioStatsFluent.SectorsRecursiveNested<N>,
    Nested<N> {
        private final BlkioStatEntryBuilder builder;
        private final int index;

        SectorsRecursiveNestedImpl(int index, BlkioStatEntry item) {
            this.index = index;
            this.builder = new BlkioStatEntryBuilder(this, item);
        }

        SectorsRecursiveNestedImpl() {
            this.index = -1;
            this.builder = new BlkioStatEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)BlkioStatsFluentImpl.this.setToSectorsRecursive(this.index, this.builder.build());
        }

        @Override
        public N endSectorsRecursive() {
            return this.and();
        }
    }

    public class IoWaitTimeRecursiveNestedImpl<N>
    extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoWaitTimeRecursiveNested<N>>
    implements BlkioStatsFluent.IoWaitTimeRecursiveNested<N>,
    Nested<N> {
        private final BlkioStatEntryBuilder builder;
        private final int index;

        IoWaitTimeRecursiveNestedImpl(int index, BlkioStatEntry item) {
            this.index = index;
            this.builder = new BlkioStatEntryBuilder(this, item);
        }

        IoWaitTimeRecursiveNestedImpl() {
            this.index = -1;
            this.builder = new BlkioStatEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)BlkioStatsFluentImpl.this.setToIoWaitTimeRecursive(this.index, this.builder.build());
        }

        @Override
        public N endIoWaitTimeRecursive() {
            return this.and();
        }
    }

    public class IoTimeRecursiveNestedImpl<N>
    extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoTimeRecursiveNested<N>>
    implements BlkioStatsFluent.IoTimeRecursiveNested<N>,
    Nested<N> {
        private final BlkioStatEntryBuilder builder;
        private final int index;

        IoTimeRecursiveNestedImpl(int index, BlkioStatEntry item) {
            this.index = index;
            this.builder = new BlkioStatEntryBuilder(this, item);
        }

        IoTimeRecursiveNestedImpl() {
            this.index = -1;
            this.builder = new BlkioStatEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)BlkioStatsFluentImpl.this.setToIoTimeRecursive(this.index, this.builder.build());
        }

        @Override
        public N endIoTimeRecursive() {
            return this.and();
        }
    }

    public class IoServicedRecursiveNestedImpl<N>
    extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoServicedRecursiveNested<N>>
    implements BlkioStatsFluent.IoServicedRecursiveNested<N>,
    Nested<N> {
        private final BlkioStatEntryBuilder builder;
        private final int index;

        IoServicedRecursiveNestedImpl(int index, BlkioStatEntry item) {
            this.index = index;
            this.builder = new BlkioStatEntryBuilder(this, item);
        }

        IoServicedRecursiveNestedImpl() {
            this.index = -1;
            this.builder = new BlkioStatEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)BlkioStatsFluentImpl.this.setToIoServicedRecursive(this.index, this.builder.build());
        }

        @Override
        public N endIoServicedRecursive() {
            return this.and();
        }
    }

    public class IoServiceTimeRecursiveNestedImpl<N>
    extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoServiceTimeRecursiveNested<N>>
    implements BlkioStatsFluent.IoServiceTimeRecursiveNested<N>,
    Nested<N> {
        private final BlkioStatEntryBuilder builder;
        private final int index;

        IoServiceTimeRecursiveNestedImpl(int index, BlkioStatEntry item) {
            this.index = index;
            this.builder = new BlkioStatEntryBuilder(this, item);
        }

        IoServiceTimeRecursiveNestedImpl() {
            this.index = -1;
            this.builder = new BlkioStatEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)BlkioStatsFluentImpl.this.setToIoServiceTimeRecursive(this.index, this.builder.build());
        }

        @Override
        public N endIoServiceTimeRecursive() {
            return this.and();
        }
    }

    public class IoServiceBytesRecursiveNestedImpl<N>
    extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoServiceBytesRecursiveNested<N>>
    implements BlkioStatsFluent.IoServiceBytesRecursiveNested<N>,
    Nested<N> {
        private final BlkioStatEntryBuilder builder;
        private final int index;

        IoServiceBytesRecursiveNestedImpl(int index, BlkioStatEntry item) {
            this.index = index;
            this.builder = new BlkioStatEntryBuilder(this, item);
        }

        IoServiceBytesRecursiveNestedImpl() {
            this.index = -1;
            this.builder = new BlkioStatEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)BlkioStatsFluentImpl.this.setToIoServiceBytesRecursive(this.index, this.builder.build());
        }

        @Override
        public N endIoServiceBytesRecursive() {
            return this.and();
        }
    }

    public class IoQueueRecursiveNestedImpl<N>
    extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoQueueRecursiveNested<N>>
    implements BlkioStatsFluent.IoQueueRecursiveNested<N>,
    Nested<N> {
        private final BlkioStatEntryBuilder builder;
        private final int index;

        IoQueueRecursiveNestedImpl(int index, BlkioStatEntry item) {
            this.index = index;
            this.builder = new BlkioStatEntryBuilder(this, item);
        }

        IoQueueRecursiveNestedImpl() {
            this.index = -1;
            this.builder = new BlkioStatEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)BlkioStatsFluentImpl.this.setToIoQueueRecursive(this.index, this.builder.build());
        }

        @Override
        public N endIoQueueRecursive() {
            return this.and();
        }
    }

    public class IoMergedRecursiveNestedImpl<N>
    extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoMergedRecursiveNested<N>>
    implements BlkioStatsFluent.IoMergedRecursiveNested<N>,
    Nested<N> {
        private final BlkioStatEntryBuilder builder;
        private final int index;

        IoMergedRecursiveNestedImpl(int index, BlkioStatEntry item) {
            this.index = index;
            this.builder = new BlkioStatEntryBuilder(this, item);
        }

        IoMergedRecursiveNestedImpl() {
            this.index = -1;
            this.builder = new BlkioStatEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)BlkioStatsFluentImpl.this.setToIoMergedRecursive(this.index, this.builder.build());
        }

        @Override
        public N endIoMergedRecursive() {
            return this.and();
        }
    }
}

