package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class VolumesListResponseFluentImpl<A extends VolumesListResponseFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements VolumesListResponseFluent<A>{

    private List<VolumeBuilder> Volumes =  new ArrayList<VolumeBuilder>();

    public VolumesListResponseFluentImpl(){
    }
    public VolumesListResponseFluentImpl(VolumesListResponse instance){
            this.withVolumes(instance.getVolumes()); 
    }

    public A addToVolumes(int index,Volume item){
            VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.Volumes.add(index >= 0 ? index : Volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,Volume item){
            VolumeBuilder builder = new VolumeBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= Volumes.size()) { Volumes.add(builder); } else { Volumes.set(index, builder);}
             return (A)this;
    }

    public A addToVolumes(Volume... items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(builder);this.Volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(builder);this.Volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(Volume... items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.remove(builder);this.Volumes.remove(builder);} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.remove(builder);this.Volumes.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 */
@Deprecated public List<Volume> getVolumes(){
            return build(Volumes);
    }

    public List<Volume> buildVolumes(){
            return build(Volumes);
    }

    public Volume buildVolume(int index){
            return this.Volumes.get(index).build();
    }

    public Volume buildFirstVolume(){
            return this.Volumes.get(0).build();
    }

    public Volume buildLastVolume(){
            return this.Volumes.get(Volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(io.fabric8.docker.api.builder.Predicate<VolumeBuilder> predicate){
            for (VolumeBuilder item: Volumes) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withVolumes(List<Volume> Volumes){
            _visitables.removeAll(this.Volumes);
            this.Volumes.clear();
            if (Volumes != null) {for (Volume item : Volumes){this.addToVolumes(item);}} return (A) this;
    }

    public A withVolumes(Volume... Volumes){
            this.Volumes.clear(); if (Volumes != null) {for (Volume item :Volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes(){
            return Volumes!= null && !Volumes.isEmpty();
    }

    public VolumesListResponseFluent.VolumesNested<A> addNewVolume(){
            return new VolumesNestedImpl();
    }

    public VolumesListResponseFluent.VolumesNested<A> addNewVolumeLike(Volume item){
            return new VolumesNestedImpl(-1, item);
    }

    public VolumesListResponseFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item){
            return new VolumesNestedImpl(index, item);
    }

    public VolumesListResponseFluent.VolumesNested<A> editVolume(int index){
            if (Volumes.size() <= index) throw new RuntimeException("Can't edit Volumes. Index exceeds size.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public VolumesListResponseFluent.VolumesNested<A> editFirstVolume(){
            if (Volumes.size() == 0) throw new RuntimeException("Can't edit first Volumes. The list is empty.");
            return setNewVolumeLike(0, buildVolume(0));
    }

    public VolumesListResponseFluent.VolumesNested<A> editLastVolume(){
            int index = Volumes.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last Volumes. The list is empty.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public VolumesListResponseFluent.VolumesNested<A> editMatchingVolume(io.fabric8.docker.api.builder.Predicate<VolumeBuilder> predicate){
            int index = -1;
            for (int i=0;i<Volumes.size();i++) { 
            if (predicate.apply(Volumes.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching Volumes. No match found.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public A addNewVolume(String Driver,String Mountpoint,String Name){
            return (A)addToVolumes(new Volume(Driver, Mountpoint, Name));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumesListResponseFluentImpl that = (VolumesListResponseFluentImpl) o;
            if (Volumes != null ? !Volumes.equals(that.Volumes) :that.Volumes != null) return false;
            return true;
    }


    public class VolumesNestedImpl<N> extends VolumeFluentImpl<VolumesListResponseFluent.VolumesNested<N>> implements VolumesListResponseFluent.VolumesNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final VolumeBuilder builder;
        private final int index;
    
            VolumesNestedImpl(int index,Volume item){
                    this.index = index;
                    this.builder = new VolumeBuilder(this, item);
            }
            VolumesNestedImpl(){
                    this.index = -1;
                    this.builder = new VolumeBuilder(this);
            }
    
    public N and(){
            return (N) VolumesListResponseFluentImpl.this.setToVolumes(index, builder.build());
    }
    public N endVolume(){
            return and();
    }

}


}
