package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class VolumeCreateRequestFluentImpl<A extends VolumeCreateRequestFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements VolumeCreateRequestFluent<A>{

    private String Driver;
    private Map<String,String> DriverOpts = new LinkedHashMap<String,String>();
    private String Name;

    public VolumeCreateRequestFluentImpl(){
    }
    public VolumeCreateRequestFluentImpl(VolumeCreateRequest instance){
            this.withDriver(instance.getDriver()); 
            this.withDriverOpts(instance.getDriverOpts()); 
            this.withName(instance.getName()); 
    }

    public String getDriver(){
            return this.Driver;
    }

    public A withDriver(String Driver){
            this.Driver=Driver; return (A) this;
    }

    public Boolean hasDriver(){
            return this.Driver!=null;
    }

    public A addToDriverOpts(String key,String value){
            if(key != null && value != null) {this.DriverOpts.put(key, value);} return (A)this;
    }

    public A addToDriverOpts(Map<String,String> map){
            if(map != null) { this.DriverOpts.putAll(map);} return (A)this;
    }

    public A removeFromDriverOpts(String key){
            if(key != null) {this.DriverOpts.remove(key);} return (A)this;
    }

    public A removeFromDriverOpts(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.DriverOpts.remove(key);}} return (A)this;
    }

    public Map<String,String> getDriverOpts(){
            return this.DriverOpts;
    }

    public A withDriverOpts(Map<String,String> DriverOpts){
            this.DriverOpts.clear();
            if (DriverOpts != null) {this.DriverOpts.putAll(DriverOpts);} return (A) this;
    }

    public Boolean hasDriverOpts(){
            return this.DriverOpts!=null;
    }

    public String getName(){
            return this.Name;
    }

    public A withName(String Name){
            this.Name=Name; return (A) this;
    }

    public Boolean hasName(){
            return this.Name!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumeCreateRequestFluentImpl that = (VolumeCreateRequestFluentImpl) o;
            if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
            if (DriverOpts != null ? !DriverOpts.equals(that.DriverOpts) :that.DriverOpts != null) return false;
            if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
            return true;
    }




}
