package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeCreateRequestBuilder extends VolumeCreateRequestFluentImpl<VolumeCreateRequestBuilder> implements VisitableBuilder<VolumeCreateRequest,VolumeCreateRequestBuilder>{

    VolumeCreateRequestFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeCreateRequestBuilder(){
            this(true);
    }
    public VolumeCreateRequestBuilder(Boolean validationEnabled){
            this(new VolumeCreateRequest(), validationEnabled);
    }
    public VolumeCreateRequestBuilder(VolumeCreateRequestFluent<?> fluent){
            this(fluent, true);
    }
    public VolumeCreateRequestBuilder(VolumeCreateRequestFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VolumeCreateRequest(), validationEnabled);
    }
    public VolumeCreateRequestBuilder(VolumeCreateRequestFluent<?> fluent,VolumeCreateRequest instance){
            this(fluent, instance, true);
    }
    public VolumeCreateRequestBuilder(VolumeCreateRequestFluent<?> fluent,VolumeCreateRequest instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDriver(instance.getDriver()); 
            fluent.withDriverOpts(instance.getDriverOpts()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public VolumeCreateRequestBuilder(VolumeCreateRequest instance){
            this(instance,true);
    }
    public VolumeCreateRequestBuilder(VolumeCreateRequest instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDriver(instance.getDriver()); 
            this.withDriverOpts(instance.getDriverOpts()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableVolumeCreateRequest build(){
            EditableVolumeCreateRequest buildable = new EditableVolumeCreateRequest(fluent.getDriver(),fluent.getDriverOpts(),fluent.getName());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumeCreateRequestBuilder that = (VolumeCreateRequestBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
