package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VersionBuilder extends VersionFluentImpl<VersionBuilder> implements VisitableBuilder<io.fabric8.docker.api.model.Version,VersionBuilder>{

    VersionFluent<?> fluent;
    Boolean validationEnabled;

    public VersionBuilder(){
            this(true);
    }
    public VersionBuilder(Boolean validationEnabled){
            this(new Version(), validationEnabled);
    }
    public VersionBuilder(VersionFluent<?> fluent){
            this(fluent, true);
    }
    public VersionBuilder(VersionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Version(), validationEnabled);
    }
    public VersionBuilder(VersionFluent<?> fluent,io.fabric8.docker.api.model.Version instance){
            this(fluent, instance, true);
    }
    public VersionBuilder(VersionFluent<?> fluent,io.fabric8.docker.api.model.Version instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withArch(instance.getArch()); 
            fluent.withBuildTime(instance.getBuildTime()); 
            fluent.withExperimental(instance.getExperimental()); 
            fluent.withGitCommit(instance.getGitCommit()); 
            fluent.withGoVersion(instance.getGoVersion()); 
            fluent.withKernelVersion(instance.getKernelVersion()); 
            fluent.withOs(instance.getOs()); 
            fluent.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public VersionBuilder(io.fabric8.docker.api.model.Version instance){
            this(instance,true);
    }
    public VersionBuilder(io.fabric8.docker.api.model.Version instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withArch(instance.getArch()); 
            this.withBuildTime(instance.getBuildTime()); 
            this.withExperimental(instance.getExperimental()); 
            this.withGitCommit(instance.getGitCommit()); 
            this.withGoVersion(instance.getGoVersion()); 
            this.withKernelVersion(instance.getKernelVersion()); 
            this.withOs(instance.getOs()); 
            this.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableVersion build(){
            EditableVersion buildable = new EditableVersion(fluent.getApiVersion(),fluent.getArch(),fluent.getBuildTime(),fluent.isExperimental(),fluent.getGitCommit(),fluent.getGoVersion(),fluent.getKernelVersion(),fluent.getOs(),fluent.getVersion());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VersionBuilder that = (VersionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
