package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class ServiceConfigFluentImpl<A extends ServiceConfigFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ServiceConfigFluent<A>{

    private Map<String,IndexInfo> IndexConfigs = new LinkedHashMap<String,IndexInfo>();
    private List<NetIPNetBuilder> InsecureRegistryCIDRs =  new ArrayList<NetIPNetBuilder>();
    private List<String> Mirrors = new ArrayList<String>();

    public ServiceConfigFluentImpl(){
    }
    public ServiceConfigFluentImpl(ServiceConfig instance){
            this.withIndexConfigs(instance.getIndexConfigs()); 
            this.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs()); 
            this.withMirrors(instance.getMirrors()); 
    }

    public A addToIndexConfigs(String key,IndexInfo value){
            if(key != null && value != null) {this.IndexConfigs.put(key, value);} return (A)this;
    }

    public A addToIndexConfigs(Map<String,IndexInfo> map){
            if(map != null) { this.IndexConfigs.putAll(map);} return (A)this;
    }

    public A removeFromIndexConfigs(String key){
            if(key != null) {this.IndexConfigs.remove(key);} return (A)this;
    }

    public A removeFromIndexConfigs(Map<String,IndexInfo> map){
            if(map != null) { for(Object key : map.keySet()) {this.IndexConfigs.remove(key);}} return (A)this;
    }

    public Map<String,IndexInfo> getIndexConfigs(){
            return this.IndexConfigs;
    }

    public A withIndexConfigs(Map<String,IndexInfo> IndexConfigs){
            this.IndexConfigs.clear();
            if (IndexConfigs != null) {this.IndexConfigs.putAll(IndexConfigs);} return (A) this;
    }

    public Boolean hasIndexConfigs(){
            return this.IndexConfigs!=null;
    }

    public A addToInsecureRegistryCIDRs(int index,NetIPNet item){
            NetIPNetBuilder builder = new NetIPNetBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.InsecureRegistryCIDRs.add(index >= 0 ? index : InsecureRegistryCIDRs.size(), builder); return (A)this;
    }

    public A setToInsecureRegistryCIDRs(int index,NetIPNet item){
            NetIPNetBuilder builder = new NetIPNetBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= InsecureRegistryCIDRs.size()) { InsecureRegistryCIDRs.add(builder); } else { InsecureRegistryCIDRs.set(index, builder);}
             return (A)this;
    }

    public A addToInsecureRegistryCIDRs(NetIPNet... items){
            for (NetIPNet item : items) {NetIPNetBuilder builder = new NetIPNetBuilder(item);_visitables.add(builder);this.InsecureRegistryCIDRs.add(builder);} return (A)this;
    }

    public A addAllToInsecureRegistryCIDRs(Collection<NetIPNet> items){
            for (NetIPNet item : items) {NetIPNetBuilder builder = new NetIPNetBuilder(item);_visitables.add(builder);this.InsecureRegistryCIDRs.add(builder);} return (A)this;
    }

    public A removeFromInsecureRegistryCIDRs(NetIPNet... items){
            for (NetIPNet item : items) {NetIPNetBuilder builder = new NetIPNetBuilder(item);_visitables.remove(builder);this.InsecureRegistryCIDRs.remove(builder);} return (A)this;
    }

    public A removeAllFromInsecureRegistryCIDRs(Collection<NetIPNet> items){
            for (NetIPNet item : items) {NetIPNetBuilder builder = new NetIPNetBuilder(item);_visitables.remove(builder);this.InsecureRegistryCIDRs.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildInsecureRegistryCIDRs instead.
 */
@Deprecated public List<NetIPNet> getInsecureRegistryCIDRs(){
            return build(InsecureRegistryCIDRs);
    }

    public List<NetIPNet> buildInsecureRegistryCIDRs(){
            return build(InsecureRegistryCIDRs);
    }

    public NetIPNet buildInsecureRegistryCIDR(int index){
            return this.InsecureRegistryCIDRs.get(index).build();
    }

    public NetIPNet buildFirstInsecureRegistryCIDR(){
            return this.InsecureRegistryCIDRs.get(0).build();
    }

    public NetIPNet buildLastInsecureRegistryCIDR(){
            return this.InsecureRegistryCIDRs.get(InsecureRegistryCIDRs.size() - 1).build();
    }

    public NetIPNet buildMatchingInsecureRegistryCIDR(io.fabric8.docker.api.builder.Predicate<NetIPNetBuilder> predicate){
            for (NetIPNetBuilder item: InsecureRegistryCIDRs) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withInsecureRegistryCIDRs(List<NetIPNet> InsecureRegistryCIDRs){
            _visitables.removeAll(this.InsecureRegistryCIDRs);
            this.InsecureRegistryCIDRs.clear();
            if (InsecureRegistryCIDRs != null) {for (NetIPNet item : InsecureRegistryCIDRs){this.addToInsecureRegistryCIDRs(item);}} return (A) this;
    }

    public A withInsecureRegistryCIDRs(NetIPNet... InsecureRegistryCIDRs){
            this.InsecureRegistryCIDRs.clear(); if (InsecureRegistryCIDRs != null) {for (NetIPNet item :InsecureRegistryCIDRs){ this.addToInsecureRegistryCIDRs(item);}} return (A) this;
    }

    public Boolean hasInsecureRegistryCIDRs(){
            return InsecureRegistryCIDRs!= null && !InsecureRegistryCIDRs.isEmpty();
    }

    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDR(){
            return new InsecureRegistryCIDRsNestedImpl();
    }

    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDRLike(NetIPNet item){
            return new InsecureRegistryCIDRsNestedImpl(-1, item);
    }

    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> setNewInsecureRegistryCIDRLike(int index,NetIPNet item){
            return new InsecureRegistryCIDRsNestedImpl(index, item);
    }

    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editInsecureRegistryCIDR(int index){
            if (InsecureRegistryCIDRs.size() <= index) throw new RuntimeException("Can't edit InsecureRegistryCIDRs. Index exceeds size.");
            return setNewInsecureRegistryCIDRLike(index, buildInsecureRegistryCIDR(index));
    }

    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editFirstInsecureRegistryCIDR(){
            if (InsecureRegistryCIDRs.size() == 0) throw new RuntimeException("Can't edit first InsecureRegistryCIDRs. The list is empty.");
            return setNewInsecureRegistryCIDRLike(0, buildInsecureRegistryCIDR(0));
    }

    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editLastInsecureRegistryCIDR(){
            int index = InsecureRegistryCIDRs.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last InsecureRegistryCIDRs. The list is empty.");
            return setNewInsecureRegistryCIDRLike(index, buildInsecureRegistryCIDR(index));
    }

    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editMatchingInsecureRegistryCIDR(io.fabric8.docker.api.builder.Predicate<NetIPNetBuilder> predicate){
            int index = -1;
            for (int i=0;i<InsecureRegistryCIDRs.size();i++) { 
            if (predicate.apply(InsecureRegistryCIDRs.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching InsecureRegistryCIDRs. No match found.");
            return setNewInsecureRegistryCIDRLike(index, buildInsecureRegistryCIDR(index));
    }

    public A addNewInsecureRegistryCIDR(String ip,String mask){
            return (A)addToInsecureRegistryCIDRs(new NetIPNet(ip, mask));
    }

    public A addNewInsecureRegistryCIDR(String s){
            return (A)addToInsecureRegistryCIDRs(new NetIPNet(s));
    }

    public A addToMirrors(int index,String item){
            this.Mirrors.add(index, item); return (A)this;
    }

    public A setToMirrors(int index,String item){
            this.Mirrors.set(index, item); return (A)this;
    }

    public A addToMirrors(String... items){
            for (String item : items) {this.Mirrors.add(item);} return (A)this;
    }

    public A addAllToMirrors(Collection<String> items){
            for (String item : items) {this.Mirrors.add(item);} return (A)this;
    }

    public A removeFromMirrors(String... items){
            for (String item : items) {this.Mirrors.remove(item);} return (A)this;
    }

    public A removeAllFromMirrors(Collection<String> items){
            for (String item : items) {this.Mirrors.remove(item);} return (A)this;
    }

    public List<String> getMirrors(){
            return this.Mirrors;
    }

    public String getMirror(int index){
            return this.Mirrors.get(index);
    }

    public String getFirstMirror(){
            return this.Mirrors.get(0);
    }

    public String getLastMirror(){
            return this.Mirrors.get(Mirrors.size() - 1);
    }

    public String getMatchingMirror(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Mirrors) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withMirrors(List<String> Mirrors){
            this.Mirrors.clear();
            if (Mirrors != null) {for (String item : Mirrors){this.addToMirrors(item);}} return (A) this;
    }

    public A withMirrors(String... Mirrors){
            this.Mirrors.clear(); if (Mirrors != null) {for (String item :Mirrors){ this.addToMirrors(item);}} return (A) this;
    }

    public Boolean hasMirrors(){
            return Mirrors!= null && !Mirrors.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceConfigFluentImpl that = (ServiceConfigFluentImpl) o;
            if (IndexConfigs != null ? !IndexConfigs.equals(that.IndexConfigs) :that.IndexConfigs != null) return false;
            if (InsecureRegistryCIDRs != null ? !InsecureRegistryCIDRs.equals(that.InsecureRegistryCIDRs) :that.InsecureRegistryCIDRs != null) return false;
            if (Mirrors != null ? !Mirrors.equals(that.Mirrors) :that.Mirrors != null) return false;
            return true;
    }


    public class InsecureRegistryCIDRsNestedImpl<N> extends NetIPNetFluentImpl<ServiceConfigFluent.InsecureRegistryCIDRsNested<N>> implements ServiceConfigFluent.InsecureRegistryCIDRsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetIPNetBuilder builder;
        private final int index;
    
            InsecureRegistryCIDRsNestedImpl(int index,NetIPNet item){
                    this.index = index;
                    this.builder = new NetIPNetBuilder(this, item);
            }
            InsecureRegistryCIDRsNestedImpl(){
                    this.index = -1;
                    this.builder = new NetIPNetBuilder(this);
            }
    
    public N and(){
            return (N) ServiceConfigFluentImpl.this.setToInsecureRegistryCIDRs(index, builder.build());
    }
    public N endInsecureRegistryCIDR(){
            return and();
    }

}


}
