package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ServiceConfigFluent<A extends ServiceConfigFluent<A>> extends Fluent<A>{


    public A addToIndexConfigs(String key,IndexInfo value);
    public A addToIndexConfigs(Map<String,IndexInfo> map);
    public A removeFromIndexConfigs(String key);
    public A removeFromIndexConfigs(Map<String,IndexInfo> map);
    public Map<String,IndexInfo> getIndexConfigs();
    public A withIndexConfigs(Map<String,IndexInfo> IndexConfigs);
    public Boolean hasIndexConfigs();
    public A addToInsecureRegistryCIDRs(int index,NetIPNet item);
    public A setToInsecureRegistryCIDRs(int index,NetIPNet item);
    public A addToInsecureRegistryCIDRs(NetIPNet... items);
    public A addAllToInsecureRegistryCIDRs(Collection<NetIPNet> items);
    public A removeFromInsecureRegistryCIDRs(NetIPNet... items);
    public A removeAllFromInsecureRegistryCIDRs(Collection<NetIPNet> items);
    
/**
 * This method has been deprecated, please use method buildInsecureRegistryCIDRs instead.
 */
@Deprecated public List<NetIPNet> getInsecureRegistryCIDRs();
    public List<NetIPNet> buildInsecureRegistryCIDRs();
    public NetIPNet buildInsecureRegistryCIDR(int index);
    public NetIPNet buildFirstInsecureRegistryCIDR();
    public NetIPNet buildLastInsecureRegistryCIDR();
    public NetIPNet buildMatchingInsecureRegistryCIDR(io.fabric8.docker.api.builder.Predicate<NetIPNetBuilder> predicate);
    public A withInsecureRegistryCIDRs(List<NetIPNet> InsecureRegistryCIDRs);
    public A withInsecureRegistryCIDRs(NetIPNet... InsecureRegistryCIDRs);
    public Boolean hasInsecureRegistryCIDRs();
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDR();
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDRLike(NetIPNet item);
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> setNewInsecureRegistryCIDRLike(int index,NetIPNet item);
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editInsecureRegistryCIDR(int index);
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editFirstInsecureRegistryCIDR();
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editLastInsecureRegistryCIDR();
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editMatchingInsecureRegistryCIDR(io.fabric8.docker.api.builder.Predicate<NetIPNetBuilder> predicate);
    public A addNewInsecureRegistryCIDR(String ip,String mask);
    public A addNewInsecureRegistryCIDR(String s);
    public A addToMirrors(int index,String item);
    public A setToMirrors(int index,String item);
    public A addToMirrors(String... items);
    public A addAllToMirrors(Collection<String> items);
    public A removeFromMirrors(String... items);
    public A removeAllFromMirrors(Collection<String> items);
    public List<String> getMirrors();
    public String getMirror(int index);
    public String getFirstMirror();
    public String getLastMirror();
    public String getMatchingMirror(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withMirrors(List<String> Mirrors);
    public A withMirrors(String... Mirrors);
    public Boolean hasMirrors();

    public interface InsecureRegistryCIDRsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetIPNetFluent<ServiceConfigFluent.InsecureRegistryCIDRsNested<N>>{

        
    public N and();    public N endInsecureRegistryCIDR();
}


}
