package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SearchResultsFluentImpl<A extends SearchResultsFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements SearchResultsFluent<A>{

    private Integer numResults;
    private String query;
    private List<SearchResultBuilder> results =  new ArrayList<SearchResultBuilder>();

    public SearchResultsFluentImpl(){
    }
    public SearchResultsFluentImpl(SearchResults instance){
            this.withNumResults(instance.getNumResults()); 
            this.withQuery(instance.getQuery()); 
            this.withResults(instance.getResults()); 
    }

    public Integer getNumResults(){
            return this.numResults;
    }

    public A withNumResults(Integer numResults){
            this.numResults=numResults; return (A) this;
    }

    public Boolean hasNumResults(){
            return this.numResults!=null;
    }

    public String getQuery(){
            return this.query;
    }

    public A withQuery(String query){
            this.query=query; return (A) this;
    }

    public Boolean hasQuery(){
            return this.query!=null;
    }

    public A addToResults(int index,SearchResult item){
            SearchResultBuilder builder = new SearchResultBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.results.add(index >= 0 ? index : results.size(), builder); return (A)this;
    }

    public A setToResults(int index,SearchResult item){
            SearchResultBuilder builder = new SearchResultBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= results.size()) { results.add(builder); } else { results.set(index, builder);}
             return (A)this;
    }

    public A addToResults(SearchResult... items){
            for (SearchResult item : items) {SearchResultBuilder builder = new SearchResultBuilder(item);_visitables.add(builder);this.results.add(builder);} return (A)this;
    }

    public A addAllToResults(Collection<SearchResult> items){
            for (SearchResult item : items) {SearchResultBuilder builder = new SearchResultBuilder(item);_visitables.add(builder);this.results.add(builder);} return (A)this;
    }

    public A removeFromResults(SearchResult... items){
            for (SearchResult item : items) {SearchResultBuilder builder = new SearchResultBuilder(item);_visitables.remove(builder);this.results.remove(builder);} return (A)this;
    }

    public A removeAllFromResults(Collection<SearchResult> items){
            for (SearchResult item : items) {SearchResultBuilder builder = new SearchResultBuilder(item);_visitables.remove(builder);this.results.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResults instead.
 */
@Deprecated public List<SearchResult> getResults(){
            return build(results);
    }

    public List<SearchResult> buildResults(){
            return build(results);
    }

    public SearchResult buildResult(int index){
            return this.results.get(index).build();
    }

    public SearchResult buildFirstResult(){
            return this.results.get(0).build();
    }

    public SearchResult buildLastResult(){
            return this.results.get(results.size() - 1).build();
    }

    public SearchResult buildMatchingResult(io.fabric8.docker.api.builder.Predicate<SearchResultBuilder> predicate){
            for (SearchResultBuilder item: results) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withResults(List<SearchResult> results){
            _visitables.removeAll(this.results);
            this.results.clear();
            if (results != null) {for (SearchResult item : results){this.addToResults(item);}} return (A) this;
    }

    public A withResults(SearchResult... results){
            this.results.clear(); if (results != null) {for (SearchResult item :results){ this.addToResults(item);}} return (A) this;
    }

    public Boolean hasResults(){
            return results!= null && !results.isEmpty();
    }

    public SearchResultsFluent.ResultsNested<A> addNewResult(){
            return new ResultsNestedImpl();
    }

    public SearchResultsFluent.ResultsNested<A> addNewResultLike(SearchResult item){
            return new ResultsNestedImpl(-1, item);
    }

    public SearchResultsFluent.ResultsNested<A> setNewResultLike(int index,SearchResult item){
            return new ResultsNestedImpl(index, item);
    }

    public SearchResultsFluent.ResultsNested<A> editResult(int index){
            if (results.size() <= index) throw new RuntimeException("Can't edit results. Index exceeds size.");
            return setNewResultLike(index, buildResult(index));
    }

    public SearchResultsFluent.ResultsNested<A> editFirstResult(){
            if (results.size() == 0) throw new RuntimeException("Can't edit first results. The list is empty.");
            return setNewResultLike(0, buildResult(0));
    }

    public SearchResultsFluent.ResultsNested<A> editLastResult(){
            int index = results.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last results. The list is empty.");
            return setNewResultLike(index, buildResult(index));
    }

    public SearchResultsFluent.ResultsNested<A> editMatchingResult(io.fabric8.docker.api.builder.Predicate<SearchResultBuilder> predicate){
            int index = -1;
            for (int i=0;i<results.size();i++) { 
            if (predicate.apply(results.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching results. No match found.");
            return setNewResultLike(index, buildResult(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SearchResultsFluentImpl that = (SearchResultsFluentImpl) o;
            if (numResults != null ? !numResults.equals(that.numResults) :that.numResults != null) return false;
            if (query != null ? !query.equals(that.query) :that.query != null) return false;
            if (results != null ? !results.equals(that.results) :that.results != null) return false;
            return true;
    }


    public class ResultsNestedImpl<N> extends SearchResultFluentImpl<SearchResultsFluent.ResultsNested<N>> implements SearchResultsFluent.ResultsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final SearchResultBuilder builder;
        private final int index;
    
            ResultsNestedImpl(int index,SearchResult item){
                    this.index = index;
                    this.builder = new SearchResultBuilder(this, item);
            }
            ResultsNestedImpl(){
                    this.index = -1;
                    this.builder = new SearchResultBuilder(this);
            }
    
    public N and(){
            return (N) SearchResultsFluentImpl.this.setToResults(index, builder.build());
    }
    public N endResult(){
            return and();
    }

}


}
