package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface NetworkSettingsFluent<A extends NetworkSettingsFluent<A>> extends Fluent<A>{


    public String getEndpointID();
    public A withEndpointID(String EndpointID);
    public Boolean hasEndpointID();
    public String getGateway();
    public A withGateway(String Gateway);
    public Boolean hasGateway();
    public String getGlobalIPv6Address();
    public A withGlobalIPv6Address(String GlobalIPv6Address);
    public Boolean hasGlobalIPv6Address();
    public Integer getGlobalIPv6PrefixLen();
    public A withGlobalIPv6PrefixLen(Integer GlobalIPv6PrefixLen);
    public Boolean hasGlobalIPv6PrefixLen();
    public String getIPAddress();
    public A withIPAddress(String IPAddress);
    public Boolean hasIPAddress();
    public Integer getIPPrefixLen();
    public A withIPPrefixLen(Integer IPPrefixLen);
    public Boolean hasIPPrefixLen();
    public String getIPv6Gateway();
    public A withIPv6Gateway(String IPv6Gateway);
    public Boolean hasIPv6Gateway();
    public String getMacAddress();
    public A withMacAddress(String MacAddress);
    public Boolean hasMacAddress();
    public String getBridge();
    public A withBridge(String Bridge);
    public Boolean hasBridge();
    public String getSandboxID();
    public A withSandboxID(String SandboxID);
    public Boolean hasSandboxID();
    public Boolean isHairpinMode();
    public A withHairpinMode(Boolean HairpinMode);
    public Boolean hasHairpinMode();
    public String getLinkLocalIPv6Address();
    public A withLinkLocalIPv6Address(String LinkLocalIPv6Address);
    public Boolean hasLinkLocalIPv6Address();
    public Integer getLinkLocalIPv6PrefixLen();
    public A withLinkLocalIPv6PrefixLen(Integer LinkLocalIPv6PrefixLen);
    public Boolean hasLinkLocalIPv6PrefixLen();
    public A addToPorts(String key,ArrayList<PortBinding> value);
    public A addToPorts(Map<String,ArrayList<PortBinding>> map);
    public A removeFromPorts(String key);
    public A removeFromPorts(Map<String,ArrayList<PortBinding>> map);
    public Map<String,ArrayList<PortBinding>> getPorts();
    public A withPorts(Map<String,ArrayList<PortBinding>> Ports);
    public Boolean hasPorts();
    public String getSandboxKey();
    public A withSandboxKey(String SandboxKey);
    public Boolean hasSandboxKey();
    public A addToSecondaryIPAddresses(int index,Address item);
    public A setToSecondaryIPAddresses(int index,Address item);
    public A addToSecondaryIPAddresses(Address... items);
    public A addAllToSecondaryIPAddresses(Collection<Address> items);
    public A removeFromSecondaryIPAddresses(Address... items);
    public A removeAllFromSecondaryIPAddresses(Collection<Address> items);
    
/**
 * This method has been deprecated, please use method buildSecondaryIPAddresses instead.
 */
@Deprecated public List<Address> getSecondaryIPAddresses();
    public List<Address> buildSecondaryIPAddresses();
    public Address buildSecondaryIPAddress(int index);
    public Address buildFirstSecondaryIPAddress();
    public Address buildLastSecondaryIPAddress();
    public Address buildMatchingSecondaryIPAddress(io.fabric8.docker.api.builder.Predicate<AddressBuilder> predicate);
    public A withSecondaryIPAddresses(List<Address> SecondaryIPAddresses);
    public A withSecondaryIPAddresses(Address... SecondaryIPAddresses);
    public Boolean hasSecondaryIPAddresses();
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddress();
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddressLike(Address item);
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> setNewSecondaryIPAddressLike(int index,Address item);
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> editSecondaryIPAddress(int index);
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> editFirstSecondaryIPAddress();
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> editLastSecondaryIPAddress();
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> editMatchingSecondaryIPAddress(io.fabric8.docker.api.builder.Predicate<AddressBuilder> predicate);
    public A addNewSecondaryIPAddress(String Addr,Integer PrefixLen);
    public A addToSecondaryIPv6Addresses(int index,Address item);
    public A setToSecondaryIPv6Addresses(int index,Address item);
    public A addToSecondaryIPv6Addresses(Address... items);
    public A addAllToSecondaryIPv6Addresses(Collection<Address> items);
    public A removeFromSecondaryIPv6Addresses(Address... items);
    public A removeAllFromSecondaryIPv6Addresses(Collection<Address> items);
    
/**
 * This method has been deprecated, please use method buildSecondaryIPv6Addresses instead.
 */
@Deprecated public List<Address> getSecondaryIPv6Addresses();
    public List<Address> buildSecondaryIPv6Addresses();
    public Address buildSecondaryIPv6Address(int index);
    public Address buildFirstSecondaryIPv6Address();
    public Address buildLastSecondaryIPv6Address();
    public Address buildMatchingSecondaryIPv6Address(io.fabric8.docker.api.builder.Predicate<AddressBuilder> predicate);
    public A withSecondaryIPv6Addresses(List<Address> SecondaryIPv6Addresses);
    public A withSecondaryIPv6Addresses(Address... SecondaryIPv6Addresses);
    public Boolean hasSecondaryIPv6Addresses();
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6Address();
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6AddressLike(Address item);
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> setNewSecondaryIPv6AddressLike(int index,Address item);
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> editSecondaryIPv6Address(int index);
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> editFirstSecondaryIPv6Address();
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> editLastSecondaryIPv6Address();
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> editMatchingSecondaryIPv6Address(io.fabric8.docker.api.builder.Predicate<AddressBuilder> predicate);
    public A addNewSecondaryIPv6Address(String Addr,Integer PrefixLen);
    public A addToNetworks(String key,EndpointSettings value);
    public A addToNetworks(Map<String,EndpointSettings> map);
    public A removeFromNetworks(String key);
    public A removeFromNetworks(Map<String,EndpointSettings> map);
    public Map<String,EndpointSettings> getNetworks();
    public A withNetworks(Map<String,EndpointSettings> Networks);
    public Boolean hasNetworks();

    public interface SecondaryIPAddressesNested<N> extends io.fabric8.docker.api.builder.Nested<N>,AddressFluent<NetworkSettingsFluent.SecondaryIPAddressesNested<N>>{

        
    public N and();    public N endSecondaryIPAddress();
}
    public interface SecondaryIPv6AddressesNested<N> extends io.fabric8.docker.api.builder.Nested<N>,AddressFluent<NetworkSettingsFluent.SecondaryIPv6AddressesNested<N>>{

        
    public N and();    public N endSecondaryIPv6Address();
}


}
