package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkSettingsBuilder extends NetworkSettingsFluentImpl<NetworkSettingsBuilder> implements VisitableBuilder<NetworkSettings,NetworkSettingsBuilder>{

    NetworkSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSettingsBuilder(){
            this(true);
    }
    public NetworkSettingsBuilder(Boolean validationEnabled){
            this(new NetworkSettings(), validationEnabled);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkSettings(), validationEnabled);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent,NetworkSettings instance){
            this(fluent, instance, true);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent,NetworkSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEndpointID(instance.getEndpointID()); 
            fluent.withGateway(instance.getGateway()); 
            fluent.withGlobalIPv6Address(instance.getGlobalIPv6Address()); 
            fluent.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); 
            fluent.withIPAddress(instance.getIPAddress()); 
            fluent.withIPPrefixLen(instance.getIPPrefixLen()); 
            fluent.withIPv6Gateway(instance.getIPv6Gateway()); 
            fluent.withMacAddress(instance.getMacAddress()); 
            fluent.withBridge(instance.getBridge()); 
            fluent.withSandboxID(instance.getSandboxID()); 
            fluent.withHairpinMode(instance.getHairpinMode()); 
            fluent.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address()); 
            fluent.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen()); 
            fluent.withPorts(instance.getPorts()); 
            fluent.withSandboxKey(instance.getSandboxKey()); 
            fluent.withSecondaryIPAddresses(instance.getSecondaryIPAddresses()); 
            fluent.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses()); 
            fluent.withNetworks(instance.getNetworks()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkSettingsBuilder(NetworkSettings instance){
            this(instance,true);
    }
    public NetworkSettingsBuilder(NetworkSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEndpointID(instance.getEndpointID()); 
            this.withGateway(instance.getGateway()); 
            this.withGlobalIPv6Address(instance.getGlobalIPv6Address()); 
            this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); 
            this.withIPAddress(instance.getIPAddress()); 
            this.withIPPrefixLen(instance.getIPPrefixLen()); 
            this.withIPv6Gateway(instance.getIPv6Gateway()); 
            this.withMacAddress(instance.getMacAddress()); 
            this.withBridge(instance.getBridge()); 
            this.withSandboxID(instance.getSandboxID()); 
            this.withHairpinMode(instance.getHairpinMode()); 
            this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address()); 
            this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen()); 
            this.withPorts(instance.getPorts()); 
            this.withSandboxKey(instance.getSandboxKey()); 
            this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses()); 
            this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses()); 
            this.withNetworks(instance.getNetworks()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkSettings build(){
            EditableNetworkSettings buildable = new EditableNetworkSettings(fluent.getEndpointID(),fluent.getGateway(),fluent.getGlobalIPv6Address(),fluent.getGlobalIPv6PrefixLen(),fluent.getIPAddress(),fluent.getIPPrefixLen(),fluent.getIPv6Gateway(),fluent.getMacAddress(),fluent.getBridge(),fluent.getSandboxID(),fluent.isHairpinMode(),fluent.getLinkLocalIPv6Address(),fluent.getLinkLocalIPv6PrefixLen(),fluent.getPorts(),fluent.getSandboxKey(),fluent.getSecondaryIPAddresses(),fluent.getSecondaryIPv6Addresses(),fluent.getNetworks());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkSettingsBuilder that = (NetworkSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
