package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkResourceBuilder extends NetworkResourceFluentImpl<NetworkResourceBuilder> implements VisitableBuilder<NetworkResource,NetworkResourceBuilder>{

    NetworkResourceFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkResourceBuilder(){
            this(true);
    }
    public NetworkResourceBuilder(Boolean validationEnabled){
            this(new NetworkResource(), validationEnabled);
    }
    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkResource(), validationEnabled);
    }
    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent,NetworkResource instance){
            this(fluent, instance, true);
    }
    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent,NetworkResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContainers(instance.getContainers()); 
            fluent.withDriver(instance.getDriver()); 
            fluent.withIPAM(instance.getIPAM()); 
            fluent.withId(instance.getId()); 
            fluent.withName(instance.getName()); 
            fluent.withOptions(instance.getOptions()); 
            fluent.withScope(instance.getScope()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkResourceBuilder(NetworkResource instance){
            this(instance,true);
    }
    public NetworkResourceBuilder(NetworkResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContainers(instance.getContainers()); 
            this.withDriver(instance.getDriver()); 
            this.withIPAM(instance.getIPAM()); 
            this.withId(instance.getId()); 
            this.withName(instance.getName()); 
            this.withOptions(instance.getOptions()); 
            this.withScope(instance.getScope()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkResource build(){
            EditableNetworkResource buildable = new EditableNetworkResource(fluent.getContainers(),fluent.getDriver(),fluent.getIPAM(),fluent.getId(),fluent.getName(),fluent.getOptions(),fluent.getScope());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkResourceBuilder that = (NetworkResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
