package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkCreateBuilder extends NetworkCreateFluentImpl<NetworkCreateBuilder> implements VisitableBuilder<NetworkCreate,NetworkCreateBuilder>{

    NetworkCreateFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkCreateBuilder(){
            this(true);
    }
    public NetworkCreateBuilder(Boolean validationEnabled){
            this(new NetworkCreate(), validationEnabled);
    }
    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkCreate(), validationEnabled);
    }
    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent,NetworkCreate instance){
            this(fluent, instance, true);
    }
    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent,NetworkCreate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCheckDuplicate(instance.getCheckDuplicate()); 
            fluent.withDriver(instance.getDriver()); 
            fluent.withIPAM(instance.getIPAM()); 
            fluent.withName(instance.getName()); 
            fluent.withOptions(instance.getOptions()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkCreateBuilder(NetworkCreate instance){
            this(instance,true);
    }
    public NetworkCreateBuilder(NetworkCreate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCheckDuplicate(instance.getCheckDuplicate()); 
            this.withDriver(instance.getDriver()); 
            this.withIPAM(instance.getIPAM()); 
            this.withName(instance.getName()); 
            this.withOptions(instance.getOptions()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkCreate build(){
            EditableNetworkCreate buildable = new EditableNetworkCreate(fluent.isCheckDuplicate(),fluent.getDriver(),fluent.getIPAM(),fluent.getName(),fluent.getOptions());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkCreateBuilder that = (NetworkCreateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
