package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface InfoFluent<A extends InfoFluent<A>> extends Fluent<A>{


    public Boolean isBridgeNfIp6tables();
    public A withBridgeNfIp6tables(Boolean BridgeNfIp6tables);
    public Boolean hasBridgeNfIp6tables();
    public Boolean isBridgeNfIptables();
    public A withBridgeNfIptables(Boolean BridgeNfIptables);
    public Boolean hasBridgeNfIptables();
    public String getClusterAdvertise();
    public A withClusterAdvertise(String ClusterAdvertise);
    public Boolean hasClusterAdvertise();
    public String getClusterStore();
    public A withClusterStore(String ClusterStore);
    public Boolean hasClusterStore();
    public Integer getContainers();
    public A withContainers(Integer Containers);
    public Boolean hasContainers();
    public Boolean isCpuCfsPeriod();
    public A withCpuCfsPeriod(Boolean CpuCfsPeriod);
    public Boolean hasCpuCfsPeriod();
    public Boolean isCpuCfsQuota();
    public A withCpuCfsQuota(Boolean CpuCfsQuota);
    public Boolean hasCpuCfsQuota();
    public Boolean isDebug();
    public A withDebug(Boolean Debug);
    public Boolean hasDebug();
    public String getDockerRootDir();
    public A withDockerRootDir(String DockerRootDir);
    public Boolean hasDockerRootDir();
    public String getDriver();
    public A withDriver(String Driver);
    public Boolean hasDriver();
    public A addToDriverStatus(int index,Object item);
    public A setToDriverStatus(int index,Object item);
    public A addToDriverStatus(Object... items);
    public A addAllToDriverStatus(Collection<Object> items);
    public A removeFromDriverStatus(Object... items);
    public A removeAllFromDriverStatus(Collection<Object> items);
    public List<Object> getDriverStatus();
    public Object getDriverStatus(int index);
    public Object getFirstDriverStatus();
    public Object getLastDriverStatus();
    public Object getMatchingDriverStatus(io.fabric8.docker.api.builder.Predicate<Object> predicate);
    public A withDriverStatus(List<Object> DriverStatus);
    public A withDriverStatus(Object... DriverStatus);
    public Boolean hasDriverStatus();
    public String getExecutionDriver();
    public A withExecutionDriver(String ExecutionDriver);
    public Boolean hasExecutionDriver();
    public Boolean isExperimentalBuild();
    public A withExperimentalBuild(Boolean ExperimentalBuild);
    public Boolean hasExperimentalBuild();
    public String getHttpProxy();
    public A withHttpProxy(String HttpProxy);
    public Boolean hasHttpProxy();
    public String getHttpsProxy();
    public A withHttpsProxy(String HttpsProxy);
    public Boolean hasHttpsProxy();
    public String getID();
    public A withID(String ID);
    public Boolean hasID();
    public Boolean isIPv4Forwarding();
    public A withIPv4Forwarding(Boolean IPv4Forwarding);
    public Boolean hasIPv4Forwarding();
    public Integer getImages();
    public A withImages(Integer Images);
    public Boolean hasImages();
    public String getIndexServerAddress();
    public A withIndexServerAddress(String IndexServerAddress);
    public Boolean hasIndexServerAddress();
    public String getInitPath();
    public A withInitPath(String InitPath);
    public Boolean hasInitPath();
    public String getInitSha1();
    public A withInitSha1(String InitSha1);
    public Boolean hasInitSha1();
    public String getKernelVersion();
    public A withKernelVersion(String KernelVersion);
    public Boolean hasKernelVersion();
    public A addToLabels(int index,String item);
    public A setToLabels(int index,String item);
    public A addToLabels(String... items);
    public A addAllToLabels(Collection<String> items);
    public A removeFromLabels(String... items);
    public A removeAllFromLabels(Collection<String> items);
    public List<String> getLabels();
    public String getLabel(int index);
    public String getFirstLabel();
    public String getLastLabel();
    public String getMatchingLabel(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withLabels(List<String> Labels);
    public A withLabels(String... Labels);
    public Boolean hasLabels();
    public String getLoggingDriver();
    public A withLoggingDriver(String LoggingDriver);
    public Boolean hasLoggingDriver();
    public Long getMemTotal();
    public A withMemTotal(Long MemTotal);
    public Boolean hasMemTotal();
    public Boolean isMemoryLimit();
    public A withMemoryLimit(Boolean MemoryLimit);
    public Boolean hasMemoryLimit();
    public Integer getNCPU();
    public A withNCPU(Integer NCPU);
    public Boolean hasNCPU();
    public Integer getNEventsListener();
    public A withNEventsListener(Integer NEventsListener);
    public Boolean hasNEventsListener();
    public Integer getNFd();
    public A withNFd(Integer NFd);
    public Boolean hasNFd();
    public Integer getNGoroutines();
    public A withNGoroutines(Integer NGoroutines);
    public Boolean hasNGoroutines();
    public String getName();
    public A withName(String Name);
    public Boolean hasName();
    public String getNoProxy();
    public A withNoProxy(String NoProxy);
    public Boolean hasNoProxy();
    public Boolean isOomKillDisable();
    public A withOomKillDisable(Boolean OomKillDisable);
    public Boolean hasOomKillDisable();
    public String getOperatingSystem();
    public A withOperatingSystem(String OperatingSystem);
    public Boolean hasOperatingSystem();
    
/**
 * This method has been deprecated, please use method buildRegistryConfig instead.
 */
@Deprecated public ServiceConfig getRegistryConfig();
    public ServiceConfig buildRegistryConfig();
    public A withRegistryConfig(ServiceConfig RegistryConfig);
    public Boolean hasRegistryConfig();
    public InfoFluent.RegistryConfigNested<A> withNewRegistryConfig();
    public InfoFluent.RegistryConfigNested<A> withNewRegistryConfigLike(ServiceConfig item);
    public InfoFluent.RegistryConfigNested<A> editRegistryConfig();
    public InfoFluent.RegistryConfigNested<A> editOrNewRegistryConfig();
    public InfoFluent.RegistryConfigNested<A> editOrNewRegistryConfigLike(ServiceConfig item);
    public String getServerVersion();
    public A withServerVersion(String ServerVersion);
    public Boolean hasServerVersion();
    public Boolean isSwapLimit();
    public A withSwapLimit(Boolean SwapLimit);
    public Boolean hasSwapLimit();
    public String getSystemTime();
    public A withSystemTime(String SystemTime);
    public Boolean hasSystemTime();

    public interface RegistryConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ServiceConfigFluent<InfoFluent.RegistryConfigNested<N>>{

        
    public N and();    public N endRegistryConfig();
}


}
