package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.docker.api.builder.Predicate;

public interface IndexInfoFluent<A extends IndexInfoFluent<A>> extends Fluent<A>{


    public A addToMirrors(int index,String item);
    public A setToMirrors(int index,String item);
    public A addToMirrors(String... items);
    public A addAllToMirrors(Collection<String> items);
    public A removeFromMirrors(String... items);
    public A removeAllFromMirrors(Collection<String> items);
    public List<String> getMirrors();
    public String getMirror(int index);
    public String getFirstMirror();
    public String getLastMirror();
    public String getMatchingMirror(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withMirrors(List<String> Mirrors);
    public A withMirrors(String... Mirrors);
    public Boolean hasMirrors();
    public String getName();
    public A withName(String Name);
    public Boolean hasName();
    public Boolean isOfficial();
    public A withOfficial(Boolean Official);
    public Boolean hasOfficial();
    public Boolean isSecure();
    public A withSecure(Boolean Secure);
    public Boolean hasSecure();



}
