package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ImageInspectFluent<A extends ImageInspectFluent<A>> extends Fluent<A>{


    public String getArchitecture();
    public A withArchitecture(String Architecture);
    public Boolean hasArchitecture();
    public String getAuthor();
    public A withAuthor(String Author);
    public Boolean hasAuthor();
    public String getComment();
    public A withComment(String Comment);
    public Boolean hasComment();
    
/**
 * This method has been deprecated, please use method buildConfig instead.
 */
@Deprecated public Config getConfig();
    public Config buildConfig();
    public A withConfig(Config Config);
    public Boolean hasConfig();
    public ImageInspectFluent.ConfigNested<A> withNewConfig();
    public ImageInspectFluent.ConfigNested<A> withNewConfigLike(Config item);
    public ImageInspectFluent.ConfigNested<A> editConfig();
    public ImageInspectFluent.ConfigNested<A> editOrNewConfig();
    public ImageInspectFluent.ConfigNested<A> editOrNewConfigLike(Config item);
    public String getContainer();
    public A withContainer(String Container);
    public Boolean hasContainer();
    
/**
 * This method has been deprecated, please use method buildContainerConfig instead.
 */
@Deprecated public Config getContainerConfig();
    public Config buildContainerConfig();
    public A withContainerConfig(Config ContainerConfig);
    public Boolean hasContainerConfig();
    public ImageInspectFluent.ContainerConfigNested<A> withNewContainerConfig();
    public ImageInspectFluent.ContainerConfigNested<A> withNewContainerConfigLike(Config item);
    public ImageInspectFluent.ContainerConfigNested<A> editContainerConfig();
    public ImageInspectFluent.ContainerConfigNested<A> editOrNewContainerConfig();
    public ImageInspectFluent.ContainerConfigNested<A> editOrNewContainerConfigLike(Config item);
    public String getCreated();
    public A withCreated(String Created);
    public Boolean hasCreated();
    public String getDockerVersion();
    public A withDockerVersion(String DockerVersion);
    public Boolean hasDockerVersion();
    
/**
 * This method has been deprecated, please use method buildGraphDriver instead.
 */
@Deprecated public GraphDriverData getGraphDriver();
    public GraphDriverData buildGraphDriver();
    public A withGraphDriver(GraphDriverData GraphDriver);
    public Boolean hasGraphDriver();
    public ImageInspectFluent.GraphDriverNested<A> withNewGraphDriver();
    public ImageInspectFluent.GraphDriverNested<A> withNewGraphDriverLike(GraphDriverData item);
    public ImageInspectFluent.GraphDriverNested<A> editGraphDriver();
    public ImageInspectFluent.GraphDriverNested<A> editOrNewGraphDriver();
    public ImageInspectFluent.GraphDriverNested<A> editOrNewGraphDriverLike(GraphDriverData item);
    public String getId();
    public A withId(String Id);
    public Boolean hasId();
    public String getOs();
    public A withOs(String Os);
    public Boolean hasOs();
    public String getParent();
    public A withParent(String Parent);
    public Boolean hasParent();
    public A addToRepoDigests(int index,String item);
    public A setToRepoDigests(int index,String item);
    public A addToRepoDigests(String... items);
    public A addAllToRepoDigests(Collection<String> items);
    public A removeFromRepoDigests(String... items);
    public A removeAllFromRepoDigests(Collection<String> items);
    public List<String> getRepoDigests();
    public String getRepoDigest(int index);
    public String getFirstRepoDigest();
    public String getLastRepoDigest();
    public String getMatchingRepoDigest(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withRepoDigests(List<String> RepoDigests);
    public A withRepoDigests(String... RepoDigests);
    public Boolean hasRepoDigests();
    public A addToRepoTags(int index,String item);
    public A setToRepoTags(int index,String item);
    public A addToRepoTags(String... items);
    public A addAllToRepoTags(Collection<String> items);
    public A removeFromRepoTags(String... items);
    public A removeAllFromRepoTags(Collection<String> items);
    public List<String> getRepoTags();
    public String getRepoTag(int index);
    public String getFirstRepoTag();
    public String getLastRepoTag();
    public String getMatchingRepoTag(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withRepoTags(List<String> RepoTags);
    public A withRepoTags(String... RepoTags);
    public Boolean hasRepoTags();
    public Long getSize();
    public A withSize(Long Size);
    public Boolean hasSize();
    public Long getVirtualSize();
    public A withVirtualSize(Long VirtualSize);
    public Boolean hasVirtualSize();

    public interface ConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ConfigFluent<ImageInspectFluent.ConfigNested<N>>{

        
    public N and();    public N endConfig();
}
    public interface ContainerConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ConfigFluent<ImageInspectFluent.ContainerConfigNested<N>>{

        
    public N and();    public N endContainerConfig();
}
    public interface GraphDriverNested<N> extends io.fabric8.docker.api.builder.Nested<N>,GraphDriverDataFluent<ImageInspectFluent.GraphDriverNested<N>>{

        
    public N and();    public N endGraphDriver();
}


}
