package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ImageFluent<A extends ImageFluent<A>> extends Fluent<A>{


    public Long getCreated();
    public A withCreated(Long Created);
    public Boolean hasCreated();
    public String getId();
    public A withId(String Id);
    public Boolean hasId();
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> Labels);
    public Boolean hasLabels();
    public String getParentId();
    public A withParentId(String ParentId);
    public Boolean hasParentId();
    public A addToRepoDigests(int index,String item);
    public A setToRepoDigests(int index,String item);
    public A addToRepoDigests(String... items);
    public A addAllToRepoDigests(Collection<String> items);
    public A removeFromRepoDigests(String... items);
    public A removeAllFromRepoDigests(Collection<String> items);
    public List<String> getRepoDigests();
    public String getRepoDigest(int index);
    public String getFirstRepoDigest();
    public String getLastRepoDigest();
    public String getMatchingRepoDigest(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withRepoDigests(List<String> RepoDigests);
    public A withRepoDigests(String... RepoDigests);
    public Boolean hasRepoDigests();
    public A addToRepoTags(int index,String item);
    public A setToRepoTags(int index,String item);
    public A addToRepoTags(String... items);
    public A addAllToRepoTags(Collection<String> items);
    public A removeFromRepoTags(String... items);
    public A removeAllFromRepoTags(Collection<String> items);
    public List<String> getRepoTags();
    public String getRepoTag(int index);
    public String getFirstRepoTag();
    public String getLastRepoTag();
    public String getMatchingRepoTag(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withRepoTags(List<String> RepoTags);
    public A withRepoTags(String... RepoTags);
    public Boolean hasRepoTags();
    public Long getSize();
    public A withSize(Long Size);
    public Boolean hasSize();
    public Long getVirtualSize();
    public A withVirtualSize(Long VirtualSize);
    public Boolean hasVirtualSize();



}
