package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class IPAMFluentImpl<A extends IPAMFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements IPAMFluent<A>{

    private List<IPAMConfigBuilder> Config =  new ArrayList<IPAMConfigBuilder>();
    private String Driver;

    public IPAMFluentImpl(){
    }
    public IPAMFluentImpl(IPAM instance){
            this.withConfig(instance.getConfig()); 
            this.withDriver(instance.getDriver()); 
    }

    public A addToConfig(int index,IPAMConfig item){
            IPAMConfigBuilder builder = new IPAMConfigBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.Config.add(index >= 0 ? index : Config.size(), builder); return (A)this;
    }

    public A setToConfig(int index,IPAMConfig item){
            IPAMConfigBuilder builder = new IPAMConfigBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= Config.size()) { Config.add(builder); } else { Config.set(index, builder);}
             return (A)this;
    }

    public A addToConfig(IPAMConfig... items){
            for (IPAMConfig item : items) {IPAMConfigBuilder builder = new IPAMConfigBuilder(item);_visitables.add(builder);this.Config.add(builder);} return (A)this;
    }

    public A addAllToConfig(Collection<IPAMConfig> items){
            for (IPAMConfig item : items) {IPAMConfigBuilder builder = new IPAMConfigBuilder(item);_visitables.add(builder);this.Config.add(builder);} return (A)this;
    }

    public A removeFromConfig(IPAMConfig... items){
            for (IPAMConfig item : items) {IPAMConfigBuilder builder = new IPAMConfigBuilder(item);_visitables.remove(builder);this.Config.remove(builder);} return (A)this;
    }

    public A removeAllFromConfig(Collection<IPAMConfig> items){
            for (IPAMConfig item : items) {IPAMConfigBuilder builder = new IPAMConfigBuilder(item);_visitables.remove(builder);this.Config.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConfig instead.
 */
@Deprecated public List<IPAMConfig> getConfig(){
            return build(Config);
    }

    public List<IPAMConfig> buildConfig(){
            return build(Config);
    }

    public IPAMConfig buildConfig(int index){
            return this.Config.get(index).build();
    }

    public IPAMConfig buildFirstConfig(){
            return this.Config.get(0).build();
    }

    public IPAMConfig buildLastConfig(){
            return this.Config.get(Config.size() - 1).build();
    }

    public IPAMConfig buildMatchingConfig(io.fabric8.docker.api.builder.Predicate<IPAMConfigBuilder> predicate){
            for (IPAMConfigBuilder item: Config) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withConfig(List<IPAMConfig> Config){
            _visitables.removeAll(this.Config);
            this.Config.clear();
            if (Config != null) {for (IPAMConfig item : Config){this.addToConfig(item);}} return (A) this;
    }

    public A withConfig(IPAMConfig... Config){
            this.Config.clear(); if (Config != null) {for (IPAMConfig item :Config){ this.addToConfig(item);}} return (A) this;
    }

    public Boolean hasConfig(){
            return Config!= null && !Config.isEmpty();
    }

    public IPAMFluent.ConfigNested<A> addNewConfig(){
            return new ConfigNestedImpl();
    }

    public IPAMFluent.ConfigNested<A> addNewConfigLike(IPAMConfig item){
            return new ConfigNestedImpl(-1, item);
    }

    public IPAMFluent.ConfigNested<A> setNewConfigLike(int index,IPAMConfig item){
            return new ConfigNestedImpl(index, item);
    }

    public IPAMFluent.ConfigNested<A> editConfig(int index){
            if (Config.size() <= index) throw new RuntimeException("Can't edit Config. Index exceeds size.");
            return setNewConfigLike(index, buildConfig(index));
    }

    public IPAMFluent.ConfigNested<A> editFirstConfig(){
            if (Config.size() == 0) throw new RuntimeException("Can't edit first Config. The list is empty.");
            return setNewConfigLike(0, buildConfig(0));
    }

    public IPAMFluent.ConfigNested<A> editLastConfig(){
            int index = Config.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last Config. The list is empty.");
            return setNewConfigLike(index, buildConfig(index));
    }

    public IPAMFluent.ConfigNested<A> editMatchingConfig(io.fabric8.docker.api.builder.Predicate<IPAMConfigBuilder> predicate){
            int index = -1;
            for (int i=0;i<Config.size();i++) { 
            if (predicate.apply(Config.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching Config. No match found.");
            return setNewConfigLike(index, buildConfig(index));
    }

    public String getDriver(){
            return this.Driver;
    }

    public A withDriver(String Driver){
            this.Driver=Driver; return (A) this;
    }

    public Boolean hasDriver(){
            return this.Driver!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IPAMFluentImpl that = (IPAMFluentImpl) o;
            if (Config != null ? !Config.equals(that.Config) :that.Config != null) return false;
            if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
            return true;
    }


    public class ConfigNestedImpl<N> extends IPAMConfigFluentImpl<IPAMFluent.ConfigNested<N>> implements IPAMFluent.ConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final IPAMConfigBuilder builder;
        private final int index;
    
            ConfigNestedImpl(int index,IPAMConfig item){
                    this.index = index;
                    this.builder = new IPAMConfigBuilder(this, item);
            }
            ConfigNestedImpl(){
                    this.index = -1;
                    this.builder = new IPAMConfigBuilder(this);
            }
    
    public N and(){
            return (N) IPAMFluentImpl.this.setToConfig(index, builder.build());
    }
    public N endConfig(){
            return and();
    }

}


}
