package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface IPAMConfigFluent<A extends IPAMConfigFluent<A>> extends Fluent<A>{


    public A addToAuxiliaryAddresses(String key,String value);
    public A addToAuxiliaryAddresses(Map<String,String> map);
    public A removeFromAuxiliaryAddresses(String key);
    public A removeFromAuxiliaryAddresses(Map<String,String> map);
    public Map<String,String> getAuxiliaryAddresses();
    public A withAuxiliaryAddresses(Map<String,String> AuxiliaryAddresses);
    public Boolean hasAuxiliaryAddresses();
    public String getGateway();
    public A withGateway(String Gateway);
    public Boolean hasGateway();
    public String getIPRange();
    public A withIPRange(String IPRange);
    public Boolean hasIPRange();
    public String getSubnet();
    public A withSubnet(String Subnet);
    public Boolean hasSubnet();



}
