package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExecStartCheckBuilder extends ExecStartCheckFluentImpl<ExecStartCheckBuilder> implements VisitableBuilder<ExecStartCheck,ExecStartCheckBuilder>{

    ExecStartCheckFluent<?> fluent;
    Boolean validationEnabled;

    public ExecStartCheckBuilder(){
            this(true);
    }
    public ExecStartCheckBuilder(Boolean validationEnabled){
            this(new ExecStartCheck(), validationEnabled);
    }
    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent){
            this(fluent, true);
    }
    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExecStartCheck(), validationEnabled);
    }
    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent,ExecStartCheck instance){
            this(fluent, instance, true);
    }
    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent,ExecStartCheck instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDetach(instance.getDetach()); 
            fluent.withTty(instance.getTty()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExecStartCheckBuilder(ExecStartCheck instance){
            this(instance,true);
    }
    public ExecStartCheckBuilder(ExecStartCheck instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDetach(instance.getDetach()); 
            this.withTty(instance.getTty()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableExecStartCheck build(){
            EditableExecStartCheck buildable = new EditableExecStartCheck(fluent.isDetach(),fluent.isTty());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExecStartCheckBuilder that = (ExecStartCheckBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
