package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.docker.api.builder.Predicate;

public interface ExecConfigFluent<A extends ExecConfigFluent<A>> extends Fluent<A>{


    public Boolean isAttachStderr();
    public A withAttachStderr(Boolean AttachStderr);
    public Boolean hasAttachStderr();
    public Boolean isAttachStdin();
    public A withAttachStdin(Boolean AttachStdin);
    public Boolean hasAttachStdin();
    public Boolean isAttachStdout();
    public A withAttachStdout(Boolean AttachStdout);
    public Boolean hasAttachStdout();
    public A addToCmd(int index,String item);
    public A setToCmd(int index,String item);
    public A addToCmd(String... items);
    public A addAllToCmd(Collection<String> items);
    public A removeFromCmd(String... items);
    public A removeAllFromCmd(Collection<String> items);
    public List<String> getCmd();
    public String getCmd(int index);
    public String getFirstCmd();
    public String getLastCmd();
    public String getMatchingCmd(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withCmd(List<String> Cmd);
    public A withCmd(String... Cmd);
    public Boolean hasCmd();
    public String getContainer();
    public A withContainer(String Container);
    public Boolean hasContainer();
    public Boolean isDetach();
    public A withDetach(Boolean Detach);
    public Boolean hasDetach();
    public Boolean isPrivileged();
    public A withPrivileged(Boolean Privileged);
    public Boolean hasPrivileged();
    public Boolean isTty();
    public A withTty(Boolean Tty);
    public Boolean hasTty();
    public String getUser();
    public A withUser(String User);
    public Boolean hasUser();



}
