package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface EndpointResourceFluent<A extends EndpointResourceFluent<A>> extends Fluent<A>{


    public String getEndpointID();
    public A withEndpointID(String EndpointID);
    public Boolean hasEndpointID();
    public String getIPv4Address();
    public A withIPv4Address(String IPv4Address);
    public Boolean hasIPv4Address();
    public String getIPv6Address();
    public A withIPv6Address(String IPv6Address);
    public Boolean hasIPv6Address();
    public String getMacAddress();
    public A withMacAddress(String MacAddress);
    public Boolean hasMacAddress();



}
