package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DockerSchemaBuilder extends DockerSchemaFluentImpl<DockerSchemaBuilder> implements VisitableBuilder<DockerSchema,DockerSchemaBuilder>{

    DockerSchemaFluent<?> fluent;
    Boolean validationEnabled;

    public DockerSchemaBuilder(){
            this(true);
    }
    public DockerSchemaBuilder(Boolean validationEnabled){
            this(new DockerSchema(), validationEnabled);
    }
    public DockerSchemaBuilder(DockerSchemaFluent<?> fluent){
            this(fluent, true);
    }
    public DockerSchemaBuilder(DockerSchemaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DockerSchema(), validationEnabled);
    }
    public DockerSchemaBuilder(DockerSchemaFluent<?> fluent,DockerSchema instance){
            this(fluent, instance, true);
    }
    public DockerSchemaBuilder(DockerSchemaFluent<?> fluent,DockerSchema instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withAuthConfig(instance.getAuthConfig()); 
            fluent.withAuthResponse(instance.getAuthResponse()); 
            fluent.withContainerChange(instance.getContainerChange()); 
            fluent.withContainerCommitResponse(instance.getContainerCommitResponse()); 
            fluent.withContainerCreateResponse(instance.getContainerCreateResponse()); 
            fluent.withContainerExecCreateResponse(instance.getContainerExecCreateResponse()); 
            fluent.withContainerJSONBase(instance.getContainerJSONBase()); 
            fluent.withContainerPathStat(instance.getContainerPathStat()); 
            fluent.withContainerProcessList(instance.getContainerProcessList()); 
            fluent.withContainerState(instance.getContainerState()); 
            fluent.withContainerWaitResponse(instance.getContainerWaitResponse()); 
            fluent.withCopyConfig(instance.getCopyConfig()); 
            fluent.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); 
            fluent.withEndpointResource(instance.getEndpointResource()); 
            fluent.withEndpointSettings(instance.getEndpointSettings()); 
            fluent.withExecConfig(instance.getExecConfig()); 
            fluent.withExecStartCheck(instance.getExecStartCheck()); 
            fluent.withGraphDriverData(instance.getGraphDriverData()); 
            fluent.withHostConfig(instance.getHostConfig()); 
            fluent.withIPAM(instance.getIPAM()); 
            fluent.withIPAMConfig(instance.getIPAMConfig()); 
            fluent.withImage(instance.getImage()); 
            fluent.withImageDelete(instance.getImageDelete()); 
            fluent.withImageHistory(instance.getImageHistory()); 
            fluent.withImageInspect(instance.getImageInspect()); 
            fluent.withIndexInfo(instance.getIndexInfo()); 
            fluent.withInfo(instance.getInfo()); 
            fluent.withKeyValuePair(instance.getKeyValuePair()); 
            fluent.withLogConfig(instance.getLogConfig()); 
            fluent.withMountPoint(instance.getMountPoint()); 
            fluent.withNetworkConnect(instance.getNetworkConnect()); 
            fluent.withNetworkCreate(instance.getNetworkCreate()); 
            fluent.withNetworkCreateResponse(instance.getNetworkCreateResponse()); 
            fluent.withNetworkDisconnect(instance.getNetworkDisconnect()); 
            fluent.withNetworkResource(instance.getNetworkResource()); 
            fluent.withNetworkSettings(instance.getNetworkSettings()); 
            fluent.withNetworkSettingsBase(instance.getNetworkSettingsBase()); 
            fluent.withPort(instance.getPort()); 
            fluent.withPortBinding(instance.getPortBinding()); 
            fluent.withSearchResult(instance.getSearchResult()); 
            fluent.withSearchResults(instance.getSearchResults()); 
            fluent.withServiceConfig(instance.getServiceConfig()); 
            fluent.withStats(instance.getStats()); 
            fluent.withStrSlice(instance.getStrSlice()); 
            fluent.withVersion(instance.getVersion()); 
            fluent.withVolume(instance.getVolume()); 
            fluent.withVolumeCreateRequest(instance.getVolumeCreateRequest()); 
            fluent.withVolumesListResponse(instance.getVolumesListResponse()); 
            this.validationEnabled = validationEnabled; 
    }
    public DockerSchemaBuilder(DockerSchema instance){
            this(instance,true);
    }
    public DockerSchemaBuilder(DockerSchema instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withAuthConfig(instance.getAuthConfig()); 
            this.withAuthResponse(instance.getAuthResponse()); 
            this.withContainerChange(instance.getContainerChange()); 
            this.withContainerCommitResponse(instance.getContainerCommitResponse()); 
            this.withContainerCreateResponse(instance.getContainerCreateResponse()); 
            this.withContainerExecCreateResponse(instance.getContainerExecCreateResponse()); 
            this.withContainerJSONBase(instance.getContainerJSONBase()); 
            this.withContainerPathStat(instance.getContainerPathStat()); 
            this.withContainerProcessList(instance.getContainerProcessList()); 
            this.withContainerState(instance.getContainerState()); 
            this.withContainerWaitResponse(instance.getContainerWaitResponse()); 
            this.withCopyConfig(instance.getCopyConfig()); 
            this.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); 
            this.withEndpointResource(instance.getEndpointResource()); 
            this.withEndpointSettings(instance.getEndpointSettings()); 
            this.withExecConfig(instance.getExecConfig()); 
            this.withExecStartCheck(instance.getExecStartCheck()); 
            this.withGraphDriverData(instance.getGraphDriverData()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.withIPAM(instance.getIPAM()); 
            this.withIPAMConfig(instance.getIPAMConfig()); 
            this.withImage(instance.getImage()); 
            this.withImageDelete(instance.getImageDelete()); 
            this.withImageHistory(instance.getImageHistory()); 
            this.withImageInspect(instance.getImageInspect()); 
            this.withIndexInfo(instance.getIndexInfo()); 
            this.withInfo(instance.getInfo()); 
            this.withKeyValuePair(instance.getKeyValuePair()); 
            this.withLogConfig(instance.getLogConfig()); 
            this.withMountPoint(instance.getMountPoint()); 
            this.withNetworkConnect(instance.getNetworkConnect()); 
            this.withNetworkCreate(instance.getNetworkCreate()); 
            this.withNetworkCreateResponse(instance.getNetworkCreateResponse()); 
            this.withNetworkDisconnect(instance.getNetworkDisconnect()); 
            this.withNetworkResource(instance.getNetworkResource()); 
            this.withNetworkSettings(instance.getNetworkSettings()); 
            this.withNetworkSettingsBase(instance.getNetworkSettingsBase()); 
            this.withPort(instance.getPort()); 
            this.withPortBinding(instance.getPortBinding()); 
            this.withSearchResult(instance.getSearchResult()); 
            this.withSearchResults(instance.getSearchResults()); 
            this.withServiceConfig(instance.getServiceConfig()); 
            this.withStats(instance.getStats()); 
            this.withStrSlice(instance.getStrSlice()); 
            this.withVersion(instance.getVersion()); 
            this.withVolume(instance.getVolume()); 
            this.withVolumeCreateRequest(instance.getVolumeCreateRequest()); 
            this.withVolumesListResponse(instance.getVolumesListResponse()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableDockerSchema build(){
            EditableDockerSchema buildable = new EditableDockerSchema(fluent.getAddress(),fluent.getAuthConfig(),fluent.getAuthResponse(),fluent.getContainerChange(),fluent.getContainerCommitResponse(),fluent.getContainerCreateResponse(),fluent.getContainerExecCreateResponse(),fluent.getContainerJSONBase(),fluent.getContainerPathStat(),fluent.getContainerProcessList(),fluent.getContainerState(),fluent.getContainerWaitResponse(),fluent.getCopyConfig(),fluent.getDefaultNetworkSettings(),fluent.getEndpointResource(),fluent.getEndpointSettings(),fluent.getExecConfig(),fluent.getExecStartCheck(),fluent.getGraphDriverData(),fluent.getHostConfig(),fluent.getIPAM(),fluent.getIPAMConfig(),fluent.getImage(),fluent.getImageDelete(),fluent.getImageHistory(),fluent.getImageInspect(),fluent.getIndexInfo(),fluent.getInfo(),fluent.getKeyValuePair(),fluent.getLogConfig(),fluent.getMountPoint(),fluent.getNetworkConnect(),fluent.getNetworkCreate(),fluent.getNetworkCreateResponse(),fluent.getNetworkDisconnect(),fluent.getNetworkResource(),fluent.getNetworkSettings(),fluent.getNetworkSettingsBase(),fluent.getPort(),fluent.getPortBinding(),fluent.getSearchResult(),fluent.getSearchResults(),fluent.getServiceConfig(),fluent.getStats(),fluent.getStrSlice(),fluent.getVersion(),fluent.getVolume(),fluent.getVolumeCreateRequest(),fluent.getVolumesListResponse());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerSchemaBuilder that = (DockerSchemaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
