package io.fabric8.docker.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class DefaultNetworkSettingsFluentImpl<A extends DefaultNetworkSettingsFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements DefaultNetworkSettingsFluent<A>{

    private String EndpointID;
    private String Gateway;
    private String GlobalIPv6Address;
    private Integer GlobalIPv6PrefixLen;
    private String IPAddress;
    private Integer IPPrefixLen;
    private String IPv6Gateway;
    private String MacAddress;

    public DefaultNetworkSettingsFluentImpl(){
    }
    public DefaultNetworkSettingsFluentImpl(DefaultNetworkSettings instance){
            this.withEndpointID(instance.getEndpointID()); 
            this.withGateway(instance.getGateway()); 
            this.withGlobalIPv6Address(instance.getGlobalIPv6Address()); 
            this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); 
            this.withIPAddress(instance.getIPAddress()); 
            this.withIPPrefixLen(instance.getIPPrefixLen()); 
            this.withIPv6Gateway(instance.getIPv6Gateway()); 
            this.withMacAddress(instance.getMacAddress()); 
    }

    public String getEndpointID(){
            return this.EndpointID;
    }

    public A withEndpointID(String EndpointID){
            this.EndpointID=EndpointID; return (A) this;
    }

    public Boolean hasEndpointID(){
            return this.EndpointID!=null;
    }

    public String getGateway(){
            return this.Gateway;
    }

    public A withGateway(String Gateway){
            this.Gateway=Gateway; return (A) this;
    }

    public Boolean hasGateway(){
            return this.Gateway!=null;
    }

    public String getGlobalIPv6Address(){
            return this.GlobalIPv6Address;
    }

    public A withGlobalIPv6Address(String GlobalIPv6Address){
            this.GlobalIPv6Address=GlobalIPv6Address; return (A) this;
    }

    public Boolean hasGlobalIPv6Address(){
            return this.GlobalIPv6Address!=null;
    }

    public Integer getGlobalIPv6PrefixLen(){
            return this.GlobalIPv6PrefixLen;
    }

    public A withGlobalIPv6PrefixLen(Integer GlobalIPv6PrefixLen){
            this.GlobalIPv6PrefixLen=GlobalIPv6PrefixLen; return (A) this;
    }

    public Boolean hasGlobalIPv6PrefixLen(){
            return this.GlobalIPv6PrefixLen!=null;
    }

    public String getIPAddress(){
            return this.IPAddress;
    }

    public A withIPAddress(String IPAddress){
            this.IPAddress=IPAddress; return (A) this;
    }

    public Boolean hasIPAddress(){
            return this.IPAddress!=null;
    }

    public Integer getIPPrefixLen(){
            return this.IPPrefixLen;
    }

    public A withIPPrefixLen(Integer IPPrefixLen){
            this.IPPrefixLen=IPPrefixLen; return (A) this;
    }

    public Boolean hasIPPrefixLen(){
            return this.IPPrefixLen!=null;
    }

    public String getIPv6Gateway(){
            return this.IPv6Gateway;
    }

    public A withIPv6Gateway(String IPv6Gateway){
            this.IPv6Gateway=IPv6Gateway; return (A) this;
    }

    public Boolean hasIPv6Gateway(){
            return this.IPv6Gateway!=null;
    }

    public String getMacAddress(){
            return this.MacAddress;
    }

    public A withMacAddress(String MacAddress){
            this.MacAddress=MacAddress; return (A) this;
    }

    public Boolean hasMacAddress(){
            return this.MacAddress!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DefaultNetworkSettingsFluentImpl that = (DefaultNetworkSettingsFluentImpl) o;
            if (EndpointID != null ? !EndpointID.equals(that.EndpointID) :that.EndpointID != null) return false;
            if (Gateway != null ? !Gateway.equals(that.Gateway) :that.Gateway != null) return false;
            if (GlobalIPv6Address != null ? !GlobalIPv6Address.equals(that.GlobalIPv6Address) :that.GlobalIPv6Address != null) return false;
            if (GlobalIPv6PrefixLen != null ? !GlobalIPv6PrefixLen.equals(that.GlobalIPv6PrefixLen) :that.GlobalIPv6PrefixLen != null) return false;
            if (IPAddress != null ? !IPAddress.equals(that.IPAddress) :that.IPAddress != null) return false;
            if (IPPrefixLen != null ? !IPPrefixLen.equals(that.IPPrefixLen) :that.IPPrefixLen != null) return false;
            if (IPv6Gateway != null ? !IPv6Gateway.equals(that.IPv6Gateway) :that.IPv6Gateway != null) return false;
            if (MacAddress != null ? !MacAddress.equals(that.MacAddress) :that.MacAddress != null) return false;
            return true;
    }




}
