package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerProcessListBuilder extends ContainerProcessListFluentImpl<ContainerProcessListBuilder> implements VisitableBuilder<ContainerProcessList,ContainerProcessListBuilder>{

    ContainerProcessListFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerProcessListBuilder(){
            this(true);
    }
    public ContainerProcessListBuilder(Boolean validationEnabled){
            this(new ContainerProcessList(), validationEnabled);
    }
    public ContainerProcessListBuilder(ContainerProcessListFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerProcessListBuilder(ContainerProcessListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerProcessList(), validationEnabled);
    }
    public ContainerProcessListBuilder(ContainerProcessListFluent<?> fluent,ContainerProcessList instance){
            this(fluent, instance, true);
    }
    public ContainerProcessListBuilder(ContainerProcessListFluent<?> fluent,ContainerProcessList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProcesses(instance.getProcesses()); 
            fluent.withTitles(instance.getTitles()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerProcessListBuilder(ContainerProcessList instance){
            this(instance,true);
    }
    public ContainerProcessListBuilder(ContainerProcessList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProcesses(instance.getProcesses()); 
            this.withTitles(instance.getTitles()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerProcessList build(){
            EditableContainerProcessList buildable = new EditableContainerProcessList(fluent.getProcesses(),fluent.getTitles());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerProcessListBuilder that = (ContainerProcessListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
