package io.fabric8.docker.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ContainerPathStatFluentImpl<A extends ContainerPathStatFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ContainerPathStatFluent<A>{

    private String linkTarget;
    private Integer mode;
    private String mtime;
    private String name;
    private Long size;

    public ContainerPathStatFluentImpl(){
    }
    public ContainerPathStatFluentImpl(ContainerPathStat instance){
            this.withLinkTarget(instance.getLinkTarget()); 
            this.withMode(instance.getMode()); 
            this.withMtime(instance.getMtime()); 
            this.withName(instance.getName()); 
            this.withSize(instance.getSize()); 
    }

    public String getLinkTarget(){
            return this.linkTarget;
    }

    public A withLinkTarget(String linkTarget){
            this.linkTarget=linkTarget; return (A) this;
    }

    public Boolean hasLinkTarget(){
            return this.linkTarget!=null;
    }

    public Integer getMode(){
            return this.mode;
    }

    public A withMode(Integer mode){
            this.mode=mode; return (A) this;
    }

    public Boolean hasMode(){
            return this.mode!=null;
    }

    public String getMtime(){
            return this.mtime;
    }

    public A withMtime(String mtime){
            this.mtime=mtime; return (A) this;
    }

    public Boolean hasMtime(){
            return this.mtime!=null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name!=null;
    }

    public Long getSize(){
            return this.size;
    }

    public A withSize(Long size){
            this.size=size; return (A) this;
    }

    public Boolean hasSize(){
            return this.size!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerPathStatFluentImpl that = (ContainerPathStatFluentImpl) o;
            if (linkTarget != null ? !linkTarget.equals(that.linkTarget) :that.linkTarget != null) return false;
            if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
            if (mtime != null ? !mtime.equals(that.mtime) :that.mtime != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (size != null ? !size.equals(that.size) :that.size != null) return false;
            return true;
    }




}
