package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ContainerJSONBaseFluent<A extends ContainerJSONBaseFluent<A>> extends Fluent<A>{


    public String getAppArmorProfile();
    public A withAppArmorProfile(String AppArmorProfile);
    public Boolean hasAppArmorProfile();
    public A addToArgs(int index,String item);
    public A setToArgs(int index,String item);
    public A addToArgs(String... items);
    public A addAllToArgs(Collection<String> items);
    public A removeFromArgs(String... items);
    public A removeAllFromArgs(Collection<String> items);
    public List<String> getArgs();
    public String getArg(int index);
    public String getFirstArg();
    public String getLastArg();
    public String getMatchingArg(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withArgs(List<String> Args);
    public A withArgs(String... Args);
    public Boolean hasArgs();
    public String getCreated();
    public A withCreated(String Created);
    public Boolean hasCreated();
    public String getDriver();
    public A withDriver(String Driver);
    public Boolean hasDriver();
    public String getExecDriver();
    public A withExecDriver(String ExecDriver);
    public Boolean hasExecDriver();
    public A addToExecIDs(int index,String item);
    public A setToExecIDs(int index,String item);
    public A addToExecIDs(String... items);
    public A addAllToExecIDs(Collection<String> items);
    public A removeFromExecIDs(String... items);
    public A removeAllFromExecIDs(Collection<String> items);
    public List<String> getExecIDs();
    public String getExecID(int index);
    public String getFirstExecID();
    public String getLastExecID();
    public String getMatchingExecID(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withExecIDs(List<String> ExecIDs);
    public A withExecIDs(String... ExecIDs);
    public Boolean hasExecIDs();
    
/**
 * This method has been deprecated, please use method buildGraphDriver instead.
 */
@Deprecated public GraphDriverData getGraphDriver();
    public GraphDriverData buildGraphDriver();
    public A withGraphDriver(GraphDriverData GraphDriver);
    public Boolean hasGraphDriver();
    public ContainerJSONBaseFluent.GraphDriverNested<A> withNewGraphDriver();
    public ContainerJSONBaseFluent.GraphDriverNested<A> withNewGraphDriverLike(GraphDriverData item);
    public ContainerJSONBaseFluent.GraphDriverNested<A> editGraphDriver();
    public ContainerJSONBaseFluent.GraphDriverNested<A> editOrNewGraphDriver();
    public ContainerJSONBaseFluent.GraphDriverNested<A> editOrNewGraphDriverLike(GraphDriverData item);
    
/**
 * This method has been deprecated, please use method buildHostConfig instead.
 */
@Deprecated public HostConfig getHostConfig();
    public HostConfig buildHostConfig();
    public A withHostConfig(HostConfig HostConfig);
    public Boolean hasHostConfig();
    public ContainerJSONBaseFluent.HostConfigNested<A> withNewHostConfig();
    public ContainerJSONBaseFluent.HostConfigNested<A> withNewHostConfigLike(HostConfig item);
    public ContainerJSONBaseFluent.HostConfigNested<A> editHostConfig();
    public ContainerJSONBaseFluent.HostConfigNested<A> editOrNewHostConfig();
    public ContainerJSONBaseFluent.HostConfigNested<A> editOrNewHostConfigLike(HostConfig item);
    public String getHostnamePath();
    public A withHostnamePath(String HostnamePath);
    public Boolean hasHostnamePath();
    public String getHostsPath();
    public A withHostsPath(String HostsPath);
    public Boolean hasHostsPath();
    public String getId();
    public A withId(String Id);
    public Boolean hasId();
    public String getImage();
    public A withImage(String Image);
    public Boolean hasImage();
    public String getLogPath();
    public A withLogPath(String LogPath);
    public Boolean hasLogPath();
    public String getMountLabel();
    public A withMountLabel(String MountLabel);
    public Boolean hasMountLabel();
    public String getName();
    public A withName(String Name);
    public Boolean hasName();
    public String getPath();
    public A withPath(String Path);
    public Boolean hasPath();
    public String getProcessLabel();
    public A withProcessLabel(String ProcessLabel);
    public Boolean hasProcessLabel();
    public String getResolvConfPath();
    public A withResolvConfPath(String ResolvConfPath);
    public Boolean hasResolvConfPath();
    public Integer getRestartCount();
    public A withRestartCount(Integer RestartCount);
    public Boolean hasRestartCount();
    public Long getSizeRootFs();
    public A withSizeRootFs(Long SizeRootFs);
    public Boolean hasSizeRootFs();
    public Long getSizeRw();
    public A withSizeRw(Long SizeRw);
    public Boolean hasSizeRw();
    
/**
 * This method has been deprecated, please use method buildState instead.
 */
@Deprecated public ContainerState getState();
    public ContainerState buildState();
    public A withState(ContainerState State);
    public Boolean hasState();
    public ContainerJSONBaseFluent.StateNested<A> withNewState();
    public ContainerJSONBaseFluent.StateNested<A> withNewStateLike(ContainerState item);
    public ContainerJSONBaseFluent.StateNested<A> editState();
    public ContainerJSONBaseFluent.StateNested<A> editOrNewState();
    public ContainerJSONBaseFluent.StateNested<A> editOrNewStateLike(ContainerState item);

    public interface GraphDriverNested<N> extends io.fabric8.docker.api.builder.Nested<N>,GraphDriverDataFluent<ContainerJSONBaseFluent.GraphDriverNested<N>>{

        
    public N and();    public N endGraphDriver();
}
    public interface HostConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,HostConfigFluent<ContainerJSONBaseFluent.HostConfigNested<N>>{

        
    public N and();    public N endHostConfig();
}
    public interface StateNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerStateFluent<ContainerJSONBaseFluent.StateNested<N>>{

        
    public N and();    public N endState();
}


}
