package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerJSONBaseBuilder extends ContainerJSONBaseFluentImpl<ContainerJSONBaseBuilder> implements VisitableBuilder<ContainerJSONBase,ContainerJSONBaseBuilder>{

    ContainerJSONBaseFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerJSONBaseBuilder(){
            this(true);
    }
    public ContainerJSONBaseBuilder(Boolean validationEnabled){
            this(new ContainerJSONBase(), validationEnabled);
    }
    public ContainerJSONBaseBuilder(ContainerJSONBaseFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerJSONBaseBuilder(ContainerJSONBaseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerJSONBase(), validationEnabled);
    }
    public ContainerJSONBaseBuilder(ContainerJSONBaseFluent<?> fluent,ContainerJSONBase instance){
            this(fluent, instance, true);
    }
    public ContainerJSONBaseBuilder(ContainerJSONBaseFluent<?> fluent,ContainerJSONBase instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAppArmorProfile(instance.getAppArmorProfile()); 
            fluent.withArgs(instance.getArgs()); 
            fluent.withCreated(instance.getCreated()); 
            fluent.withDriver(instance.getDriver()); 
            fluent.withExecDriver(instance.getExecDriver()); 
            fluent.withExecIDs(instance.getExecIDs()); 
            fluent.withGraphDriver(instance.getGraphDriver()); 
            fluent.withHostConfig(instance.getHostConfig()); 
            fluent.withHostnamePath(instance.getHostnamePath()); 
            fluent.withHostsPath(instance.getHostsPath()); 
            fluent.withId(instance.getId()); 
            fluent.withImage(instance.getImage()); 
            fluent.withLogPath(instance.getLogPath()); 
            fluent.withMountLabel(instance.getMountLabel()); 
            fluent.withName(instance.getName()); 
            fluent.withPath(instance.getPath()); 
            fluent.withProcessLabel(instance.getProcessLabel()); 
            fluent.withResolvConfPath(instance.getResolvConfPath()); 
            fluent.withRestartCount(instance.getRestartCount()); 
            fluent.withSizeRootFs(instance.getSizeRootFs()); 
            fluent.withSizeRw(instance.getSizeRw()); 
            fluent.withState(instance.getState()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerJSONBaseBuilder(ContainerJSONBase instance){
            this(instance,true);
    }
    public ContainerJSONBaseBuilder(ContainerJSONBase instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAppArmorProfile(instance.getAppArmorProfile()); 
            this.withArgs(instance.getArgs()); 
            this.withCreated(instance.getCreated()); 
            this.withDriver(instance.getDriver()); 
            this.withExecDriver(instance.getExecDriver()); 
            this.withExecIDs(instance.getExecIDs()); 
            this.withGraphDriver(instance.getGraphDriver()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.withHostnamePath(instance.getHostnamePath()); 
            this.withHostsPath(instance.getHostsPath()); 
            this.withId(instance.getId()); 
            this.withImage(instance.getImage()); 
            this.withLogPath(instance.getLogPath()); 
            this.withMountLabel(instance.getMountLabel()); 
            this.withName(instance.getName()); 
            this.withPath(instance.getPath()); 
            this.withProcessLabel(instance.getProcessLabel()); 
            this.withResolvConfPath(instance.getResolvConfPath()); 
            this.withRestartCount(instance.getRestartCount()); 
            this.withSizeRootFs(instance.getSizeRootFs()); 
            this.withSizeRw(instance.getSizeRw()); 
            this.withState(instance.getState()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerJSONBase build(){
            EditableContainerJSONBase buildable = new EditableContainerJSONBase(fluent.getAppArmorProfile(),fluent.getArgs(),fluent.getCreated(),fluent.getDriver(),fluent.getExecDriver(),fluent.getExecIDs(),fluent.getGraphDriver(),fluent.getHostConfig(),fluent.getHostnamePath(),fluent.getHostsPath(),fluent.getId(),fluent.getImage(),fluent.getLogPath(),fluent.getMountLabel(),fluent.getName(),fluent.getPath(),fluent.getProcessLabel(),fluent.getResolvConfPath(),fluent.getRestartCount(),fluent.getSizeRootFs(),fluent.getSizeRw(),fluent.getState());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerJSONBaseBuilder that = (ContainerJSONBaseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
