package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerHostConfigBuilder extends ContainerHostConfigFluentImpl<ContainerHostConfigBuilder> implements VisitableBuilder<ContainerHostConfig,ContainerHostConfigBuilder>{

    ContainerHostConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerHostConfigBuilder(){
            this(true);
    }
    public ContainerHostConfigBuilder(Boolean validationEnabled){
            this(new ContainerHostConfig(), validationEnabled);
    }
    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerHostConfig(), validationEnabled);
    }
    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent,ContainerHostConfig instance){
            this(fluent, instance, true);
    }
    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent,ContainerHostConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNetworkMode(instance.getNetworkMode()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerHostConfigBuilder(ContainerHostConfig instance){
            this(instance,true);
    }
    public ContainerHostConfigBuilder(ContainerHostConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNetworkMode(instance.getNetworkMode()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerHostConfig build(){
            EditableContainerHostConfig buildable = new EditableContainerHostConfig(fluent.getNetworkMode());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerHostConfigBuilder that = (ContainerHostConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
