package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class ContainerFluentImpl<A extends ContainerFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ContainerFluent<A>{

    private String id;
    private List<String> names = new ArrayList<String>();
    private String image;
    private String imageId;
    private String command;
    private Long created;
    private List<PortBuilder> ports =  new ArrayList<PortBuilder>();
    private Long sizeRw;
    private Long sizeRootFs;
    private Map<String,String> labels = new LinkedHashMap<String,String>();
    private String status;
    private ContainerHostConfigBuilder hostConfig;
    private NetworkSettingsBuilder summaryNetworkSettings;

    public ContainerFluentImpl(){
    }
    public ContainerFluentImpl(Container instance){
            this.withId(instance.getId()); 
            this.withNames(instance.getNames()); 
            this.withImage(instance.getImage()); 
            this.withImageId(instance.getImageId()); 
            this.withCommand(instance.getCommand()); 
            this.withCreated(instance.getCreated()); 
            this.withPorts(instance.getPorts()); 
            this.withSizeRw(instance.getSizeRw()); 
            this.withSizeRootFs(instance.getSizeRootFs()); 
            this.withLabels(instance.getLabels()); 
            this.withStatus(instance.getStatus()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.withSummaryNetworkSettings(instance.getSummaryNetworkSettings()); 
    }

    public String getId(){
            return this.id;
    }

    public A withId(String id){
            this.id=id; return (A) this;
    }

    public Boolean hasId(){
            return this.id!=null;
    }

    public A addToNames(int index,String item){
            this.names.add(index, item); return (A)this;
    }

    public A setToNames(int index,String item){
            this.names.set(index, item); return (A)this;
    }

    public A addToNames(String... items){
            for (String item : items) {this.names.add(item);} return (A)this;
    }

    public A addAllToNames(Collection<String> items){
            for (String item : items) {this.names.add(item);} return (A)this;
    }

    public A removeFromNames(String... items){
            for (String item : items) {this.names.remove(item);} return (A)this;
    }

    public A removeAllFromNames(Collection<String> items){
            for (String item : items) {this.names.remove(item);} return (A)this;
    }

    public List<String> getNames(){
            return this.names;
    }

    public String getName(int index){
            return this.names.get(index);
    }

    public String getFirstName(){
            return this.names.get(0);
    }

    public String getLastName(){
            return this.names.get(names.size() - 1);
    }

    public String getMatchingName(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: names) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withNames(List<String> names){
            this.names.clear();
            if (names != null) {for (String item : names){this.addToNames(item);}} return (A) this;
    }

    public A withNames(String... names){
            this.names.clear(); if (names != null) {for (String item :names){ this.addToNames(item);}} return (A) this;
    }

    public Boolean hasNames(){
            return names!= null && !names.isEmpty();
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image!=null;
    }

    public String getImageId(){
            return this.imageId;
    }

    public A withImageId(String imageId){
            this.imageId=imageId; return (A) this;
    }

    public Boolean hasImageId(){
            return this.imageId!=null;
    }

    public String getCommand(){
            return this.command;
    }

    public A withCommand(String command){
            this.command=command; return (A) this;
    }

    public Boolean hasCommand(){
            return this.command!=null;
    }

    public Long getCreated(){
            return this.created;
    }

    public A withCreated(Long created){
            this.created=created; return (A) this;
    }

    public Boolean hasCreated(){
            return this.created!=null;
    }

    public A addToPorts(int index,Port item){
            PortBuilder builder = new PortBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,Port item){
            PortBuilder builder = new PortBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
             return (A)this;
    }

    public A addToPorts(Port... items){
            for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<Port> items){
            for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(Port... items){
            for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (A)this;
    }

    public A removeAllFromPorts(Collection<Port> items){
            for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 */
@Deprecated public List<Port> getPorts(){
            return build(ports);
    }

    public List<Port> buildPorts(){
            return build(ports);
    }

    public Port buildPort(int index){
            return this.ports.get(index).build();
    }

    public Port buildFirstPort(){
            return this.ports.get(0).build();
    }

    public Port buildLastPort(){
            return this.ports.get(ports.size() - 1).build();
    }

    public Port buildMatchingPort(io.fabric8.docker.api.builder.Predicate<PortBuilder> predicate){
            for (PortBuilder item: ports) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withPorts(List<Port> ports){
            _visitables.removeAll(this.ports);
            this.ports.clear();
            if (ports != null) {for (Port item : ports){this.addToPorts(item);}} return (A) this;
    }

    public A withPorts(Port... ports){
            this.ports.clear(); if (ports != null) {for (Port item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts(){
            return ports!= null && !ports.isEmpty();
    }

    public ContainerFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public ContainerFluent.PortsNested<A> addNewPortLike(Port item){
            return new PortsNestedImpl(-1, item);
    }

    public ContainerFluent.PortsNested<A> setNewPortLike(int index,Port item){
            return new PortsNestedImpl(index, item);
    }

    public ContainerFluent.PortsNested<A> editPort(int index){
            if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
            return setNewPortLike(index, buildPort(index));
    }

    public ContainerFluent.PortsNested<A> editFirstPort(){
            if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
            return setNewPortLike(0, buildPort(0));
    }

    public ContainerFluent.PortsNested<A> editLastPort(){
            int index = ports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
            return setNewPortLike(index, buildPort(index));
    }

    public ContainerFluent.PortsNested<A> editMatchingPort(io.fabric8.docker.api.builder.Predicate<PortBuilder> predicate){
            int index = -1;
            for (int i=0;i<ports.size();i++) { 
            if (predicate.apply(ports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
            return setNewPortLike(index, buildPort(index));
    }

    public A addNewPort(String IP,Integer PrivatePort,Integer PublicPort,String Type){
            return (A)addToPorts(new Port(IP, PrivatePort, PublicPort, Type));
    }

    public Long getSizeRw(){
            return this.sizeRw;
    }

    public A withSizeRw(Long sizeRw){
            this.sizeRw=sizeRw; return (A) this;
    }

    public Boolean hasSizeRw(){
            return this.sizeRw!=null;
    }

    public Long getSizeRootFs(){
            return this.sizeRootFs;
    }

    public A withSizeRootFs(Long sizeRootFs){
            this.sizeRootFs=sizeRootFs; return (A) this;
    }

    public Boolean hasSizeRootFs(){
            return this.sizeRootFs!=null;
    }

    public A addToLabels(String key,String value){
            if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(key != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.labels.remove(key);}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.labels;
    }

    public A withLabels(Map<String,String> labels){
            this.labels.clear();
            if (labels != null) {this.labels.putAll(labels);} return (A) this;
    }

    public Boolean hasLabels(){
            return this.labels!=null;
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status!=null;
    }

    
/**
 * This method has been deprecated, please use method buildHostConfig instead.
 */
@Deprecated public ContainerHostConfig getHostConfig(){
            return this.hostConfig!=null?this.hostConfig.build():null;
    }

    public ContainerHostConfig buildHostConfig(){
            return this.hostConfig!=null?this.hostConfig.build():null;
    }

    public A withHostConfig(ContainerHostConfig hostConfig){
            _visitables.remove(this.hostConfig);
            if (hostConfig!=null){ this.hostConfig= new ContainerHostConfigBuilder(hostConfig); _visitables.add(this.hostConfig);} return (A) this;
    }

    public Boolean hasHostConfig(){
            return this.hostConfig!=null;
    }

    public ContainerFluent.HostConfigNested<A> withNewHostConfig(){
            return new HostConfigNestedImpl();
    }

    public ContainerFluent.HostConfigNested<A> withNewHostConfigLike(ContainerHostConfig item){
            return new HostConfigNestedImpl(item);
    }

    public ContainerFluent.HostConfigNested<A> editHostConfig(){
            return withNewHostConfigLike(getHostConfig());
    }

    public ContainerFluent.HostConfigNested<A> editOrNewHostConfig(){
            return withNewHostConfigLike(getHostConfig() != null ? getHostConfig(): new ContainerHostConfigBuilder().build());
    }

    public ContainerFluent.HostConfigNested<A> editOrNewHostConfigLike(ContainerHostConfig item){
            return withNewHostConfigLike(getHostConfig() != null ? getHostConfig(): item);
    }

    public A withNewHostConfig(String networkMode){
            return (A)withHostConfig(new ContainerHostConfig(networkMode));
    }

    
/**
 * This method has been deprecated, please use method buildSummaryNetworkSettings instead.
 */
@Deprecated public NetworkSettings getSummaryNetworkSettings(){
            return this.summaryNetworkSettings!=null?this.summaryNetworkSettings.build():null;
    }

    public NetworkSettings buildSummaryNetworkSettings(){
            return this.summaryNetworkSettings!=null?this.summaryNetworkSettings.build():null;
    }

    public A withSummaryNetworkSettings(NetworkSettings summaryNetworkSettings){
            _visitables.remove(this.summaryNetworkSettings);
            if (summaryNetworkSettings!=null){ this.summaryNetworkSettings= new NetworkSettingsBuilder(summaryNetworkSettings); _visitables.add(this.summaryNetworkSettings);} return (A) this;
    }

    public Boolean hasSummaryNetworkSettings(){
            return this.summaryNetworkSettings!=null;
    }

    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettings(){
            return new SummaryNetworkSettingsNestedImpl();
    }

    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettingsLike(NetworkSettings item){
            return new SummaryNetworkSettingsNestedImpl(item);
    }

    public ContainerFluent.SummaryNetworkSettingsNested<A> editSummaryNetworkSettings(){
            return withNewSummaryNetworkSettingsLike(getSummaryNetworkSettings());
    }

    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettings(){
            return withNewSummaryNetworkSettingsLike(getSummaryNetworkSettings() != null ? getSummaryNetworkSettings(): new NetworkSettingsBuilder().build());
    }

    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettingsLike(NetworkSettings item){
            return withNewSummaryNetworkSettingsLike(getSummaryNetworkSettings() != null ? getSummaryNetworkSettings(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerFluentImpl that = (ContainerFluentImpl) o;
            if (id != null ? !id.equals(that.id) :that.id != null) return false;
            if (names != null ? !names.equals(that.names) :that.names != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (imageId != null ? !imageId.equals(that.imageId) :that.imageId != null) return false;
            if (command != null ? !command.equals(that.command) :that.command != null) return false;
            if (created != null ? !created.equals(that.created) :that.created != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            if (sizeRw != null ? !sizeRw.equals(that.sizeRw) :that.sizeRw != null) return false;
            if (sizeRootFs != null ? !sizeRootFs.equals(that.sizeRootFs) :that.sizeRootFs != null) return false;
            if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (hostConfig != null ? !hostConfig.equals(that.hostConfig) :that.hostConfig != null) return false;
            if (summaryNetworkSettings != null ? !summaryNetworkSettings.equals(that.summaryNetworkSettings) :that.summaryNetworkSettings != null) return false;
            return true;
    }


    public class PortsNestedImpl<N> extends PortFluentImpl<ContainerFluent.PortsNested<N>> implements ContainerFluent.PortsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final PortBuilder builder;
        private final int index;
    
            PortsNestedImpl(int index,Port item){
                    this.index = index;
                    this.builder = new PortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.index = -1;
                    this.builder = new PortBuilder(this);
            }
    
    public N and(){
            return (N) ContainerFluentImpl.this.setToPorts(index, builder.build());
    }
    public N endPort(){
            return and();
    }

}
    public class HostConfigNestedImpl<N> extends ContainerHostConfigFluentImpl<ContainerFluent.HostConfigNested<N>> implements ContainerFluent.HostConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerHostConfigBuilder builder;
    
            HostConfigNestedImpl(ContainerHostConfig item){
                    this.builder = new ContainerHostConfigBuilder(this, item);
            }
            HostConfigNestedImpl(){
                    this.builder = new ContainerHostConfigBuilder(this);
            }
    
    public N and(){
            return (N) ContainerFluentImpl.this.withHostConfig(builder.build());
    }
    public N endHostConfig(){
            return and();
    }

}
    public class SummaryNetworkSettingsNestedImpl<N> extends NetworkSettingsFluentImpl<ContainerFluent.SummaryNetworkSettingsNested<N>> implements ContainerFluent.SummaryNetworkSettingsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkSettingsBuilder builder;
    
            SummaryNetworkSettingsNestedImpl(NetworkSettings item){
                    this.builder = new NetworkSettingsBuilder(this, item);
            }
            SummaryNetworkSettingsNestedImpl(){
                    this.builder = new NetworkSettingsBuilder(this);
            }
    
    public N and(){
            return (N) ContainerFluentImpl.this.withSummaryNetworkSettings(builder.build());
    }
    public N endSummaryNetworkSettings(){
            return and();
    }

}


}
