package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.util.Map;

public interface ContainerFluent<A extends ContainerFluent<A>> extends Fluent<A>{


    public String getId();
    public A withId(String id);
    public Boolean hasId();
    public A addToNames(int index,String item);
    public A setToNames(int index,String item);
    public A addToNames(String... items);
    public A addAllToNames(Collection<String> items);
    public A removeFromNames(String... items);
    public A removeAllFromNames(Collection<String> items);
    public List<String> getNames();
    public String getName(int index);
    public String getFirstName();
    public String getLastName();
    public String getMatchingName(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withNames(List<String> names);
    public A withNames(String... names);
    public Boolean hasNames();
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public String getImageId();
    public A withImageId(String imageId);
    public Boolean hasImageId();
    public String getCommand();
    public A withCommand(String command);
    public Boolean hasCommand();
    public Long getCreated();
    public A withCreated(Long created);
    public Boolean hasCreated();
    public A addToPorts(int index,Port item);
    public A setToPorts(int index,Port item);
    public A addToPorts(Port... items);
    public A addAllToPorts(Collection<Port> items);
    public A removeFromPorts(Port... items);
    public A removeAllFromPorts(Collection<Port> items);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 */
@Deprecated public List<Port> getPorts();
    public List<Port> buildPorts();
    public Port buildPort(int index);
    public Port buildFirstPort();
    public Port buildLastPort();
    public Port buildMatchingPort(io.fabric8.docker.api.builder.Predicate<PortBuilder> predicate);
    public A withPorts(List<Port> ports);
    public A withPorts(Port... ports);
    public Boolean hasPorts();
    public ContainerFluent.PortsNested<A> addNewPort();
    public ContainerFluent.PortsNested<A> addNewPortLike(Port item);
    public ContainerFluent.PortsNested<A> setNewPortLike(int index,Port item);
    public ContainerFluent.PortsNested<A> editPort(int index);
    public ContainerFluent.PortsNested<A> editFirstPort();
    public ContainerFluent.PortsNested<A> editLastPort();
    public ContainerFluent.PortsNested<A> editMatchingPort(io.fabric8.docker.api.builder.Predicate<PortBuilder> predicate);
    public A addNewPort(String IP,Integer PrivatePort,Integer PublicPort,String Type);
    public Long getSizeRw();
    public A withSizeRw(Long sizeRw);
    public Boolean hasSizeRw();
    public Long getSizeRootFs();
    public A withSizeRootFs(Long sizeRootFs);
    public Boolean hasSizeRootFs();
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public String getStatus();
    public A withStatus(String status);
    public Boolean hasStatus();
    
/**
 * This method has been deprecated, please use method buildHostConfig instead.
 */
@Deprecated public ContainerHostConfig getHostConfig();
    public ContainerHostConfig buildHostConfig();
    public A withHostConfig(ContainerHostConfig hostConfig);
    public Boolean hasHostConfig();
    public ContainerFluent.HostConfigNested<A> withNewHostConfig();
    public ContainerFluent.HostConfigNested<A> withNewHostConfigLike(ContainerHostConfig item);
    public ContainerFluent.HostConfigNested<A> editHostConfig();
    public ContainerFluent.HostConfigNested<A> editOrNewHostConfig();
    public ContainerFluent.HostConfigNested<A> editOrNewHostConfigLike(ContainerHostConfig item);
    public A withNewHostConfig(String networkMode);
    
/**
 * This method has been deprecated, please use method buildSummaryNetworkSettings instead.
 */
@Deprecated public NetworkSettings getSummaryNetworkSettings();
    public NetworkSettings buildSummaryNetworkSettings();
    public A withSummaryNetworkSettings(NetworkSettings summaryNetworkSettings);
    public Boolean hasSummaryNetworkSettings();
    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettings();
    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettingsLike(NetworkSettings item);
    public ContainerFluent.SummaryNetworkSettingsNested<A> editSummaryNetworkSettings();
    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettings();
    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettingsLike(NetworkSettings item);

    public interface PortsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,PortFluent<ContainerFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}
    public interface HostConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerHostConfigFluent<ContainerFluent.HostConfigNested<N>>{

        
    public N and();    public N endHostConfig();
}
    public interface SummaryNetworkSettingsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetworkSettingsFluent<ContainerFluent.SummaryNetworkSettingsNested<N>>{

        
    public N and();    public N endSummaryNetworkSettings();
}


}
