package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ContainerCreateResponseFluentImpl<A extends ContainerCreateResponseFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ContainerCreateResponseFluent<A>{

    private String Id;
    private List<String> Warnings = new ArrayList<String>();

    public ContainerCreateResponseFluentImpl(){
    }
    public ContainerCreateResponseFluentImpl(ContainerCreateResponse instance){
            this.withId(instance.getId()); 
            this.withWarnings(instance.getWarnings()); 
    }

    public String getId(){
            return this.Id;
    }

    public A withId(String Id){
            this.Id=Id; return (A) this;
    }

    public Boolean hasId(){
            return this.Id!=null;
    }

    public A addToWarnings(int index,String item){
            this.Warnings.add(index, item); return (A)this;
    }

    public A setToWarnings(int index,String item){
            this.Warnings.set(index, item); return (A)this;
    }

    public A addToWarnings(String... items){
            for (String item : items) {this.Warnings.add(item);} return (A)this;
    }

    public A addAllToWarnings(Collection<String> items){
            for (String item : items) {this.Warnings.add(item);} return (A)this;
    }

    public A removeFromWarnings(String... items){
            for (String item : items) {this.Warnings.remove(item);} return (A)this;
    }

    public A removeAllFromWarnings(Collection<String> items){
            for (String item : items) {this.Warnings.remove(item);} return (A)this;
    }

    public List<String> getWarnings(){
            return this.Warnings;
    }

    public String getWarning(int index){
            return this.Warnings.get(index);
    }

    public String getFirstWarning(){
            return this.Warnings.get(0);
    }

    public String getLastWarning(){
            return this.Warnings.get(Warnings.size() - 1);
    }

    public String getMatchingWarning(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Warnings) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withWarnings(List<String> Warnings){
            this.Warnings.clear();
            if (Warnings != null) {for (String item : Warnings){this.addToWarnings(item);}} return (A) this;
    }

    public A withWarnings(String... Warnings){
            this.Warnings.clear(); if (Warnings != null) {for (String item :Warnings){ this.addToWarnings(item);}} return (A) this;
    }

    public Boolean hasWarnings(){
            return Warnings!= null && !Warnings.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerCreateResponseFluentImpl that = (ContainerCreateResponseFluentImpl) o;
            if (Id != null ? !Id.equals(that.Id) :that.Id != null) return false;
            if (Warnings != null ? !Warnings.equals(that.Warnings) :that.Warnings != null) return false;
            return true;
    }




}
