package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ContainerCreateRequestFluent<A extends ContainerCreateRequestFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public String getDomainname();
    public A withDomainname(String domainname);
    public Boolean hasDomainname();
    public String getUser();
    public A withUser(String user);
    public Boolean hasUser();
    public String getMemory();
    public A withMemory(String memory);
    public Boolean hasMemory();
    public String getMemorySwap();
    public A withMemorySwap(String memorySwap);
    public Boolean hasMemorySwap();
    public String getMemoryReservation();
    public A withMemoryReservation(String memoryReservation);
    public Boolean hasMemoryReservation();
    public String getKernelMemory();
    public A withKernelMemory(String kernelMemory);
    public Boolean hasKernelMemory();
    public String getCpuShares();
    public A withCpuShares(String cpuShares);
    public Boolean hasCpuShares();
    public String getCpuPeriod();
    public A withCpuPeriod(String cpuPeriod);
    public Boolean hasCpuPeriod();
    public String getCpuQuota();
    public A withCpuQuota(String cpuQuota);
    public Boolean hasCpuQuota();
    public String getCpuset();
    public A withCpuset(String cpuset);
    public Boolean hasCpuset();
    public String getCpusetCpus();
    public A withCpusetCpus(String cpusetCpus);
    public Boolean hasCpusetCpus();
    public String getCpusetMems();
    public A withCpusetMems(String cpusetMems);
    public Boolean hasCpusetMems();
    public Integer getBlkioWeight();
    public A withBlkioWeight(Integer blkioWeight);
    public Boolean hasBlkioWeight();
    public Integer getMemorySwappiness();
    public A withMemorySwappiness(Integer memorySwappiness);
    public Boolean hasMemorySwappiness();
    public Boolean isOomKillDisable();
    public A withOomKillDisable(Boolean oomKillDisable);
    public Boolean hasOomKillDisable();
    public Boolean isAttachStdin();
    public A withAttachStdin(Boolean attachStdin);
    public Boolean hasAttachStdin();
    public Boolean isAttachStdout();
    public A withAttachStdout(Boolean attachStdout);
    public Boolean hasAttachStdout();
    public Boolean isAttachStderr();
    public A withAttachStderr(Boolean attachStderr);
    public Boolean hasAttachStderr();
    public Boolean isTty();
    public A withTty(Boolean tty);
    public Boolean hasTty();
    public Boolean isOpenStdin();
    public A withOpenStdin(Boolean openStdin);
    public Boolean hasOpenStdin();
    public Boolean isStdinOnce();
    public A withStdinOnce(Boolean stdinOnce);
    public Boolean hasStdinOnce();
    public A addToEnv(String key,String value);
    public A addToEnv(Map<String,String> map);
    public A removeFromEnv(String key);
    public A removeFromEnv(Map<String,String> map);
    public Map<String,String> getEnv();
    public A withEnv(Map<String,String> env);
    public Boolean hasEnv();
    public A addToCmd(int index,String item);
    public A setToCmd(int index,String item);
    public A addToCmd(String... items);
    public A addAllToCmd(Collection<String> items);
    public A removeFromCmd(String... items);
    public A removeAllFromCmd(Collection<String> items);
    public List<String> getCmd();
    public String getCmd(int index);
    public String getFirstCmd();
    public String getLastCmd();
    public String getMatchingCmd(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withCmd(List<String> cmd);
    public A withCmd(String... cmd);
    public Boolean hasCmd();
    public String getEntrypoint();
    public A withEntrypoint(String entrypoint);
    public Boolean hasEntrypoint();
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public A addToVolumes(String key,Object value);
    public A addToVolumes(Map<String,Object> map);
    public A removeFromVolumes(String key);
    public A removeFromVolumes(Map<String,Object> map);
    public Map<String,Object> getVolumes();
    public A withVolumes(Map<String,Object> volumes);
    public Boolean hasVolumes();
    public String getWorkingDir();
    public A withWorkingDir(String workingDir);
    public Boolean hasWorkingDir();
    public Boolean isNetworkDisabled();
    public A withNetworkDisabled(Boolean networkDisabled);
    public Boolean hasNetworkDisabled();
    public String getMacAddress();
    public A withMacAddress(String macAddress);
    public Boolean hasMacAddress();
    public A addToExposedPorts(Integer key,Protocol value);
    public A addToExposedPorts(Map<Integer,Protocol> map);
    public A removeFromExposedPorts(Integer key);
    public A removeFromExposedPorts(Map<Integer,Protocol> map);
    public Map<Integer,Protocol> getExposedPorts();
    public A withExposedPorts(Map<Integer,Protocol> exposedPorts);
    public Boolean hasExposedPorts();
    public String getStopSignal();
    public A withStopSignal(String stopSignal);
    public Boolean hasStopSignal();
    
/**
 * This method has been deprecated, please use method buildHostConfig instead.
 */
@Deprecated public HostConfig getHostConfig();
    public HostConfig buildHostConfig();
    public A withHostConfig(HostConfig hostConfig);
    public Boolean hasHostConfig();
    public ContainerCreateRequestFluent.HostConfigNested<A> withNewHostConfig();
    public ContainerCreateRequestFluent.HostConfigNested<A> withNewHostConfigLike(HostConfig item);
    public ContainerCreateRequestFluent.HostConfigNested<A> editHostConfig();
    public ContainerCreateRequestFluent.HostConfigNested<A> editOrNewHostConfig();
    public ContainerCreateRequestFluent.HostConfigNested<A> editOrNewHostConfigLike(HostConfig item);
    public String getIpv4Address();
    public A withIpv4Address(String ipv4Address);
    public Boolean hasIpv4Address();
    public String getIpv6Address();
    public A withIpv6Address(String ipv6Address);
    public Boolean hasIpv6Address();

    public interface HostConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,HostConfigFluent<ContainerCreateRequestFluent.HostConfigNested<N>>{

        
    public N and();    public N endHostConfig();
}


}
