package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerBuilder extends ContainerFluentImpl<ContainerBuilder> implements VisitableBuilder<Container,ContainerBuilder>{

    ContainerFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerBuilder(){
            this(true);
    }
    public ContainerBuilder(Boolean validationEnabled){
            this(new Container(), validationEnabled);
    }
    public ContainerBuilder(ContainerFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerBuilder(ContainerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Container(), validationEnabled);
    }
    public ContainerBuilder(ContainerFluent<?> fluent,Container instance){
            this(fluent, instance, true);
    }
    public ContainerBuilder(ContainerFluent<?> fluent,Container instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withId(instance.getId()); 
            fluent.withNames(instance.getNames()); 
            fluent.withImage(instance.getImage()); 
            fluent.withImageId(instance.getImageId()); 
            fluent.withCommand(instance.getCommand()); 
            fluent.withCreated(instance.getCreated()); 
            fluent.withPorts(instance.getPorts()); 
            fluent.withSizeRw(instance.getSizeRw()); 
            fluent.withSizeRootFs(instance.getSizeRootFs()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withHostConfig(instance.getHostConfig()); 
            fluent.withSummaryNetworkSettings(instance.getSummaryNetworkSettings()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerBuilder(Container instance){
            this(instance,true);
    }
    public ContainerBuilder(Container instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withId(instance.getId()); 
            this.withNames(instance.getNames()); 
            this.withImage(instance.getImage()); 
            this.withImageId(instance.getImageId()); 
            this.withCommand(instance.getCommand()); 
            this.withCreated(instance.getCreated()); 
            this.withPorts(instance.getPorts()); 
            this.withSizeRw(instance.getSizeRw()); 
            this.withSizeRootFs(instance.getSizeRootFs()); 
            this.withLabels(instance.getLabels()); 
            this.withStatus(instance.getStatus()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.withSummaryNetworkSettings(instance.getSummaryNetworkSettings()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainer build(){
            EditableContainer buildable = new EditableContainer(fluent.getId(),fluent.getNames(),fluent.getImage(),fluent.getImageId(),fluent.getCommand(),fluent.getCreated(),fluent.getPorts(),fluent.getSizeRw(),fluent.getSizeRootFs(),fluent.getLabels(),fluent.getStatus(),fluent.getHostConfig(),fluent.getSummaryNetworkSettings());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerBuilder that = (ContainerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
