package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.util.LinkedHashMap;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class ConfigFluentImpl<A extends ConfigFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ConfigFluent<A>{

    private Boolean AttachStderr;
    private Boolean AttachStdin;
    private Boolean AttachStdout;
    private List<String> Cmd = new ArrayList<String>();
    private String Domainname;
    private List<String> Entrypoint = new ArrayList<String>();
    private List<String> Env = new ArrayList<String>();
    private Map<String,Object> ExposedPorts = new LinkedHashMap<String,Object>();
    private String Hostname;
    private String Image;
    private Map<String,String> Labels = new LinkedHashMap<String,String>();
    private String MacAddress;
    private Boolean NetworkDisabled;
    private List<String> OnBuild = new ArrayList<String>();
    private Boolean OpenStdin;
    private String PublishService;
    private Boolean StdinOnce;
    private String StopSignal;
    private Boolean Tty;
    private String User;
    private Map<String,Object> Volumes = new LinkedHashMap<String,Object>();
    private String WorkingDir;

    public ConfigFluentImpl(){
    }
    public ConfigFluentImpl(Config instance){
            this.withAttachStderr(instance.getAttachStderr()); 
            this.withAttachStdin(instance.getAttachStdin()); 
            this.withAttachStdout(instance.getAttachStdout()); 
            this.withCmd(instance.getCmd()); 
            this.withDomainname(instance.getDomainname()); 
            this.withEntrypoint(instance.getEntrypoint()); 
            this.withEnv(instance.getEnv()); 
            this.withExposedPorts(instance.getExposedPorts()); 
            this.withHostname(instance.getHostname()); 
            this.withImage(instance.getImage()); 
            this.withLabels(instance.getLabels()); 
            this.withMacAddress(instance.getMacAddress()); 
            this.withNetworkDisabled(instance.getNetworkDisabled()); 
            this.withOnBuild(instance.getOnBuild()); 
            this.withOpenStdin(instance.getOpenStdin()); 
            this.withPublishService(instance.getPublishService()); 
            this.withStdinOnce(instance.getStdinOnce()); 
            this.withStopSignal(instance.getStopSignal()); 
            this.withTty(instance.getTty()); 
            this.withUser(instance.getUser()); 
            this.withVolumes(instance.getVolumes()); 
            this.withWorkingDir(instance.getWorkingDir()); 
    }

    public Boolean isAttachStderr(){
            return this.AttachStderr;
    }

    public A withAttachStderr(Boolean AttachStderr){
            this.AttachStderr=AttachStderr; return (A) this;
    }

    public Boolean hasAttachStderr(){
            return this.AttachStderr!=null;
    }

    public Boolean isAttachStdin(){
            return this.AttachStdin;
    }

    public A withAttachStdin(Boolean AttachStdin){
            this.AttachStdin=AttachStdin; return (A) this;
    }

    public Boolean hasAttachStdin(){
            return this.AttachStdin!=null;
    }

    public Boolean isAttachStdout(){
            return this.AttachStdout;
    }

    public A withAttachStdout(Boolean AttachStdout){
            this.AttachStdout=AttachStdout; return (A) this;
    }

    public Boolean hasAttachStdout(){
            return this.AttachStdout!=null;
    }

    public A addToCmd(int index,String item){
            this.Cmd.add(index, item); return (A)this;
    }

    public A setToCmd(int index,String item){
            this.Cmd.set(index, item); return (A)this;
    }

    public A addToCmd(String... items){
            for (String item : items) {this.Cmd.add(item);} return (A)this;
    }

    public A addAllToCmd(Collection<String> items){
            for (String item : items) {this.Cmd.add(item);} return (A)this;
    }

    public A removeFromCmd(String... items){
            for (String item : items) {this.Cmd.remove(item);} return (A)this;
    }

    public A removeAllFromCmd(Collection<String> items){
            for (String item : items) {this.Cmd.remove(item);} return (A)this;
    }

    public List<String> getCmd(){
            return this.Cmd;
    }

    public String getCmd(int index){
            return this.Cmd.get(index);
    }

    public String getFirstCmd(){
            return this.Cmd.get(0);
    }

    public String getLastCmd(){
            return this.Cmd.get(Cmd.size() - 1);
    }

    public String getMatchingCmd(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Cmd) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withCmd(List<String> Cmd){
            this.Cmd.clear();
            if (Cmd != null) {for (String item : Cmd){this.addToCmd(item);}} return (A) this;
    }

    public A withCmd(String... Cmd){
            this.Cmd.clear(); if (Cmd != null) {for (String item :Cmd){ this.addToCmd(item);}} return (A) this;
    }

    public Boolean hasCmd(){
            return Cmd!= null && !Cmd.isEmpty();
    }

    public String getDomainname(){
            return this.Domainname;
    }

    public A withDomainname(String Domainname){
            this.Domainname=Domainname; return (A) this;
    }

    public Boolean hasDomainname(){
            return this.Domainname!=null;
    }

    public A addToEntrypoint(int index,String item){
            this.Entrypoint.add(index, item); return (A)this;
    }

    public A setToEntrypoint(int index,String item){
            this.Entrypoint.set(index, item); return (A)this;
    }

    public A addToEntrypoint(String... items){
            for (String item : items) {this.Entrypoint.add(item);} return (A)this;
    }

    public A addAllToEntrypoint(Collection<String> items){
            for (String item : items) {this.Entrypoint.add(item);} return (A)this;
    }

    public A removeFromEntrypoint(String... items){
            for (String item : items) {this.Entrypoint.remove(item);} return (A)this;
    }

    public A removeAllFromEntrypoint(Collection<String> items){
            for (String item : items) {this.Entrypoint.remove(item);} return (A)this;
    }

    public List<String> getEntrypoint(){
            return this.Entrypoint;
    }

    public String getEntrypoint(int index){
            return this.Entrypoint.get(index);
    }

    public String getFirstEntrypoint(){
            return this.Entrypoint.get(0);
    }

    public String getLastEntrypoint(){
            return this.Entrypoint.get(Entrypoint.size() - 1);
    }

    public String getMatchingEntrypoint(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Entrypoint) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withEntrypoint(List<String> Entrypoint){
            this.Entrypoint.clear();
            if (Entrypoint != null) {for (String item : Entrypoint){this.addToEntrypoint(item);}} return (A) this;
    }

    public A withEntrypoint(String... Entrypoint){
            this.Entrypoint.clear(); if (Entrypoint != null) {for (String item :Entrypoint){ this.addToEntrypoint(item);}} return (A) this;
    }

    public Boolean hasEntrypoint(){
            return Entrypoint!= null && !Entrypoint.isEmpty();
    }

    public A addToEnv(int index,String item){
            this.Env.add(index, item); return (A)this;
    }

    public A setToEnv(int index,String item){
            this.Env.set(index, item); return (A)this;
    }

    public A addToEnv(String... items){
            for (String item : items) {this.Env.add(item);} return (A)this;
    }

    public A addAllToEnv(Collection<String> items){
            for (String item : items) {this.Env.add(item);} return (A)this;
    }

    public A removeFromEnv(String... items){
            for (String item : items) {this.Env.remove(item);} return (A)this;
    }

    public A removeAllFromEnv(Collection<String> items){
            for (String item : items) {this.Env.remove(item);} return (A)this;
    }

    public List<String> getEnv(){
            return this.Env;
    }

    public String getEnv(int index){
            return this.Env.get(index);
    }

    public String getFirstEnv(){
            return this.Env.get(0);
    }

    public String getLastEnv(){
            return this.Env.get(Env.size() - 1);
    }

    public String getMatchingEnv(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Env) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withEnv(List<String> Env){
            this.Env.clear();
            if (Env != null) {for (String item : Env){this.addToEnv(item);}} return (A) this;
    }

    public A withEnv(String... Env){
            this.Env.clear(); if (Env != null) {for (String item :Env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv(){
            return Env!= null && !Env.isEmpty();
    }

    public A addToExposedPorts(String key,Object value){
            if(key != null && value != null) {this.ExposedPorts.put(key, value);} return (A)this;
    }

    public A addToExposedPorts(Map<String,Object> map){
            if(map != null) { this.ExposedPorts.putAll(map);} return (A)this;
    }

    public A removeFromExposedPorts(String key){
            if(key != null) {this.ExposedPorts.remove(key);} return (A)this;
    }

    public A removeFromExposedPorts(Map<String,Object> map){
            if(map != null) { for(Object key : map.keySet()) {this.ExposedPorts.remove(key);}} return (A)this;
    }

    public Map<String,Object> getExposedPorts(){
            return this.ExposedPorts;
    }

    public A withExposedPorts(Map<String,Object> ExposedPorts){
            this.ExposedPorts.clear();
            if (ExposedPorts != null) {this.ExposedPorts.putAll(ExposedPorts);} return (A) this;
    }

    public Boolean hasExposedPorts(){
            return this.ExposedPorts!=null;
    }

    public String getHostname(){
            return this.Hostname;
    }

    public A withHostname(String Hostname){
            this.Hostname=Hostname; return (A) this;
    }

    public Boolean hasHostname(){
            return this.Hostname!=null;
    }

    public String getImage(){
            return this.Image;
    }

    public A withImage(String Image){
            this.Image=Image; return (A) this;
    }

    public Boolean hasImage(){
            return this.Image!=null;
    }

    public A addToLabels(String key,String value){
            if(key != null && value != null) {this.Labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(map != null) { this.Labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(key != null) {this.Labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.Labels.remove(key);}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.Labels;
    }

    public A withLabels(Map<String,String> Labels){
            this.Labels.clear();
            if (Labels != null) {this.Labels.putAll(Labels);} return (A) this;
    }

    public Boolean hasLabels(){
            return this.Labels!=null;
    }

    public String getMacAddress(){
            return this.MacAddress;
    }

    public A withMacAddress(String MacAddress){
            this.MacAddress=MacAddress; return (A) this;
    }

    public Boolean hasMacAddress(){
            return this.MacAddress!=null;
    }

    public Boolean isNetworkDisabled(){
            return this.NetworkDisabled;
    }

    public A withNetworkDisabled(Boolean NetworkDisabled){
            this.NetworkDisabled=NetworkDisabled; return (A) this;
    }

    public Boolean hasNetworkDisabled(){
            return this.NetworkDisabled!=null;
    }

    public A addToOnBuild(int index,String item){
            this.OnBuild.add(index, item); return (A)this;
    }

    public A setToOnBuild(int index,String item){
            this.OnBuild.set(index, item); return (A)this;
    }

    public A addToOnBuild(String... items){
            for (String item : items) {this.OnBuild.add(item);} return (A)this;
    }

    public A addAllToOnBuild(Collection<String> items){
            for (String item : items) {this.OnBuild.add(item);} return (A)this;
    }

    public A removeFromOnBuild(String... items){
            for (String item : items) {this.OnBuild.remove(item);} return (A)this;
    }

    public A removeAllFromOnBuild(Collection<String> items){
            for (String item : items) {this.OnBuild.remove(item);} return (A)this;
    }

    public List<String> getOnBuild(){
            return this.OnBuild;
    }

    public String getOnBuild(int index){
            return this.OnBuild.get(index);
    }

    public String getFirstOnBuild(){
            return this.OnBuild.get(0);
    }

    public String getLastOnBuild(){
            return this.OnBuild.get(OnBuild.size() - 1);
    }

    public String getMatchingOnBuild(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: OnBuild) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withOnBuild(List<String> OnBuild){
            this.OnBuild.clear();
            if (OnBuild != null) {for (String item : OnBuild){this.addToOnBuild(item);}} return (A) this;
    }

    public A withOnBuild(String... OnBuild){
            this.OnBuild.clear(); if (OnBuild != null) {for (String item :OnBuild){ this.addToOnBuild(item);}} return (A) this;
    }

    public Boolean hasOnBuild(){
            return OnBuild!= null && !OnBuild.isEmpty();
    }

    public Boolean isOpenStdin(){
            return this.OpenStdin;
    }

    public A withOpenStdin(Boolean OpenStdin){
            this.OpenStdin=OpenStdin; return (A) this;
    }

    public Boolean hasOpenStdin(){
            return this.OpenStdin!=null;
    }

    public String getPublishService(){
            return this.PublishService;
    }

    public A withPublishService(String PublishService){
            this.PublishService=PublishService; return (A) this;
    }

    public Boolean hasPublishService(){
            return this.PublishService!=null;
    }

    public Boolean isStdinOnce(){
            return this.StdinOnce;
    }

    public A withStdinOnce(Boolean StdinOnce){
            this.StdinOnce=StdinOnce; return (A) this;
    }

    public Boolean hasStdinOnce(){
            return this.StdinOnce!=null;
    }

    public String getStopSignal(){
            return this.StopSignal;
    }

    public A withStopSignal(String StopSignal){
            this.StopSignal=StopSignal; return (A) this;
    }

    public Boolean hasStopSignal(){
            return this.StopSignal!=null;
    }

    public Boolean isTty(){
            return this.Tty;
    }

    public A withTty(Boolean Tty){
            this.Tty=Tty; return (A) this;
    }

    public Boolean hasTty(){
            return this.Tty!=null;
    }

    public String getUser(){
            return this.User;
    }

    public A withUser(String User){
            this.User=User; return (A) this;
    }

    public Boolean hasUser(){
            return this.User!=null;
    }

    public A addToVolumes(String key,Object value){
            if(key != null && value != null) {this.Volumes.put(key, value);} return (A)this;
    }

    public A addToVolumes(Map<String,Object> map){
            if(map != null) { this.Volumes.putAll(map);} return (A)this;
    }

    public A removeFromVolumes(String key){
            if(key != null) {this.Volumes.remove(key);} return (A)this;
    }

    public A removeFromVolumes(Map<String,Object> map){
            if(map != null) { for(Object key : map.keySet()) {this.Volumes.remove(key);}} return (A)this;
    }

    public Map<String,Object> getVolumes(){
            return this.Volumes;
    }

    public A withVolumes(Map<String,Object> Volumes){
            this.Volumes.clear();
            if (Volumes != null) {this.Volumes.putAll(Volumes);} return (A) this;
    }

    public Boolean hasVolumes(){
            return this.Volumes!=null;
    }

    public String getWorkingDir(){
            return this.WorkingDir;
    }

    public A withWorkingDir(String WorkingDir){
            this.WorkingDir=WorkingDir; return (A) this;
    }

    public Boolean hasWorkingDir(){
            return this.WorkingDir!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigFluentImpl that = (ConfigFluentImpl) o;
            if (AttachStderr != null ? !AttachStderr.equals(that.AttachStderr) :that.AttachStderr != null) return false;
            if (AttachStdin != null ? !AttachStdin.equals(that.AttachStdin) :that.AttachStdin != null) return false;
            if (AttachStdout != null ? !AttachStdout.equals(that.AttachStdout) :that.AttachStdout != null) return false;
            if (Cmd != null ? !Cmd.equals(that.Cmd) :that.Cmd != null) return false;
            if (Domainname != null ? !Domainname.equals(that.Domainname) :that.Domainname != null) return false;
            if (Entrypoint != null ? !Entrypoint.equals(that.Entrypoint) :that.Entrypoint != null) return false;
            if (Env != null ? !Env.equals(that.Env) :that.Env != null) return false;
            if (ExposedPorts != null ? !ExposedPorts.equals(that.ExposedPorts) :that.ExposedPorts != null) return false;
            if (Hostname != null ? !Hostname.equals(that.Hostname) :that.Hostname != null) return false;
            if (Image != null ? !Image.equals(that.Image) :that.Image != null) return false;
            if (Labels != null ? !Labels.equals(that.Labels) :that.Labels != null) return false;
            if (MacAddress != null ? !MacAddress.equals(that.MacAddress) :that.MacAddress != null) return false;
            if (NetworkDisabled != null ? !NetworkDisabled.equals(that.NetworkDisabled) :that.NetworkDisabled != null) return false;
            if (OnBuild != null ? !OnBuild.equals(that.OnBuild) :that.OnBuild != null) return false;
            if (OpenStdin != null ? !OpenStdin.equals(that.OpenStdin) :that.OpenStdin != null) return false;
            if (PublishService != null ? !PublishService.equals(that.PublishService) :that.PublishService != null) return false;
            if (StdinOnce != null ? !StdinOnce.equals(that.StdinOnce) :that.StdinOnce != null) return false;
            if (StopSignal != null ? !StopSignal.equals(that.StopSignal) :that.StopSignal != null) return false;
            if (Tty != null ? !Tty.equals(that.Tty) :that.Tty != null) return false;
            if (User != null ? !User.equals(that.User) :that.User != null) return false;
            if (Volumes != null ? !Volumes.equals(that.Volumes) :that.Volumes != null) return false;
            if (WorkingDir != null ? !WorkingDir.equals(that.WorkingDir) :that.WorkingDir != null) return false;
            return true;
    }




}
