package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import io.fabric8.docker.api.builder.Predicate;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CPUUsageFluentImpl<A extends CPUUsageFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements CPUUsageFluent<A>{

    private List<Long> percpuUsage = new ArrayList<Long>();
    private Long totalUsage;
    private Long usageInKernelmode;
    private Long usageInUsermode;

    public CPUUsageFluentImpl(){
    }
    public CPUUsageFluentImpl(CPUUsage instance){
            this.withPercpuUsage(instance.getPercpuUsage()); 
            this.withTotalUsage(instance.getTotalUsage()); 
            this.withUsageInKernelmode(instance.getUsageInKernelmode()); 
            this.withUsageInUsermode(instance.getUsageInUsermode()); 
    }

    public A addToPercpuUsage(int index,Long item){
            this.percpuUsage.add(index, item); return (A)this;
    }

    public A setToPercpuUsage(int index,Long item){
            this.percpuUsage.set(index, item); return (A)this;
    }

    public A addToPercpuUsage(Long... items){
            for (Long item : items) {this.percpuUsage.add(item);} return (A)this;
    }

    public A addAllToPercpuUsage(Collection<Long> items){
            for (Long item : items) {this.percpuUsage.add(item);} return (A)this;
    }

    public A removeFromPercpuUsage(Long... items){
            for (Long item : items) {this.percpuUsage.remove(item);} return (A)this;
    }

    public A removeAllFromPercpuUsage(Collection<Long> items){
            for (Long item : items) {this.percpuUsage.remove(item);} return (A)this;
    }

    public List<Long> getPercpuUsage(){
            return this.percpuUsage;
    }

    public Long getPercpuUsage(int index){
            return this.percpuUsage.get(index);
    }

    public Long getFirstPercpuUsage(){
            return this.percpuUsage.get(0);
    }

    public Long getLastPercpuUsage(){
            return this.percpuUsage.get(percpuUsage.size() - 1);
    }

    public Long getMatchingPercpuUsage(io.fabric8.docker.api.builder.Predicate<Long> predicate){
            for (Long item: percpuUsage) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withPercpuUsage(List<Long> percpuUsage){
            this.percpuUsage.clear();
            if (percpuUsage != null) {for (Long item : percpuUsage){this.addToPercpuUsage(item);}} return (A) this;
    }

    public A withPercpuUsage(Long... percpuUsage){
            this.percpuUsage.clear(); if (percpuUsage != null) {for (Long item :percpuUsage){ this.addToPercpuUsage(item);}} return (A) this;
    }

    public Boolean hasPercpuUsage(){
            return percpuUsage!= null && !percpuUsage.isEmpty();
    }

    public Long getTotalUsage(){
            return this.totalUsage;
    }

    public A withTotalUsage(Long totalUsage){
            this.totalUsage=totalUsage; return (A) this;
    }

    public Boolean hasTotalUsage(){
            return this.totalUsage!=null;
    }

    public Long getUsageInKernelmode(){
            return this.usageInKernelmode;
    }

    public A withUsageInKernelmode(Long usageInKernelmode){
            this.usageInKernelmode=usageInKernelmode; return (A) this;
    }

    public Boolean hasUsageInKernelmode(){
            return this.usageInKernelmode!=null;
    }

    public Long getUsageInUsermode(){
            return this.usageInUsermode;
    }

    public A withUsageInUsermode(Long usageInUsermode){
            this.usageInUsermode=usageInUsermode; return (A) this;
    }

    public Boolean hasUsageInUsermode(){
            return this.usageInUsermode!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CPUUsageFluentImpl that = (CPUUsageFluentImpl) o;
            if (percpuUsage != null ? !percpuUsage.equals(that.percpuUsage) :that.percpuUsage != null) return false;
            if (totalUsage != null ? !totalUsage.equals(that.totalUsage) :that.totalUsage != null) return false;
            if (usageInKernelmode != null ? !usageInKernelmode.equals(that.usageInKernelmode) :that.usageInKernelmode != null) return false;
            if (usageInUsermode != null ? !usageInUsermode.equals(that.usageInUsermode) :that.usageInUsermode != null) return false;
            return true;
    }




}
