package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.docker.api.builder.Fluent;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface BlkioStatsFluent<A extends BlkioStatsFluent<A>> extends Fluent<A>{


    public A addToIoMergedRecursive(int index,BlkioStatEntry item);
    public A setToIoMergedRecursive(int index,BlkioStatEntry item);
    public A addToIoMergedRecursive(BlkioStatEntry... items);
    public A addAllToIoMergedRecursive(Collection<BlkioStatEntry> items);
    public A removeFromIoMergedRecursive(BlkioStatEntry... items);
    public A removeAllFromIoMergedRecursive(Collection<BlkioStatEntry> items);
    
/**
 * This method has been deprecated, please use method buildIoMergedRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoMergedRecursive();
    public List<BlkioStatEntry> buildIoMergedRecursive();
    public BlkioStatEntry buildIoMergedRecursive(int index);
    public BlkioStatEntry buildFirstIoMergedRecursive();
    public BlkioStatEntry buildLastIoMergedRecursive();
    public BlkioStatEntry buildMatchingIoMergedRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A withIoMergedRecursive(List<BlkioStatEntry> ioMergedRecursive);
    public A withIoMergedRecursive(BlkioStatEntry... ioMergedRecursive);
    public Boolean hasIoMergedRecursive();
    public BlkioStatsFluent.IoMergedRecursiveNested<A> addNewIoMergedRecursive();
    public BlkioStatsFluent.IoMergedRecursiveNested<A> addNewIoMergedRecursiveLike(BlkioStatEntry item);
    public BlkioStatsFluent.IoMergedRecursiveNested<A> setNewIoMergedRecursiveLike(int index,BlkioStatEntry item);
    public BlkioStatsFluent.IoMergedRecursiveNested<A> editIoMergedRecursive(int index);
    public BlkioStatsFluent.IoMergedRecursiveNested<A> editFirstIoMergedRecursive();
    public BlkioStatsFluent.IoMergedRecursiveNested<A> editLastIoMergedRecursive();
    public BlkioStatsFluent.IoMergedRecursiveNested<A> editMatchingIoMergedRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A addNewIoMergedRecursive(Long major,Long minor,String op,Long value);
    public A addToIoQueueRecursive(int index,BlkioStatEntry item);
    public A setToIoQueueRecursive(int index,BlkioStatEntry item);
    public A addToIoQueueRecursive(BlkioStatEntry... items);
    public A addAllToIoQueueRecursive(Collection<BlkioStatEntry> items);
    public A removeFromIoQueueRecursive(BlkioStatEntry... items);
    public A removeAllFromIoQueueRecursive(Collection<BlkioStatEntry> items);
    
/**
 * This method has been deprecated, please use method buildIoQueueRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoQueueRecursive();
    public List<BlkioStatEntry> buildIoQueueRecursive();
    public BlkioStatEntry buildIoQueueRecursive(int index);
    public BlkioStatEntry buildFirstIoQueueRecursive();
    public BlkioStatEntry buildLastIoQueueRecursive();
    public BlkioStatEntry buildMatchingIoQueueRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A withIoQueueRecursive(List<BlkioStatEntry> ioQueueRecursive);
    public A withIoQueueRecursive(BlkioStatEntry... ioQueueRecursive);
    public Boolean hasIoQueueRecursive();
    public BlkioStatsFluent.IoQueueRecursiveNested<A> addNewIoQueueRecursive();
    public BlkioStatsFluent.IoQueueRecursiveNested<A> addNewIoQueueRecursiveLike(BlkioStatEntry item);
    public BlkioStatsFluent.IoQueueRecursiveNested<A> setNewIoQueueRecursiveLike(int index,BlkioStatEntry item);
    public BlkioStatsFluent.IoQueueRecursiveNested<A> editIoQueueRecursive(int index);
    public BlkioStatsFluent.IoQueueRecursiveNested<A> editFirstIoQueueRecursive();
    public BlkioStatsFluent.IoQueueRecursiveNested<A> editLastIoQueueRecursive();
    public BlkioStatsFluent.IoQueueRecursiveNested<A> editMatchingIoQueueRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A addNewIoQueueRecursive(Long major,Long minor,String op,Long value);
    public A addToIoServiceBytesRecursive(int index,BlkioStatEntry item);
    public A setToIoServiceBytesRecursive(int index,BlkioStatEntry item);
    public A addToIoServiceBytesRecursive(BlkioStatEntry... items);
    public A addAllToIoServiceBytesRecursive(Collection<BlkioStatEntry> items);
    public A removeFromIoServiceBytesRecursive(BlkioStatEntry... items);
    public A removeAllFromIoServiceBytesRecursive(Collection<BlkioStatEntry> items);
    
/**
 * This method has been deprecated, please use method buildIoServiceBytesRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoServiceBytesRecursive();
    public List<BlkioStatEntry> buildIoServiceBytesRecursive();
    public BlkioStatEntry buildIoServiceBytesRecursive(int index);
    public BlkioStatEntry buildFirstIoServiceBytesRecursive();
    public BlkioStatEntry buildLastIoServiceBytesRecursive();
    public BlkioStatEntry buildMatchingIoServiceBytesRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A withIoServiceBytesRecursive(List<BlkioStatEntry> ioServiceBytesRecursive);
    public A withIoServiceBytesRecursive(BlkioStatEntry... ioServiceBytesRecursive);
    public Boolean hasIoServiceBytesRecursive();
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> addNewIoServiceBytesRecursive();
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> addNewIoServiceBytesRecursiveLike(BlkioStatEntry item);
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> setNewIoServiceBytesRecursiveLike(int index,BlkioStatEntry item);
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editIoServiceBytesRecursive(int index);
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editFirstIoServiceBytesRecursive();
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editLastIoServiceBytesRecursive();
    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editMatchingIoServiceBytesRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A addNewIoServiceBytesRecursive(Long major,Long minor,String op,Long value);
    public A addToIoServiceTimeRecursive(int index,BlkioStatEntry item);
    public A setToIoServiceTimeRecursive(int index,BlkioStatEntry item);
    public A addToIoServiceTimeRecursive(BlkioStatEntry... items);
    public A addAllToIoServiceTimeRecursive(Collection<BlkioStatEntry> items);
    public A removeFromIoServiceTimeRecursive(BlkioStatEntry... items);
    public A removeAllFromIoServiceTimeRecursive(Collection<BlkioStatEntry> items);
    
/**
 * This method has been deprecated, please use method buildIoServiceTimeRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoServiceTimeRecursive();
    public List<BlkioStatEntry> buildIoServiceTimeRecursive();
    public BlkioStatEntry buildIoServiceTimeRecursive(int index);
    public BlkioStatEntry buildFirstIoServiceTimeRecursive();
    public BlkioStatEntry buildLastIoServiceTimeRecursive();
    public BlkioStatEntry buildMatchingIoServiceTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A withIoServiceTimeRecursive(List<BlkioStatEntry> ioServiceTimeRecursive);
    public A withIoServiceTimeRecursive(BlkioStatEntry... ioServiceTimeRecursive);
    public Boolean hasIoServiceTimeRecursive();
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> addNewIoServiceTimeRecursive();
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> addNewIoServiceTimeRecursiveLike(BlkioStatEntry item);
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> setNewIoServiceTimeRecursiveLike(int index,BlkioStatEntry item);
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editIoServiceTimeRecursive(int index);
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editFirstIoServiceTimeRecursive();
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editLastIoServiceTimeRecursive();
    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editMatchingIoServiceTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A addNewIoServiceTimeRecursive(Long major,Long minor,String op,Long value);
    public A addToIoServicedRecursive(int index,BlkioStatEntry item);
    public A setToIoServicedRecursive(int index,BlkioStatEntry item);
    public A addToIoServicedRecursive(BlkioStatEntry... items);
    public A addAllToIoServicedRecursive(Collection<BlkioStatEntry> items);
    public A removeFromIoServicedRecursive(BlkioStatEntry... items);
    public A removeAllFromIoServicedRecursive(Collection<BlkioStatEntry> items);
    
/**
 * This method has been deprecated, please use method buildIoServicedRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoServicedRecursive();
    public List<BlkioStatEntry> buildIoServicedRecursive();
    public BlkioStatEntry buildIoServicedRecursive(int index);
    public BlkioStatEntry buildFirstIoServicedRecursive();
    public BlkioStatEntry buildLastIoServicedRecursive();
    public BlkioStatEntry buildMatchingIoServicedRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A withIoServicedRecursive(List<BlkioStatEntry> ioServicedRecursive);
    public A withIoServicedRecursive(BlkioStatEntry... ioServicedRecursive);
    public Boolean hasIoServicedRecursive();
    public BlkioStatsFluent.IoServicedRecursiveNested<A> addNewIoServicedRecursive();
    public BlkioStatsFluent.IoServicedRecursiveNested<A> addNewIoServicedRecursiveLike(BlkioStatEntry item);
    public BlkioStatsFluent.IoServicedRecursiveNested<A> setNewIoServicedRecursiveLike(int index,BlkioStatEntry item);
    public BlkioStatsFluent.IoServicedRecursiveNested<A> editIoServicedRecursive(int index);
    public BlkioStatsFluent.IoServicedRecursiveNested<A> editFirstIoServicedRecursive();
    public BlkioStatsFluent.IoServicedRecursiveNested<A> editLastIoServicedRecursive();
    public BlkioStatsFluent.IoServicedRecursiveNested<A> editMatchingIoServicedRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A addNewIoServicedRecursive(Long major,Long minor,String op,Long value);
    public A addToIoTimeRecursive(int index,BlkioStatEntry item);
    public A setToIoTimeRecursive(int index,BlkioStatEntry item);
    public A addToIoTimeRecursive(BlkioStatEntry... items);
    public A addAllToIoTimeRecursive(Collection<BlkioStatEntry> items);
    public A removeFromIoTimeRecursive(BlkioStatEntry... items);
    public A removeAllFromIoTimeRecursive(Collection<BlkioStatEntry> items);
    
/**
 * This method has been deprecated, please use method buildIoTimeRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoTimeRecursive();
    public List<BlkioStatEntry> buildIoTimeRecursive();
    public BlkioStatEntry buildIoTimeRecursive(int index);
    public BlkioStatEntry buildFirstIoTimeRecursive();
    public BlkioStatEntry buildLastIoTimeRecursive();
    public BlkioStatEntry buildMatchingIoTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A withIoTimeRecursive(List<BlkioStatEntry> ioTimeRecursive);
    public A withIoTimeRecursive(BlkioStatEntry... ioTimeRecursive);
    public Boolean hasIoTimeRecursive();
    public BlkioStatsFluent.IoTimeRecursiveNested<A> addNewIoTimeRecursive();
    public BlkioStatsFluent.IoTimeRecursiveNested<A> addNewIoTimeRecursiveLike(BlkioStatEntry item);
    public BlkioStatsFluent.IoTimeRecursiveNested<A> setNewIoTimeRecursiveLike(int index,BlkioStatEntry item);
    public BlkioStatsFluent.IoTimeRecursiveNested<A> editIoTimeRecursive(int index);
    public BlkioStatsFluent.IoTimeRecursiveNested<A> editFirstIoTimeRecursive();
    public BlkioStatsFluent.IoTimeRecursiveNested<A> editLastIoTimeRecursive();
    public BlkioStatsFluent.IoTimeRecursiveNested<A> editMatchingIoTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A addNewIoTimeRecursive(Long major,Long minor,String op,Long value);
    public A addToIoWaitTimeRecursive(int index,BlkioStatEntry item);
    public A setToIoWaitTimeRecursive(int index,BlkioStatEntry item);
    public A addToIoWaitTimeRecursive(BlkioStatEntry... items);
    public A addAllToIoWaitTimeRecursive(Collection<BlkioStatEntry> items);
    public A removeFromIoWaitTimeRecursive(BlkioStatEntry... items);
    public A removeAllFromIoWaitTimeRecursive(Collection<BlkioStatEntry> items);
    
/**
 * This method has been deprecated, please use method buildIoWaitTimeRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoWaitTimeRecursive();
    public List<BlkioStatEntry> buildIoWaitTimeRecursive();
    public BlkioStatEntry buildIoWaitTimeRecursive(int index);
    public BlkioStatEntry buildFirstIoWaitTimeRecursive();
    public BlkioStatEntry buildLastIoWaitTimeRecursive();
    public BlkioStatEntry buildMatchingIoWaitTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A withIoWaitTimeRecursive(List<BlkioStatEntry> ioWaitTimeRecursive);
    public A withIoWaitTimeRecursive(BlkioStatEntry... ioWaitTimeRecursive);
    public Boolean hasIoWaitTimeRecursive();
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> addNewIoWaitTimeRecursive();
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> addNewIoWaitTimeRecursiveLike(BlkioStatEntry item);
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> setNewIoWaitTimeRecursiveLike(int index,BlkioStatEntry item);
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editIoWaitTimeRecursive(int index);
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editFirstIoWaitTimeRecursive();
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editLastIoWaitTimeRecursive();
    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editMatchingIoWaitTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A addNewIoWaitTimeRecursive(Long major,Long minor,String op,Long value);
    public A addToSectorsRecursive(int index,BlkioStatEntry item);
    public A setToSectorsRecursive(int index,BlkioStatEntry item);
    public A addToSectorsRecursive(BlkioStatEntry... items);
    public A addAllToSectorsRecursive(Collection<BlkioStatEntry> items);
    public A removeFromSectorsRecursive(BlkioStatEntry... items);
    public A removeAllFromSectorsRecursive(Collection<BlkioStatEntry> items);
    
/**
 * This method has been deprecated, please use method buildSectorsRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getSectorsRecursive();
    public List<BlkioStatEntry> buildSectorsRecursive();
    public BlkioStatEntry buildSectorsRecursive(int index);
    public BlkioStatEntry buildFirstSectorsRecursive();
    public BlkioStatEntry buildLastSectorsRecursive();
    public BlkioStatEntry buildMatchingSectorsRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A withSectorsRecursive(List<BlkioStatEntry> sectorsRecursive);
    public A withSectorsRecursive(BlkioStatEntry... sectorsRecursive);
    public Boolean hasSectorsRecursive();
    public BlkioStatsFluent.SectorsRecursiveNested<A> addNewSectorsRecursive();
    public BlkioStatsFluent.SectorsRecursiveNested<A> addNewSectorsRecursiveLike(BlkioStatEntry item);
    public BlkioStatsFluent.SectorsRecursiveNested<A> setNewSectorsRecursiveLike(int index,BlkioStatEntry item);
    public BlkioStatsFluent.SectorsRecursiveNested<A> editSectorsRecursive(int index);
    public BlkioStatsFluent.SectorsRecursiveNested<A> editFirstSectorsRecursive();
    public BlkioStatsFluent.SectorsRecursiveNested<A> editLastSectorsRecursive();
    public BlkioStatsFluent.SectorsRecursiveNested<A> editMatchingSectorsRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate);
    public A addNewSectorsRecursive(Long major,Long minor,String op,Long value);

    public interface IoMergedRecursiveNested<N> extends io.fabric8.docker.api.builder.Nested<N>,BlkioStatEntryFluent<BlkioStatsFluent.IoMergedRecursiveNested<N>>{

        
    public N and();    public N endIoMergedRecursive();
}
    public interface IoQueueRecursiveNested<N> extends io.fabric8.docker.api.builder.Nested<N>,BlkioStatEntryFluent<BlkioStatsFluent.IoQueueRecursiveNested<N>>{

        
    public N and();    public N endIoQueueRecursive();
}
    public interface IoServiceBytesRecursiveNested<N> extends io.fabric8.docker.api.builder.Nested<N>,BlkioStatEntryFluent<BlkioStatsFluent.IoServiceBytesRecursiveNested<N>>{

        
    public N and();    public N endIoServiceBytesRecursive();
}
    public interface IoServiceTimeRecursiveNested<N> extends io.fabric8.docker.api.builder.Nested<N>,BlkioStatEntryFluent<BlkioStatsFluent.IoServiceTimeRecursiveNested<N>>{

        
    public N and();    public N endIoServiceTimeRecursive();
}
    public interface IoServicedRecursiveNested<N> extends io.fabric8.docker.api.builder.Nested<N>,BlkioStatEntryFluent<BlkioStatsFluent.IoServicedRecursiveNested<N>>{

        
    public N and();    public N endIoServicedRecursive();
}
    public interface IoTimeRecursiveNested<N> extends io.fabric8.docker.api.builder.Nested<N>,BlkioStatEntryFluent<BlkioStatsFluent.IoTimeRecursiveNested<N>>{

        
    public N and();    public N endIoTimeRecursive();
}
    public interface IoWaitTimeRecursiveNested<N> extends io.fabric8.docker.api.builder.Nested<N>,BlkioStatEntryFluent<BlkioStatsFluent.IoWaitTimeRecursiveNested<N>>{

        
    public N and();    public N endIoWaitTimeRecursive();
}
    public interface SectorsRecursiveNested<N> extends io.fabric8.docker.api.builder.Nested<N>,BlkioStatEntryFluent<BlkioStatsFluent.SectorsRecursiveNested<N>>{

        
    public N and();    public N endSectorsRecursive();
}


}
